/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.container.machine;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import unhappycodings.thoriumreactors.client.gui.widgets.ModButton;
import unhappycodings.thoriumreactors.client.util.RenderUtil;
import unhappycodings.thoriumreactors.common.blockentity.machine.MachineElectrolyticSaltSeparatorBlockEntity;
import unhappycodings.thoriumreactors.common.container.base.screen.MachineScreen;
import unhappycodings.thoriumreactors.common.container.machine.MachineElectrolyticSaltSeparatorContainer;
import unhappycodings.thoriumreactors.common.util.FormattingUtil;
import unhappycodings.thoriumreactors.common.util.ScreenUtil;

public class MachineElectrolyticSaltSeparatorScreen
extends MachineScreen<MachineElectrolyticSaltSeparatorContainer> {
    private MachineElectrolyticSaltSeparatorContainer container;

    public MachineElectrolyticSaltSeparatorScreen(MachineElectrolyticSaltSeparatorContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.container = screenContainer;
    }

    @Override
    protected void addButtons() {
        super.addButtons();
        this.addElements();
    }

    protected void addElements() {
        MachineElectrolyticSaltSeparatorBlockEntity tile = ((MachineElectrolyticSaltSeparatorContainer)this.m_6262_()).getTile();
        this.m_7787_((GuiEventListener)new ModButton(34, 90, 3, 8, null, () -> this.changeDumpMode("input"), null, (BlockEntity)tile, this, 0, 0, true));
        this.m_7787_((GuiEventListener)new ModButton(37, 90, 19, 8, null, () -> this.changeDumpMode("dumpInput"), null, (BlockEntity)tile, this, 0, 0, true));
        this.m_7787_((GuiEventListener)new ModButton(116, 90, 3, 8, null, () -> this.changeDumpMode("output"), null, (BlockEntity)tile, this, 0, 0, true));
        this.m_7787_((GuiEventListener)new ModButton(119, 90, 19, 8, null, () -> this.changeDumpMode("dumpOutput"), null, (BlockEntity)tile, this, 0, 0, true));
    }

    @Override
    protected void m_7286_(@NotNull GuiGraphics graphics, float partialTicks, int x, int y) {
        super.m_7286_(graphics, partialTicks, x, y);
        MachineElectrolyticSaltSeparatorBlockEntity entity = this.container.getTile();
        RenderUtil.renderFluid(this.getGuiLeft() + 36, this.getGuiTop() + 64, 45, 16, entity.getFluidAmountIn(), entity.getFluidCapacityIn(), (Fluid)Fluids.f_76193_);
        RenderUtil.renderFluid(this.getGuiLeft() + 36 + 16, this.getGuiTop() + 64, 45, 2, entity.getFluidAmountIn(), entity.getFluidCapacityIn(), (Fluid)Fluids.f_76193_);
        RenderUtil.renderFluid(this.getGuiLeft() + 118, this.getGuiTop() + 64, 23, 16, entity.getFluidAmountOut(), entity.getFluidCapacityOut(), (Fluid)Fluids.f_76193_);
        RenderUtil.renderFluid(this.getGuiLeft() + 118 + 16, this.getGuiTop() + 64, 23, 2, entity.getFluidAmountOut(), entity.getFluidCapacityOut(), (Fluid)Fluids.f_76193_);
        if (entity.getState()) {
            for (int i = 0; i < 64; i += 16) {
                RenderUtil.renderFluid(this.getGuiLeft() + 54 + i, this.getGuiTop() + 48, 1, 16, 1, 1, (Fluid)Fluids.f_76193_);
            }
        }
        RenderUtil.resetGuiTextures(this.getTexture());
        int energyBlitSize = (int)Math.floor(38.0 / (25000.0 / (double)entity.getEnergy()));
        graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 153, this.getGuiTop() + 25 + (38 - energyBlitSize), 176, 14, 9, energyBlitSize);
        graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 119, this.getGuiTop() + 42, 180, 52, 2, 22);
        graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 37, this.getGuiTop() + 20, 176, 52, 4, 45);
        int height = entity.getMaxRecipeTime() != 0 ? 6 - (int)Math.floor((float)entity.getRecipeTime() / 200.0f * 6.0f) : 0;
        graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 77, this.getGuiTop() + 39 + (6 - height), 185, 6 - height, 20, height);
        graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 77, this.getGuiTop() + 52, 185, 13, 20, height);
        if (entity.getEnergy() > 0) {
            graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 77, this.getGuiTop() + 34, 185, 19, 21, 3);
            graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 77, this.getGuiTop() + 60, 185, 22, 21, 3);
        }
        if (entity.isInputDump()) {
            graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 35, this.getGuiTop() + 91, 185, 25, 1, 3);
        } else {
            graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 35, this.getGuiTop() + 94, 185, 28, 1, 3);
        }
        if (entity.isOutputDump()) {
            graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 117, this.getGuiTop() + 91, 185, 25, 1, 3);
        } else {
            graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 117, this.getGuiTop() + 94, 185, 28, 1, 3);
        }
        if (entity.getState()) {
            graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 81, this.getGuiTop() + 89, 185, 25, 6, 1);
        } else {
            graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 88, this.getGuiTop() + 89, 185, 28, 6, 1);
        }
    }

    @Override
    protected void m_280003_(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY) {
        super.m_280003_(graphics, pMouseX, pMouseY);
        MachineElectrolyticSaltSeparatorBlockEntity entity = this.container.getTile();
        PoseStack pPoseStack = graphics.m_280168_();
        ScreenUtil.drawText(Component.m_237115_((String)"key.categories.inventory").m_130938_(ScreenUtil::notoSans), graphics, 8, 102, 0xAAAAAA);
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.7f, 0.7f, 0.7f);
        ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("machines.electrolytic_salt_separator.name")).m_130938_(ScreenUtil::notoSans), graphics, 10, 2, 0xAAAAAA);
        ScreenUtil.drawRightboundText(Component.m_237113_((String)Minecraft.m_91087_().f_91074_.m_6302_()).m_130938_(ScreenUtil::notoSans), graphics, 242, 2, 0xAAAAAA);
        pPoseStack.m_85849_();
        ScreenUtil.drawCenteredText(Component.m_237115_((String)(entity.getState() ? FormattingUtil.getTranslatable("machines.state.running") : FormattingUtil.getTranslatable("machines.state.idle"))).m_130938_(ScreenUtil::notoSans), graphics, 87, 78, 4182051);
        if (ScreenUtil.mouseInArea(this.getGuiLeft() + 153, this.getGuiTop() + 25, this.getGuiLeft() + 161, this.getGuiTop() + 62, pMouseX, pMouseY)) {
            this.appendHoverText(graphics, pMouseX, pMouseY, new String[]{FormattingUtil.formatEnergy(entity.getEnergy()) + " / " + FormattingUtil.formatEnergy(entity.getCapacity()), FormattingUtil.formatPercentNum(entity.getEnergy(), entity.getCapacity(), true)});
        }
        if (ScreenUtil.mouseInArea(this.getGuiLeft() + 37, this.getGuiTop() + 20, this.getGuiLeft() + 54, this.getGuiTop() + 64, pMouseX, pMouseY)) {
            this.appendHoverText(graphics, pMouseX, pMouseY, new Component[]{entity.getFluidAmountIn() > 0 ? Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.fluid")).m_130946_(" ").m_130946_(entity.getFluidIn().getFluid().getFluidType().getDescription().getString()) : Component.m_237119_(), Component.m_237113_((String)(entity.getFluidAmountIn() + " mB / " + entity.getFluidCapacityIn() + " mB")), Component.m_237113_((String)FormattingUtil.formatPercentNum(entity.getFluidAmountIn(), entity.getFluidCapacityIn(), true))});
        }
        if (ScreenUtil.mouseInArea(this.getGuiLeft() + 119, this.getGuiTop() + 42, this.getGuiLeft() + 136, this.getGuiTop() + 64, pMouseX, pMouseY)) {
            this.appendHoverText(graphics, pMouseX, pMouseY, new Component[]{entity.getFluidAmountOut() > 0 ? Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.fluid")).m_130946_(" ").m_130946_(entity.getFluidOut().getFluid().getFluidType().getDescription().getString()) : Component.m_237119_(), Component.m_237113_((String)(entity.getFluidAmountOut() + " mB / " + entity.getFluidCapacityOut() + " mB")), Component.m_237113_((String)FormattingUtil.formatPercentNum(entity.getFluidAmountOut(), entity.getFluidCapacityOut(), true))});
        }
        if (ScreenUtil.mouseInArea(this.getGuiLeft() + 34, this.getGuiTop() + 90, this.getGuiLeft() + 36, this.getGuiTop() + 97, pMouseX, pMouseY)) {
            this.appendHoverText(graphics, pMouseX, pMouseY, new Component[]{Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.auto_dump")).m_130946_(" " + entity.isInputDump()), Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.only_while_running"))});
        }
        if (ScreenUtil.mouseInArea(this.getGuiLeft() + 116, this.getGuiTop() + 90, this.getGuiLeft() + 118, this.getGuiTop() + 97, pMouseX, pMouseY)) {
            this.appendHoverText(graphics, pMouseX, pMouseY, new Component[]{Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.auto_dump")).m_130946_(" " + entity.isOutputDump()), Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.only_while_running"))});
        }
        if (ScreenUtil.mouseInArea(this.getGuiLeft() + 37, this.getGuiTop() + 90, this.getGuiLeft() + 55, this.getGuiTop() + 97, pMouseX, pMouseY) || ScreenUtil.mouseInArea(this.getGuiLeft() + 119, this.getGuiTop() + 90, this.getGuiLeft() + 137, this.getGuiTop() + 97, pMouseX, pMouseY)) {
            this.appendHoverText(graphics, pMouseX, pMouseY, new Component[]{Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.dump_instantly"))});
        }
    }

    @Override
    public void m_7379_() {
        ((MachineElectrolyticSaltSeparatorContainer)this.m_6262_()).getTile().m_6596_();
        super.m_7379_();
    }

    @Override
    public int getSizeX() {
        return 176;
    }

    @Override
    public int getSizeY() {
        return 194;
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("thoriumreactors", "textures/gui/electrolytic_salt_separator_gui.png");
    }
}

