/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.blockentity.turbine;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.common.block.machine.MachineGeneratorBlock;
import unhappycodings.thoriumreactors.common.block.turbine.TurbinePowerPortBlock;
import unhappycodings.thoriumreactors.common.blockentity.turbine.base.TurbineFrameBlockEntity;
import unhappycodings.thoriumreactors.common.energy.IEnergyCapable;
import unhappycodings.thoriumreactors.common.energy.ModEnergyStorage;
import unhappycodings.thoriumreactors.common.registration.ModBlockEntities;
import unhappycodings.thoriumreactors.common.util.EnergyUtil;

public class TurbinePowerPortBlockEntity
extends TurbineFrameBlockEntity
implements IEnergyCapable {
    public static final int MAX_POWER = 124102300;
    public static final int MAX_TRANSFER = 62051150;
    private LazyOptional<ModEnergyStorage> lazyEnergyHandler = LazyOptional.empty();
    private final ModEnergyStorage ENERGY_STORAGE = new ModEnergyStorage(124102300, 62051150){

        @Override
        public void onEnergyChanged() {
            TurbinePowerPortBlockEntity.this.m_6596_();
            this.energy = TurbinePowerPortBlockEntity.this.ENERGY_STORAGE.getEnergyStored();
        }

        public boolean canReceive() {
            return false;
        }
    };

    public TurbinePowerPortBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.TURBINE_POWER_PORT.get(), pPos, pBlockState);
    }

    public void tick() {
        EnergyUtil.trySendToNeighbors(this.f_58857_, this.m_58899_(), this.ENERGY_STORAGE, this.getEnergy(), (int)this.getMaxEnergyTransfer());
    }

    public void onLoad() {
        super.onLoad();
        this.lazyEnergyHandler = LazyOptional.of(() -> this.ENERGY_STORAGE);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)TurbinePowerPortBlock.FACING);
        if (cap == ForgeCapabilities.ENERGY && side != null && facing == side) {
            return this.lazyEnergyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("Energy", this.getEnergy());
        return nbt;
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        this.setEnergy(tag.m_128451_("Energy"));
    }

    @Override
    public void m_183515_(@NotNull CompoundTag nbt) {
        nbt.m_128405_("Energy", this.getEnergy());
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        this.setEnergy(nbt.m_128451_("Energy"));
    }

    public ModEnergyStorage getEnergyStorage() {
        return this.ENERGY_STORAGE;
    }

    @Override
    public boolean canInputEnergy() {
        return false;
    }

    @Override
    public boolean canOutputEnergy(Direction direction) {
        return ((Direction)this.m_58900_().m_61143_((Property)MachineGeneratorBlock.FACING)).m_122424_() == direction;
    }

    public int getEnergy() {
        return this.ENERGY_STORAGE.getEnergyStored();
    }

    @Override
    public void setEnergy(int energy) {
        this.ENERGY_STORAGE.setEnergy(energy);
    }

    public int getCapacity() {
        return this.ENERGY_STORAGE.getMaxEnergyStored();
    }

    @Override
    public void setCapacity(int capacity) {
    }

    @Override
    public long getEnergyStored() {
        return this.ENERGY_STORAGE.getEnergyStored();
    }

    @Override
    public long getEnergyCapacity() {
        return 124102300L;
    }

    @Override
    public long getMaxEnergyTransfer() {
        return 62051150L;
    }

    @Override
    public int getEnergyDrain() {
        return 0;
    }

    @Override
    public long removeEnergy(long energy, boolean simulate) {
        return this.ENERGY_STORAGE.extractEnergy((int)energy, simulate);
    }

    @Override
    public long addEnergy(long energy, boolean simulate) {
        return this.ENERGY_STORAGE.receiveEnergy((int)energy, simulate);
    }
}

