/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.blockentity.thermal;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.common.block.thermal.ThermalValveBlock;
import unhappycodings.thoriumreactors.common.blockentity.ModFluidTank;
import unhappycodings.thoriumreactors.common.blockentity.thermal.ThermalValveBlockEntity;
import unhappycodings.thoriumreactors.common.blockentity.thermal.base.ThermalFrameBlockEntity;
import unhappycodings.thoriumreactors.common.enums.ThermalValveTypeEnum;
import unhappycodings.thoriumreactors.common.registration.ModBlockEntities;
import unhappycodings.thoriumreactors.common.registration.ModBlocks;
import unhappycodings.thoriumreactors.common.registration.ModFluids;

public class ThermalControllerBlockEntity
extends ThermalFrameBlockEntity {
    public List<BlockPos> valvePos = new ArrayList<BlockPos>(4);
    public boolean assembled;
    int conversions = 0;
    private final ModFluidTank FLUID_TANK_IN = new ModFluidTank(1000, true, true, 0, FluidStack.EMPTY);

    public ThermalControllerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.THERMAL_CONTROLLER.get(), pPos, pBlockState);
    }

    public void onLoad() {
        super.onLoad();
        this.updateBlock();
    }

    public void tick() {
        if (this.isAssembled()) {
            if (this.valvePos == null) {
                return;
            }
            for (BlockPos pos : this.valvePos) {
                BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
                if (!(blockEntity instanceof ThermalValveBlockEntity)) {
                    return;
                }
                ThermalValveBlockEntity entity = (ThermalValveBlockEntity)blockEntity;
                if (this.f_58857_.m_8055_(pos).m_61143_(ThermalValveBlock.TYPE) == ThermalValveTypeEnum.HEATING_FLUID_INPUT) {
                    entity.getCapability(ForgeCapabilities.FLUID_HANDLER, (Direction)this.f_58857_.m_8055_(pos).m_61143_((Property)ThermalValveBlock.FACING)).ifPresent(storage -> {
                        FluidStack fluidExternal = storage.getFluidInTank(0);
                        int amount = fluidExternal.getAmount();
                        if (fluidExternal.getFluid().m_6212_((Fluid)ModFluids.SOURCE_HEATED_MOLTEN_SALT.get()) && amount > 0) {
                            if (this.FLUID_TANK_IN.getFluid().isEmpty()) {
                                this.FLUID_TANK_IN.setFluid(new FluidStack((Fluid)ModFluids.SOURCE_HEATED_MOLTEN_SALT.get(), amount));
                                storage.getFluidInTank(0).shrink(amount);
                            } else if (this.getFluidAmountIn() + amount <= this.getFluidCapacityIn()) {
                                this.getFluidIn().grow(amount);
                                storage.getFluidInTank(0).shrink(amount);
                            }
                        }
                    });
                }
                if (this.f_58857_.m_8055_(pos).m_61143_(ThermalValveBlock.TYPE) == ThermalValveTypeEnum.HEATING_FLUID_OUTPUT) {
                    entity.getCapability(ForgeCapabilities.FLUID_HANDLER, (Direction)this.f_58857_.m_8055_(pos).m_61143_((Property)ThermalValveBlock.FACING)).ifPresent(storage -> {
                        int fillable;
                        int amount = Math.min(this.getFluidAmountIn(), 10);
                        if (this.getFluidIn().getFluid().m_6212_((Fluid)ModFluids.SOURCE_HEATED_MOLTEN_SALT.get()) && amount > 0 && (fillable = storage.fill(new FluidStack((Fluid)ModFluids.SOURCE_DEPLETED_MOLTEN_SALT.get(), amount), IFluidHandler.FluidAction.SIMULATE)) > 0 && this.conversions + fillable <= 1000) {
                            storage.fill(new FluidStack((Fluid)ModFluids.SOURCE_DEPLETED_MOLTEN_SALT.get(), fillable), IFluidHandler.FluidAction.EXECUTE);
                            this.conversions += amount;
                            this.getFluidIn().shrink(fillable);
                        }
                    });
                }
                if (this.f_58857_.m_8055_(pos).m_61143_(ThermalValveBlock.TYPE) != ThermalValveTypeEnum.COOLANT_INPUT || this.conversions < 10) continue;
                entity.getCapability(ForgeCapabilities.FLUID_HANDLER, (Direction)this.f_58857_.m_8055_(pos).m_61143_((Property)ThermalValveBlock.FACING)).ifPresent(storageInput -> {
                    FluidStack coolantIn = storageInput.getFluidInTank(0);
                    int amount = Math.min(coolantIn.getAmount(), 5);
                    if (amount > 0 && coolantIn.getFluid().m_6212_((Fluid)Fluids.f_76193_)) {
                        for (BlockPos blockPos : this.valvePos) {
                            if (!this.f_58857_.m_8055_(blockPos).m_60713_((Block)ModBlocks.THERMAL_VALVE.get())) {
                                return;
                            }
                            if (this.f_58857_.m_8055_(blockPos).m_61143_(ThermalValveBlock.TYPE) != ThermalValveTypeEnum.COOLANT_OUTPUT) continue;
                            ThermalValveBlockEntity valveBlock = (ThermalValveBlockEntity)this.f_58857_.m_7702_(blockPos);
                            valveBlock.getCapability(ForgeCapabilities.FLUID_HANDLER, (Direction)valveBlock.m_58900_().m_61143_((Property)ThermalValveBlock.FACING)).ifPresent(storageOutput -> {
                                FluidStack coolantOut = storageOutput.getFluidInTank(0);
                                if (coolantOut.getAmount() + amount * 1300 <= storageOutput.getTankCapacity(0)) {
                                    coolantIn.shrink(amount);
                                    storageOutput.fill(new FluidStack((Fluid)ModFluids.SOURCE_STEAM.get(), amount * 1300), IFluidHandler.FluidAction.EXECUTE);
                                    this.conversions -= 10;
                                }
                            });
                        }
                    }
                });
            }
        }
    }

    public FluidStack getFluidIn() {
        return this.FLUID_TANK_IN.getFluid();
    }

    public void setFluidIn(FluidStack stack) {
        this.FLUID_TANK_IN.setFluid(stack);
    }

    public int getFluidCapacityIn() {
        return this.FLUID_TANK_IN.getCapacity();
    }

    public int getFluidSpaceIn() {
        return this.FLUID_TANK_IN.getSpace();
    }

    public int getFluidAmountIn() {
        return this.FLUID_TANK_IN.getFluidAmount();
    }

    public int getConversions() {
        return this.conversions;
    }

    public void setConversions(int conversions) {
        this.conversions = conversions;
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128379_("Assembled", this.isAssembled());
        nbt.m_128405_("Conversions", this.conversions);
        nbt.m_128365_("FluidIn", (Tag)this.FLUID_TANK_IN.writeToNBT(new CompoundTag()));
        for (int i = 0; i < 4; ++i) {
            if (this.valvePos == null || this.valvePos.size() <= i) continue;
            nbt.m_128365_("ValvePos-" + (i + 1), (Tag)this.parsePosToTag(this.valvePos.get(i)));
        }
        return nbt;
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        this.setAssembled(tag.m_128471_("Assembled"));
        this.setConversions(tag.m_128451_("Conversions"));
        this.FLUID_TANK_IN.readFromNBT(tag.m_128469_("FluidIn"));
        this.valvePos = new ArrayList<BlockPos>(4);
        for (int i = 0; i < 4; ++i) {
            this.valvePos.add(BlockEntity.m_187472_((CompoundTag)tag.m_128469_("ValvePos-" + (i + 1))));
        }
        super.handleUpdateTag(tag);
    }

    @Override
    public void m_183515_(@NotNull CompoundTag nbt) {
        nbt.m_128379_("Assembled", this.isAssembled());
        nbt.m_128405_("Conversions", this.conversions);
        nbt.m_128365_("FluidIn", (Tag)this.FLUID_TANK_IN.writeToNBT(new CompoundTag()));
        for (int i = 0; i < 4; ++i) {
            if (this.valvePos == null || this.valvePos.size() <= i) continue;
            nbt.m_128365_("ValvePos-" + (i + 1), (Tag)this.parsePosToTag(this.valvePos.get(i)));
        }
        super.m_183515_(nbt);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        this.setAssembled(nbt.m_128471_("Assembled"));
        this.setConversions(nbt.m_128451_("Conversions"));
        this.FLUID_TANK_IN.readFromNBT(nbt.m_128469_("FluidIn"));
        this.valvePos = new ArrayList<BlockPos>(4);
        for (int i = 0; i < 4; ++i) {
            this.valvePos.add(BlockEntity.m_187472_((CompoundTag)nbt.m_128469_("ValvePos-" + (i + 1))));
        }
        super.m_142466_(nbt);
    }

    public boolean isAssembled() {
        return this.assembled;
    }

    public void setAssembled(boolean canBeAssembled) {
        this.assembled = canBeAssembled;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (this.m_58904_().f_46443_ && net.getDirection() == PacketFlow.CLIENTBOUND) {
            this.handleUpdateTag(pkt.m_131708_());
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void updateBlock() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 2);
            ThermalControllerBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)state);
        }
    }
}

