/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.blockentity.tank;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.common.blockentity.ModFluidTank;
import unhappycodings.thoriumreactors.common.container.tank.FluidTankContainer;
import unhappycodings.thoriumreactors.common.network.PacketHandler;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.ClientFluidTankRenderDataPacket;

public class FluidTankBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
MenuProvider {
    public int capacity = 0;
    private final boolean isCreative;
    private LazyOptional<FluidTank> lazyFluidInHandler = LazyOptional.empty();
    private final LazyOptional<? extends IItemHandler>[] itemHandler = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])Direction.values());
    private final ModFluidTank FLUID_TANK_IN;
    public NonNullList<ItemStack> items;

    public FluidTankBlockEntity(BlockPos pPos, BlockState pBlockState, int capacity, BlockEntityType<FluidTankBlockEntity> type) {
        super(type, pPos, pBlockState);
        this.isCreative = capacity == -1;
        this.capacity = capacity;
        if (this.isCreative) {
            this.capacity = Integer.MAX_VALUE;
        }
        this.FLUID_TANK_IN = new ModFluidTank(capacity, true, true, 0, FluidStack.EMPTY);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    }

    public void tick() {
        if (this.isCreative) {
            boolean isAir = this.FLUID_TANK_IN.getFluid().getAmount() < Integer.MAX_VALUE;
            this.FLUID_TANK_IN.setFluid(new FluidStack(isAir ? FluidStack.EMPTY : this.FLUID_TANK_IN.getFluid(), Integer.MAX_VALUE));
        }
        this.updateRenderData();
        if (this.f_58857_.m_46467_() % 10L == 0L && this.m_8020_(0).m_150930_(Items.f_42446_) && this.m_8020_(1).m_41619_() && this.getFluidAmountIn() > 0) {
            ItemStack stack = this.m_8020_(0).m_41777_();
            if (!stack.m_150930_(Items.f_42446_)) {
                return;
            }
            stack.m_41764_(1);
            stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(storage -> {
                int amount = storage.fill(this.getFluidIn().copy(), IFluidHandler.FluidAction.SIMULATE);
                if (amount > 0) {
                    this.m_8020_(0).m_41774_(1);
                    this.m_6836_(1, this.getFluidIn().getFluid().m_6859_().m_7968_());
                    if (!this.isCreative) {
                        this.getFluidIn().shrink(amount);
                    }
                }
            });
        }
    }

    public void onLoad() {
        super.onLoad();
        this.updateBlock();
        this.lazyFluidInHandler = LazyOptional.of(() -> this.FLUID_TANK_IN);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && side != null) {
            return this.lazyFluidInHandler.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER && !this.m_58901_() && side != null) {
            return this.itemHandler[0].cast();
        }
        return super.getCapability(cap, side);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Fluid", (Tag)this.FLUID_TANK_IN.writeToNBT(new CompoundTag()));
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.FLUID_TANK_IN.readFromNBT(tag.m_128469_("Fluid"));
    }

    public void m_183515_(@NotNull CompoundTag nbt) {
        nbt.m_128365_("Fluid", (Tag)this.FLUID_TANK_IN.writeToNBT(new CompoundTag()));
        ContainerHelper.m_18976_((CompoundTag)nbt, this.items, (boolean)true);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
        this.FLUID_TANK_IN.readFromNBT(nbt.m_128469_("Fluid"));
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (this.m_58904_().f_46443_ && net.getDirection() == PacketFlow.CLIENTBOUND) {
            this.handleUpdateTag(pkt.m_131708_());
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void updateBlock() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 2);
            FluidTankBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)state);
        }
    }

    public void updateRenderData() {
        BlockPos p = this.m_58899_();
        List players = this.f_58857_.m_45976_(ServerPlayer.class, new AABB((double)(p.m_123341_() - 18), (double)(p.m_123342_() - 18), (double)(p.m_123343_() - 18), (double)(p.m_123341_() + 18), (double)(p.m_123342_() + 18), (double)(p.m_123343_() + 18)));
        for (ServerPlayer player : players) {
            PacketHandler.sendToClient(new ClientFluidTankRenderDataPacket(this.m_58899_(), this.getFluidIn()), player);
        }
    }

    public FluidStack getFluidIn() {
        return this.FLUID_TANK_IN.getFluid();
    }

    public void setFluidIn(FluidStack stack) {
        this.FLUID_TANK_IN.setFluid(stack);
    }

    public int getFluidCapacityIn() {
        return this.FLUID_TANK_IN.getCapacity();
    }

    public int getFluidSpaceIn() {
        return this.FLUID_TANK_IN.getSpace();
    }

    public ModFluidTank getFluidTank() {
        return this.FLUID_TANK_IN;
    }

    public int getFluidAmountIn() {
        return this.FLUID_TANK_IN.getFluidAmount();
    }

    public int m_6643_() {
        return 2;
    }

    public boolean m_7983_() {
        for (ItemStack itemStack : this.items) {
            if (!itemStack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        if (index < 0 || index >= this.items.size()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.items.get(index);
    }

    @NotNull
    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    @NotNull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, @NotNull ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public int @NotNull [] m_7071_(@NotNull Direction pSide) {
        return new int[]{0, 1};
    }

    public boolean m_7155_(int index, @NotNull ItemStack stack, @Nullable Direction direction) {
        return index == 0;
    }

    public boolean m_7157_(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        return index == 1;
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int i, @NotNull Inventory inventory) {
        return new FluidTankContainer(i, inventory, this.m_58899_(), this.m_58904_(), this.m_6643_());
    }
}

