/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.blockentity.machine;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.common.block.machine.MachineElectrolyticSaltSeparatorBlock;
import unhappycodings.thoriumreactors.common.block.machine.MachineSaltMelterBlock;
import unhappycodings.thoriumreactors.common.blockentity.ModFluidTank;
import unhappycodings.thoriumreactors.common.blockentity.base.MachineContainerBlockEntity;
import unhappycodings.thoriumreactors.common.container.machine.MachineSaltMelterContainer;
import unhappycodings.thoriumreactors.common.energy.IEnergyCapable;
import unhappycodings.thoriumreactors.common.energy.ModEnergyStorage;
import unhappycodings.thoriumreactors.common.recipe.SaltSmeltingRecipe;
import unhappycodings.thoriumreactors.common.registration.ModBlockEntities;
import unhappycodings.thoriumreactors.common.registration.ModRecipes;
import unhappycodings.thoriumreactors.common.registration.ModSounds;
import unhappycodings.thoriumreactors.common.util.EnergyUtil;

public class MachineSaltMelterBlockEntity
extends MachineContainerBlockEntity
implements WorldlyContainer,
MenuProvider,
IEnergyCapable {
    public static final int MAX_POWER = 100000;
    public static final int MAX_TRANSFER = 50000;
    public static final int MAX_FLUID_OUT = 10000;
    public static final int MAX_FLUID_TRANSFER = 100;
    public static final int NEEDED_ENERGY = 233;
    public static final int WORKING_DEGREES = 659;
    private LazyOptional<ModEnergyStorage> lazyEnergyHandler = LazyOptional.empty();
    private LazyOptional<FluidTank> lazyFluidOutHandler = LazyOptional.empty();
    private final LazyOptional<? extends IItemHandler>[] itemHandler = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])Direction.values());
    private final ModFluidTank FLUID_TANK_OUT = new ModFluidTank(10000, false, true, -1, FluidStack.EMPTY);
    public ItemStack inputItem1 = new ItemStack((ItemLike)Items.f_41852_);
    public ItemStack inputItem2 = new ItemStack((ItemLike)Items.f_41852_);
    public ItemStack inputItem3 = new ItemStack((ItemLike)Items.f_41852_);
    public FluidStack outputFluid = FluidStack.EMPTY;
    public NonNullList<ItemStack> items;
    int operationAfterTicks = 0;
    int degree = 25;
    int recipeTime = 0;
    int maxRecipeTime = 0;
    boolean powerable = true;
    int redstoneMode = 0;
    int recipeDefinedTicks;
    int recipeDefinedTemperature;
    private final ModEnergyStorage ENERGY_STORAGE = new ModEnergyStorage(100000, 50000){

        @Override
        public void onEnergyChanged() {
            MachineSaltMelterBlockEntity.this.m_6596_();
            this.energy = MachineSaltMelterBlockEntity.this.ENERGY_STORAGE.getEnergyStored();
        }
    };

    public MachineSaltMelterBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.SALT_MELTER_BLOCK.get(), pPos, pBlockState);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyEnergyHandler = LazyOptional.of(() -> this.ENERGY_STORAGE);
        this.lazyFluidOutHandler = LazyOptional.of(() -> this.FLUID_TANK_OUT);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)MachineElectrolyticSaltSeparatorBlock.FACING);
        if (cap == ForgeCapabilities.ENERGY && this.supportsEnergy() && side != null && ((Direction)this.m_58900_().m_61143_((Property)MachineSaltMelterBlock.FACING)).m_122424_() == side) {
            return this.lazyEnergyHandler.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && side != null && side == Direction.DOWN) {
            return this.lazyFluidOutHandler.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER && !this.m_58901_() && side != null) {
            if (side == facing.m_122428_() || side == facing.m_122427_() || side == facing) {
                return this.itemHandler[side.m_122411_()].cast();
            }
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean canInputEnergy(Direction direction) {
        return ((Direction)this.m_58900_().m_61143_((Property)MachineSaltMelterBlock.FACING)).m_122424_() == direction;
    }

    @Override
    public boolean canOutputEnergy() {
        return false;
    }

    public void tick() {
        ((ItemStack)this.items.get(2)).getCapability(ForgeCapabilities.ENERGY).ifPresent(storage -> EnergyUtil.tryDischargeItem(storage, this.ENERGY_STORAGE, this.getMaxInput()));
        if (this.isPowerable() && this.isSpaceAbove()) {
            switch (this.getRedstoneMode()) {
                case 0: {
                    this.operate();
                    break;
                }
                case 1: {
                    if (this.f_58857_.m_276867_(this.m_58899_())) {
                        this.operate();
                        break;
                    }
                    if (!this.getState()) break;
                    this.setState(false);
                    break;
                }
                case 2: {
                    if (!this.f_58857_.m_276867_(this.m_58899_())) {
                        this.operate();
                        break;
                    }
                    if (!this.getState()) break;
                    this.setState(false);
                }
            }
        } else {
            if (this.getState()) {
                this.setState(false);
            }
            if (this.getDegree() > 25) {
                this.setDegree(this.getDegree() - this.getDegreeHeating(true));
            }
        }
    }

    public void operate() {
        if (this.hasRecipeNeeds(233)) {
            if (this.getMaxRecipeTime() == 0) {
                this.setMaxRecipeTime(this.getRecipeDefinedTicks());
                this.setRecipeTime(this.getRecipeDefinedTicks());
                ((ItemStack)this.items.get(0)).m_41774_(1);
                ((ItemStack)this.items.get(1)).m_41774_(1);
                ((ItemStack)this.items.get(2)).m_41774_(1);
                if (!this.getState()) {
                    this.setState(true);
                }
            }
            if (this.getFluidAmountOut() + this.getFluidAmountNeeded() <= this.getMaxFluidOut()) {
                if (this.getDegree() >= this.getWorkingDegree()) {
                    if (this.getState() && this.getRecipeTime() % 20 == 0) {
                        this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.MACHINE_SALT_MELTER.get(), SoundSource.BLOCKS, 0.3f, 1.0f);
                    }
                    if (!this.getState()) {
                        this.setState(true);
                    }
                    this.setEnergy(this.getEnergy() - this.getNeededEnergy());
                    if (this.getOperationAfterTicks() != 0 && this.getRecipeTime() % this.getOperationAfterTicks() == 0) {
                        if (this.getFluidOut().isEmpty()) {
                            this.setFluidOut(new FluidStack(this.getOutputFluid(), 0));
                        }
                        this.getFluidOut().grow(this.getFluidAmountNeeded());
                    }
                    this.setRecipeTime(this.getRecipeTime() - 1);
                    if (this.getRecipeTime() == 0) {
                        this.setMaxRecipeTime(0);
                        this.setRecipeDefinedTicks(0);
                        this.setOperationAfterTicks(0);
                        this.setOutputFluid(FluidStack.EMPTY);
                        this.setInputItem1(ItemStack.f_41583_);
                        this.setInputItem2(ItemStack.f_41583_);
                        this.setInputItem3(ItemStack.f_41583_);
                        this.setWorkingDegree(0);
                    }
                } else {
                    this.setDegree(this.getDegree() + this.getDegreeHeating(false));
                }
            } else if (this.getState()) {
                this.setState(false);
            }
        } else {
            if (this.getDegree() > 25) {
                this.setDegree(this.getDegree() - this.getDegreeHeating(true));
            }
            if (this.getState()) {
                this.setState(false);
            }
        }
    }

    public int getDegreeHeating(boolean cooling) {
        if (this.getDegree() < 219) {
            return cooling ? 1 : 3;
        }
        if (this.getDegree() < 434) {
            return 2;
        }
        return cooling ? 3 : 1;
    }

    public boolean hasRecipeNeeds(int energy) {
        if (energy > this.getEnergy()) {
            return false;
        }
        SimpleContainer container = new SimpleContainer(new ItemStack[]{this.m_8020_(0).m_41777_(), this.m_8020_(1).m_41777_(), this.m_8020_(2).m_41777_()});
        List recipe = this.f_58857_.m_7465_().m_44013_((RecipeType)ModRecipes.SALT_SMELTING_RECIPE_TYPE.get());
        for (SaltSmeltingRecipe saltSmeltingRecipe : recipe) {
            if (saltSmeltingRecipe.matchesAll(container, this.getFluidIn(), this.f_58857_) && this.recipeTime == 0 && this.maxRecipeTime == 0) {
                this.setRecipeDefinedTicks(saltSmeltingRecipe.getTicks());
                this.setOutputFluid(saltSmeltingRecipe.getResultFluid());
                this.setInputItem1(saltSmeltingRecipe.getInputSlot1().m_43908_()[0]);
                this.setInputItem2(saltSmeltingRecipe.getInputSlot2().m_43908_()[0]);
                this.setInputItem3(saltSmeltingRecipe.getInputSlot3().m_43908_()[0]);
                this.setOperationAfterTicks(saltSmeltingRecipe.getOperationAfterTicks());
                this.setWorkingDegree(saltSmeltingRecipe.getTemperature());
                return true;
            }
            if (this.recipeTime == 0 || this.maxRecipeTime == 0 || !saltSmeltingRecipe.matchesFluid(this.getFluidIn())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getState() {
        return (Boolean)this.m_58900_().m_61143_((Property)MachineElectrolyticSaltSeparatorBlock.POWERED);
    }

    public void setState(boolean state) {
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)MachineElectrolyticSaltSeparatorBlock.POWERED, (Comparable)Boolean.valueOf(state)), 3);
    }

    public int getWorkingDegree() {
        return this.recipeDefinedTemperature;
    }

    public void setWorkingDegree(int temp) {
        this.recipeDefinedTemperature = temp;
    }

    public int getDegree() {
        return this.degree;
    }

    public void setDegree(int degree) {
        this.degree = degree;
    }

    @Override
    public int getFluidAmountNeeded() {
        return this.outputFluid.getAmount();
    }

    @Override
    public FluidStack getFluidOut() {
        return this.FLUID_TANK_OUT.getFluid();
    }

    @Override
    public void setFluidOut(FluidStack stack) {
        this.FLUID_TANK_OUT.setFluid(stack);
    }

    @Override
    public int getFluidCapacityOut() {
        return this.FLUID_TANK_OUT.getCapacity();
    }

    @Override
    public int getFluidSpaceOut() {
        return this.FLUID_TANK_OUT.getSpace();
    }

    @Override
    public int getFluidAmountOut() {
        return this.FLUID_TANK_OUT.getFluidAmount();
    }

    public int getMaxFluidTransfer() {
        return 100;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void setRedstoneMode(int redstoneMode) {
        this.redstoneMode = redstoneMode;
    }

    @Override
    public boolean isPowerable() {
        return this.powerable;
    }

    @Override
    public void setPowerable(boolean powerable) {
        this.powerable = powerable;
    }

    @Override
    public int getNeededEnergy() {
        return 233;
    }

    public int getRecipeTime() {
        return this.recipeTime;
    }

    public void setRecipeTime(int recipeTime) {
        this.recipeTime = recipeTime;
    }

    public int getMaxRecipeTime() {
        return this.maxRecipeTime;
    }

    public void setMaxRecipeTime(int maxRecipeTime) {
        this.maxRecipeTime = maxRecipeTime;
    }

    public int getMaxFluidOut() {
        return 10000;
    }

    @Override
    public int getEnergy() {
        return this.ENERGY_STORAGE.getEnergyStored();
    }

    @Override
    public void setEnergy(int energy) {
        this.ENERGY_STORAGE.setEnergy(energy);
    }

    @Override
    public int getCapacity() {
        return this.ENERGY_STORAGE.getMaxEnergyStored();
    }

    @Override
    public void setCapacity(int capacity) {
    }

    public int getMaxInput() {
        return 50000;
    }

    public boolean supportsEnergy() {
        return this.getEnergyCapacity() > 0L;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    public void setOutputFluid(FluidStack inputFluid) {
        this.outputFluid = inputFluid;
    }

    public ItemStack getInputItem1() {
        return this.inputItem1;
    }

    public void setInputItem1(ItemStack inputItem1) {
        this.inputItem1 = inputItem1;
    }

    public ItemStack getInputItem2() {
        return this.inputItem2;
    }

    public void setInputItem2(ItemStack inputItem2) {
        this.inputItem2 = inputItem2;
    }

    public ItemStack getInputItem3() {
        return this.inputItem3;
    }

    public void setInputItem3(ItemStack inputItem3) {
        this.inputItem3 = inputItem3;
    }

    public void setOperationAfterTicks(int operationAfterTicks) {
        this.operationAfterTicks = operationAfterTicks;
    }

    public int getOperationAfterTicks() {
        return this.operationAfterTicks;
    }

    public void setRecipeDefinedTicks(int recipeDefinedTicks) {
        this.recipeDefinedTicks = recipeDefinedTicks;
    }

    public int getRecipeDefinedTicks() {
        return this.recipeDefinedTicks;
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (this.m_58904_().f_46443_ && net.getDirection() == PacketFlow.CLIENTBOUND) {
            this.handleUpdateTag(pkt.m_131708_());
        }
    }

    @Override
    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("Energy", this.getEnergy());
        nbt.m_128405_("RecipeTime", this.getRecipeTime());
        nbt.m_128405_("MaxRecipeTime", this.getMaxRecipeTime());
        nbt.m_128405_("OperationAfterTicks", this.getOperationAfterTicks());
        nbt.m_128405_("RedstoneMode", this.getRedstoneMode());
        nbt.m_128405_("Temp", this.getDegree());
        nbt.m_128405_("WorkingTemp", this.getWorkingDegree());
        nbt.m_128379_("Powerable", this.isPowerable());
        nbt.m_128365_("FluidOut", (Tag)this.FLUID_TANK_OUT.writeToNBT(new CompoundTag()));
        nbt.m_128365_("OutputFluid", (Tag)this.getOutputFluid().writeToNBT(new CompoundTag()));
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.setEnergy(tag.m_128451_("Energy"));
        this.setRecipeTime(tag.m_128451_("RecipeTime"));
        this.setMaxRecipeTime(tag.m_128451_("MaxRecipeTime"));
        this.setRedstoneMode(tag.m_128451_("RedstoneMode"));
        this.setDegree(tag.m_128451_("Temp"));
        this.setWorkingDegree(tag.m_128451_("WorkingTemp"));
        this.setOperationAfterTicks(tag.m_128451_("OperationAfterTicks"));
        this.setPowerable(tag.m_128471_("Powerable"));
        this.FLUID_TANK_OUT.readFromNBT(tag.m_128469_("FluidOut"));
        this.setOutputFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("OutputFluid")));
    }

    public void m_183515_(@NotNull CompoundTag nbt) {
        nbt.m_128405_("Energy", this.getEnergy());
        nbt.m_128405_("RecipeTime", this.getRecipeTime());
        nbt.m_128405_("MaxRecipeTime", this.getMaxRecipeTime());
        nbt.m_128405_("RedstoneMode", this.getRedstoneMode());
        nbt.m_128405_("Temp", this.getDegree());
        nbt.m_128405_("WorkingTemp", this.getWorkingDegree());
        nbt.m_128405_("OperationAfterTicks", this.getOperationAfterTicks());
        nbt.m_128379_("Powerable", this.isPowerable());
        nbt.m_128365_("FluidOut", (Tag)this.FLUID_TANK_OUT.writeToNBT(new CompoundTag()));
        nbt.m_128365_("InputItem1", (Tag)this.getInputItem1().m_41739_(new CompoundTag()));
        nbt.m_128365_("InputItem2", (Tag)this.getInputItem2().m_41739_(new CompoundTag()));
        nbt.m_128365_("InputItem3", (Tag)this.getInputItem3().m_41739_(new CompoundTag()));
        nbt.m_128365_("OutputFluid", (Tag)this.getOutputFluid().writeToNBT(new CompoundTag()));
        ContainerHelper.m_18976_((CompoundTag)nbt, this.items, (boolean)true);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
        this.setEnergy(nbt.m_128451_("Energy"));
        this.setRecipeTime(nbt.m_128451_("RecipeTime"));
        this.setMaxRecipeTime(nbt.m_128451_("MaxRecipeTime"));
        this.setRedstoneMode(nbt.m_128451_("RedstoneMode"));
        this.setDegree(nbt.m_128451_("Temp"));
        this.setWorkingDegree(nbt.m_128451_("WorkingTemp"));
        this.setOperationAfterTicks(nbt.m_128451_("OperationAfterTicks"));
        this.setPowerable(nbt.m_128471_("Powerable"));
        this.FLUID_TANK_OUT.readFromNBT(nbt.m_128469_("FluidOut"));
        this.setInputItem1(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("InputItem1")));
        this.setInputItem2(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("InputItem2")));
        this.setInputItem3(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("InputItem3")));
        this.setOutputFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("OutputFluid")));
    }

    @Override
    protected Component m_6820_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Override
    @NotNull
    protected AbstractContainerMenu m_6555_(int pContainerId, @NotNull Inventory pInventory) {
        return new MachineSaltMelterContainer(pContainerId, pInventory, this.m_58899_(), this.m_58904_(), this.m_6643_());
    }

    @Override
    public int m_6643_() {
        return 4;
    }

    @Override
    public boolean m_7983_() {
        for (ItemStack itemStack : this.items) {
            if (!itemStack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public ItemStack m_8020_(int index) {
        if (index < 0 || index >= this.items.size()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.items.get(index);
    }

    @Override
    @NotNull
    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    @Override
    @NotNull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    @Override
    public void m_6836_(int index, @NotNull ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    @Override
    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    @Override
    public void m_6211_() {
        this.items.clear();
    }

    @Override
    public long getEnergyStored() {
        return this.ENERGY_STORAGE.getEnergyStored();
    }

    @Override
    public long getEnergyCapacity() {
        return 100000L;
    }

    @Override
    public long getMaxEnergyTransfer() {
        return 50000L;
    }

    @Override
    public int getEnergyDrain() {
        return 0;
    }

    @Override
    public long removeEnergy(long energy, boolean simulate) {
        return this.ENERGY_STORAGE.extractEnergy((int)energy, simulate);
    }

    @Override
    public long addEnergy(long energy, boolean simulate) {
        return this.ENERGY_STORAGE.receiveEnergy((int)energy, simulate);
    }

    public int[] m_7071_(Direction pSide) {
        if (pSide == ((Direction)this.m_58900_().m_61143_((Property)MachineElectrolyticSaltSeparatorBlock.FACING)).m_122427_()) {
            return new int[]{2};
        }
        if (pSide == ((Direction)this.m_58900_().m_61143_((Property)MachineElectrolyticSaltSeparatorBlock.FACING)).m_122428_()) {
            return new int[]{0};
        }
        if (pSide == this.m_58900_().m_61143_((Property)MachineElectrolyticSaltSeparatorBlock.FACING)) {
            return new int[]{1};
        }
        return new int[0];
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)MachineElectrolyticSaltSeparatorBlock.FACING);
        return facing.m_122428_() == pDirection || facing.m_122427_() == pDirection || facing == pDirection;
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return false;
    }
}

