/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.blockentity.machine;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.common.block.machine.MachineElectrolyticSaltSeparatorBlock;
import unhappycodings.thoriumreactors.common.block.machine.MachineGeneratorBlock;
import unhappycodings.thoriumreactors.common.blockentity.base.MachineContainerBlockEntity;
import unhappycodings.thoriumreactors.common.container.machine.MachineGeneratorContainer;
import unhappycodings.thoriumreactors.common.energy.EnergyHandler;
import unhappycodings.thoriumreactors.common.energy.IEnergyCapable;
import unhappycodings.thoriumreactors.common.energy.ModEnergyStorage;
import unhappycodings.thoriumreactors.common.registration.ModBlockEntities;
import unhappycodings.thoriumreactors.common.registration.ModSounds;
import unhappycodings.thoriumreactors.common.util.EnergyUtil;

public class MachineGeneratorBlockEntity
extends MachineContainerBlockEntity
implements WorldlyContainer,
MenuProvider,
IEnergyCapable {
    public static final int MAX_POWER = 75000;
    public static final int MAX_TRANSFER = 37500;
    public static final int GENERATION = 144;
    private final LazyOptional<EnergyHandler>[] lazyEnergyHandler = EnergyHandler.createEnergyHandlers(this, Direction.values());
    private final LazyOptional<? extends IItemHandler>[] itemHandler = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])Direction.values());
    public NonNullList<ItemStack> items;
    int currentProduction = 0;
    int maxFuel = 1;
    int fuel = 0;
    boolean powerable = true;
    int redstoneMode = 0;
    private final ModEnergyStorage ENERGY_STORAGE = new ModEnergyStorage(75000, 37500){

        @Override
        public void onEnergyChanged() {
            MachineGeneratorBlockEntity.this.m_6596_();
            this.energy = MachineGeneratorBlockEntity.this.ENERGY_STORAGE.getEnergyStored();
        }
    };

    public MachineGeneratorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.GENERATOR_BLOCK.get(), pPos, pBlockState);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)MachineElectrolyticSaltSeparatorBlock.FACING);
        if (cap == ForgeCapabilities.ENERGY && this.supportsEnergy() && side != null && ((Direction)this.m_58900_().m_61143_((Property)MachineGeneratorBlock.FACING)).m_122424_() == side) {
            return this.lazyEnergyHandler[side.m_122411_()].cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER && !this.m_58901_() && side != null) {
            if (side == facing.m_122427_()) {
                return this.itemHandler[side.m_122411_()].cast();
            }
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean canInputEnergy() {
        return false;
    }

    @Override
    public boolean canOutputEnergy(Direction direction) {
        return ((Direction)this.m_58900_().m_61143_((Property)MachineGeneratorBlock.FACING)).m_122424_() == direction;
    }

    public void tick() {
        if (this.getState() && this.getFuel() % 20 == 0) {
            this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.MACHINE_GENERATOR.get(), SoundSource.BLOCKS, 0.18f, 1.0f);
        }
        if (this.isPowerable() && this.isSpaceAbove()) {
            switch (this.getRedstoneMode()) {
                case 0: {
                    this.operate();
                    break;
                }
                case 1: {
                    if (this.f_58857_.m_276867_(this.m_58899_())) {
                        this.operate();
                        break;
                    }
                    if (!this.getState()) break;
                    this.setState(false);
                    break;
                }
                case 2: {
                    if (!this.f_58857_.m_276867_(this.m_58899_())) {
                        this.operate();
                        break;
                    }
                    if (!this.getState()) break;
                    this.setState(false);
                }
            }
        } else if (this.getState()) {
            this.setState(false);
        }
        ((ItemStack)this.items.get(1)).getCapability(ForgeCapabilities.ENERGY).ifPresent(storage -> EnergyUtil.tryChargeItem(storage, this.ENERGY_STORAGE, this.getMaxOutput()));
        EnergyUtil.trySendToNeighbors(this.f_58857_, this.m_58899_(), this.ENERGY_STORAGE, this.getEnergy(), (int)this.getMaxEnergyTransfer());
    }

    public void operate() {
        ItemStack input = this.m_8020_(this.getInputSlot());
        if (this.getFuel() <= 0 && ForgeHooks.getBurnTime((ItemStack)input, null) > 0 && this.getEnergy() != 75000) {
            this.addFuel(input);
            this.setMaxFuel(this.getFuel());
            input.m_41774_(1);
        }
        if (this.getFuel() > 0) {
            if (!this.getState()) {
                this.setState(true);
            }
            this.setCurrentProduction(144);
            if (this.getEnergy() + 144 <= 75000) {
                this.setEnergy(this.getEnergy() + this.getCurrentProduction());
            } else if (this.getEnergy() > 0) {
                this.setEnergy(75000);
            }
            this.setFuel(this.getFuel() - 1);
        } else {
            if (this.getState()) {
                this.setState(false);
            }
            this.currentProduction = 0;
        }
    }

    public void addFuel(ItemStack stack) {
        this.setFuel(this.getFuel() + ForgeHooks.getBurnTime((ItemStack)stack, null));
    }

    @Override
    public boolean getState() {
        return (Boolean)this.m_58900_().m_61143_((Property)MachineGeneratorBlock.POWERED);
    }

    public void setState(boolean state) {
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)MachineGeneratorBlock.POWERED, (Comparable)Boolean.valueOf(state)), 3);
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void setRedstoneMode(int redstoneMode) {
        this.redstoneMode = redstoneMode;
    }

    @Override
    public boolean isPowerable() {
        return this.powerable;
    }

    @Override
    public void setPowerable(boolean powerable) {
        this.powerable = powerable;
    }

    public int getMaxFuel() {
        return this.maxFuel;
    }

    public void setMaxFuel(int maxFuel) {
        this.maxFuel = maxFuel;
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int fuel) {
        this.fuel = fuel;
    }

    @Override
    public int getEnergy() {
        return this.ENERGY_STORAGE.getEnergyStored();
    }

    @Override
    public void setEnergy(int energy) {
        this.ENERGY_STORAGE.setEnergy(energy);
    }

    @Override
    public int getCapacity() {
        return this.ENERGY_STORAGE.getMaxEnergyStored();
    }

    @Override
    public void setCapacity(int capacity) {
    }

    public int getMaxProduction() {
        return 144;
    }

    public int getMaxOutput() {
        return 37500;
    }

    public int getCurrentProduction() {
        return this.currentProduction;
    }

    public void setCurrentProduction(int currentProduction) {
        this.currentProduction = currentProduction;
    }

    public int getInputSlot() {
        return 0;
    }

    public boolean supportsEnergy() {
        return this.getEnergyCapacity() > 0L;
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (this.m_58904_().f_46443_ && net.getDirection() == PacketFlow.CLIENTBOUND) {
            this.handleUpdateTag(pkt.m_131708_());
        }
    }

    @Override
    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("Fuel", this.getFuel());
        nbt.m_128405_("MaxFuel", this.getMaxFuel());
        nbt.m_128405_("Energy", this.getEnergy());
        nbt.m_128405_("Production", this.getCurrentProduction());
        nbt.m_128405_("RedstoneMode", this.getRedstoneMode());
        nbt.m_128379_("Powerable", this.isPowerable());
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.setFuel(tag.m_128451_("Fuel"));
        this.setMaxFuel(tag.m_128451_("MaxFuel"));
        this.setEnergy(tag.m_128451_("Energy"));
        this.setCurrentProduction(tag.m_128451_("Production"));
        this.setRedstoneMode(tag.m_128451_("RedstoneMode"));
        this.setPowerable(tag.m_128471_("Powerable"));
    }

    public void m_183515_(@NotNull CompoundTag nbt) {
        nbt.m_128405_("Fuel", this.getFuel());
        nbt.m_128405_("MaxFuel", this.getMaxFuel());
        nbt.m_128405_("Energy", this.getEnergy());
        nbt.m_128405_("Production", this.getCurrentProduction());
        nbt.m_128405_("RedstoneMode", this.getRedstoneMode());
        nbt.m_128379_("Powerable", this.isPowerable());
        ContainerHelper.m_18976_((CompoundTag)nbt, this.items, (boolean)true);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
        this.setFuel(nbt.m_128451_("Fuel"));
        this.setMaxFuel(nbt.m_128451_("MaxFuel"));
        this.setEnergy(nbt.m_128451_("Energy"));
        this.setCurrentProduction(nbt.m_128451_("Production"));
        this.setRedstoneMode(nbt.m_128451_("RedstoneMode"));
        this.setPowerable(nbt.m_128471_("Powerable"));
    }

    @Override
    protected Component m_6820_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Override
    @NotNull
    protected AbstractContainerMenu m_6555_(int pContainerId, @NotNull Inventory pInventory) {
        return new MachineGeneratorContainer(pContainerId, pInventory, this.m_58899_(), this.m_58904_(), this.m_6643_());
    }

    @Override
    public int m_6643_() {
        return 2;
    }

    @Override
    public boolean m_7983_() {
        for (ItemStack itemStack : this.items) {
            if (!itemStack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public ItemStack m_8020_(int index) {
        if (index < 0 || index >= this.items.size()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.items.get(index);
    }

    @Override
    @NotNull
    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    @Override
    @NotNull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    @Override
    public void m_6836_(int index, @NotNull ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    @Override
    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    @Override
    public void m_6211_() {
        this.items.clear();
    }

    @Override
    public long getEnergyStored() {
        return this.ENERGY_STORAGE.getEnergyStored();
    }

    @Override
    public long getEnergyCapacity() {
        return 75000L;
    }

    @Override
    public long getMaxEnergyTransfer() {
        return 144L;
    }

    @Override
    public int getEnergyDrain() {
        return 0;
    }

    @Override
    public long removeEnergy(long energy, boolean simulate) {
        return this.ENERGY_STORAGE.extractEnergy((int)energy, simulate);
    }

    @Override
    public long addEnergy(long energy, boolean simulate) {
        return this.ENERGY_STORAGE.receiveEnergy((int)energy, simulate);
    }

    public int[] m_7071_(Direction pSide) {
        int[] nArray;
        switch (pSide) {
            case NORTH: 
            case EAST: 
            case SOUTH: 
            case WEST: {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
                break;
            }
            default: {
                nArray = new int[]{};
            }
        }
        return nArray;
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)MachineElectrolyticSaltSeparatorBlock.FACING);
        return facing.m_122427_() == pDirection;
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return false;
    }
}

