/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.blockentity.machine;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.common.block.machine.MachineBlastFurnaceBlock;
import unhappycodings.thoriumreactors.common.block.machine.MachineElectrolyticSaltSeparatorBlock;
import unhappycodings.thoriumreactors.common.blockentity.base.MachineContainerBlockEntity;
import unhappycodings.thoriumreactors.common.container.machine.MachineBlastFurnaceContainer;
import unhappycodings.thoriumreactors.common.energy.IEnergyCapable;
import unhappycodings.thoriumreactors.common.energy.ModEnergyStorage;
import unhappycodings.thoriumreactors.common.recipe.BlastingRecipe;
import unhappycodings.thoriumreactors.common.registration.ModBlockEntities;
import unhappycodings.thoriumreactors.common.registration.ModRecipes;
import unhappycodings.thoriumreactors.common.registration.ModSounds;
import unhappycodings.thoriumreactors.common.util.EnergyUtil;

public class MachineBlastFurnaceBlockEntity
extends MachineContainerBlockEntity
implements WorldlyContainer,
IEnergyCapable {
    public static final int MAX_POWER = 25000;
    public static final int MAX_TRANSFER = 12500;
    public static final int NEEDED_ENERGY = 189;
    private final LazyOptional<? extends IItemHandler>[] itemHandler = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])Direction.values());
    private LazyOptional<ModEnergyStorage> lazyEnergyHandler = LazyOptional.empty();
    public ItemStack outputItem = new ItemStack((ItemLike)Items.f_41852_);
    public ItemStack secondaryOutputItem = new ItemStack((ItemLike)Items.f_41852_);
    public int secondaryChance = 0;
    public NonNullList<ItemStack> items;
    int recipeTime = 0;
    int maxRecipeTime = 0;
    boolean powerable = true;
    int redstoneMode = 0;
    int degree = 25;
    int maxFuel = 1;
    int fuel = 0;
    int recipeDefinedTemperature;
    int recipeDefinedTicks;
    private final ModEnergyStorage ENERGY_STORAGE = new ModEnergyStorage(25000, 12500){

        @Override
        public void onEnergyChanged() {
            MachineBlastFurnaceBlockEntity.this.m_6596_();
            this.energy = MachineBlastFurnaceBlockEntity.this.ENERGY_STORAGE.getEnergyStored();
        }
    };

    public MachineBlastFurnaceBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.BLAST_FURNACE_BLOCK.get(), pPos, pBlockState);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyEnergyHandler = LazyOptional.of(() -> this.ENERGY_STORAGE);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)MachineBlastFurnaceBlock.FACING);
        if (cap == ForgeCapabilities.ENERGY && this.supportsEnergy() && side != null && facing.m_122424_() == side) {
            return this.lazyEnergyHandler.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER && !this.m_58901_() && side != null) {
            if (facing.m_122427_() == side || facing.m_122428_() == side || side == Direction.DOWN) {
                return this.itemHandler[side.m_122411_()].cast();
            }
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean canInputEnergy(Direction direction) {
        return ((Direction)this.m_58900_().m_61143_((Property)MachineBlastFurnaceBlock.FACING)).m_122424_() == direction;
    }

    @Override
    public boolean canOutputEnergy() {
        return false;
    }

    public void tick() {
        ((ItemStack)this.items.get(4)).getCapability(ForgeCapabilities.ENERGY).ifPresent(storage -> EnergyUtil.tryDischargeItem(storage, this.ENERGY_STORAGE, this.getMaxInput()));
        if (this.isPowerable() && this.isSpaceAbove()) {
            switch (this.getRedstoneMode()) {
                case 0: {
                    this.operate();
                    break;
                }
                case 1: {
                    if (this.f_58857_.m_276867_(this.m_58899_())) {
                        this.operate();
                        break;
                    }
                    if (!this.getState()) break;
                    this.setState(false);
                    break;
                }
                case 2: {
                    if (!this.f_58857_.m_276867_(this.m_58899_())) {
                        this.operate();
                        break;
                    }
                    if (!this.getState()) break;
                    this.setState(false);
                }
            }
        } else {
            if (this.getState()) {
                this.setState(false);
            }
            if (this.getDegree() > 25) {
                this.setDegree(this.getDegree() - this.getDegreeHeating(true));
            }
        }
    }

    public void operate() {
        if (this.hasRecipeNeeds(189)) {
            if (this.getMaxRecipeTime() == 0) {
                this.setMaxRecipeTime(this.getRecipeDefinedTicks());
                this.setRecipeTime(this.getRecipeDefinedTicks() - 1);
                this.setMaxFuel(ForgeHooks.getBurnTime((ItemStack)((ItemStack)this.items.get(0)), null));
                this.setFuel(this.getMaxFuel());
                this.m_8020_(0).m_41774_(1);
                this.m_8020_(1).m_41774_(1);
                if (!this.getState()) {
                    this.setState(true);
                }
            }
            ItemStack outputSlot = this.m_8020_(2);
            ItemStack secondaryOutputSlot = this.m_8020_(3);
            if (this.getRecipeTime() > 0 && this.getMaxRecipeTime() > 0 && outputSlot.m_41613_() + 1 <= outputSlot.m_41741_() && secondaryOutputSlot.m_41613_() + 1 <= secondaryOutputSlot.m_41741_()) {
                if (this.getDegree() >= this.getWorkingDegree()) {
                    if (this.getState() && this.getRecipeTime() % 10 == 0) {
                        this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.MACHINE_BLAST_FURNACE.get(), SoundSource.BLOCKS, 0.55f, 2.0f);
                    }
                    if (!this.getState()) {
                        this.setState(true);
                    }
                    this.setEnergy(this.getEnergy() - 189);
                    this.setRecipeTime(this.getRecipeTime() - 1);
                    if (this.getRecipeTime() == 0) {
                        this.m_6836_(2, new ItemStack((ItemLike)this.getOutputItem().m_41720_(), outputSlot.m_41613_() + 1));
                        if (!this.getSecondaryOutputItem().m_41619_() && (double)this.getSecondaryChance() <= Math.random() * 100.0) {
                            this.m_6836_(3, new ItemStack((ItemLike)this.getSecondaryOutputItem().m_41720_(), secondaryOutputSlot.m_41613_() + 1));
                        }
                        this.setMaxRecipeTime(0);
                        this.setRecipeDefinedTicks(0);
                        this.setMaxRecipeTime(0);
                        this.setWorkingDegree(0);
                    }
                } else {
                    this.setDegree(this.getDegree() + this.getDegreeHeating(false));
                }
            } else if (this.getState()) {
                this.setState(false);
            }
        } else {
            if (this.getDegree() > 25) {
                this.setDegree(this.getDegree() - this.getDegreeHeating(true));
            }
            if (this.getState()) {
                this.setState(false);
            }
            if (this.getRecipeTime() == 0 || this.m_8020_(0).m_41619_() && this.m_8020_(1).m_41619_()) {
                this.setMaxRecipeTime(0);
                this.setRecipeTime(0);
                this.setSecondaryChance(0);
                this.setSecondaryOutputItem(ItemStack.f_41583_);
                this.setOutputItem(ItemStack.f_41583_);
                this.setRecipeDefinedTicks(0);
            }
        }
    }

    public int getDegreeHeating(boolean cooling) {
        if (this.getDegree() < 350) {
            return cooling ? 1 : 3;
        }
        if (this.getDegree() < 840) {
            return 2;
        }
        return cooling ? 3 : 1;
    }

    public boolean hasRecipeNeeds(int energy) {
        if (energy > this.getEnergy()) {
            return false;
        }
        ItemStack outputSlot = this.m_8020_(2);
        SimpleContainer container = new SimpleContainer(new ItemStack[]{this.m_8020_(0), this.m_8020_(1)});
        List recipe = this.f_58857_.m_7465_().m_44013_((RecipeType)ModRecipes.BLASTING_RECIPE_TYPE.get());
        for (BlastingRecipe blastingRecipe : recipe) {
            if (blastingRecipe.matches(container, this.m_58904_()) && this.getOutputItem().m_41619_() && this.recipeTime == 0 && this.maxRecipeTime == 0) {
                this.setOutputItem(blastingRecipe.m_8043_(null));
                this.setSecondaryOutputItem(blastingRecipe.getSecondaryResultItem());
                this.setSecondaryChance(blastingRecipe.getSecondaryChance());
                this.setRecipeDefinedTicks(blastingRecipe.getTicks());
                this.setWorkingDegree(blastingRecipe.getTemperature());
                return outputSlot.m_150930_(Items.f_41852_) || outputSlot.m_150930_(this.getOutputItem().m_41720_());
            }
            if (this.recipeTime == 0 || this.maxRecipeTime == 0 || this.getOutputItem().m_41619_()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getState() {
        return (Boolean)this.m_58900_().m_61143_((Property)MachineBlastFurnaceBlock.POWERED);
    }

    public int getWorkingDegree() {
        return this.recipeDefinedTemperature;
    }

    public void setWorkingDegree(int temp) {
        this.recipeDefinedTemperature = temp;
    }

    public int getDegree() {
        return this.degree;
    }

    public void setDegree(int degree) {
        this.degree = degree;
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int fuel) {
        this.fuel = fuel;
    }

    public int getMaxFuel() {
        return this.maxFuel;
    }

    public void setMaxFuel(int maxFuel) {
        this.maxFuel = maxFuel;
    }

    public void setState(boolean state) {
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)MachineBlastFurnaceBlock.POWERED, (Comparable)Boolean.valueOf(state)), 3);
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void setRedstoneMode(int redstoneMode) {
        this.redstoneMode = redstoneMode;
    }

    @Override
    public boolean isPowerable() {
        return this.powerable;
    }

    @Override
    public void setPowerable(boolean powerable) {
        this.powerable = powerable;
    }

    @Override
    public int getNeededEnergy() {
        return 189;
    }

    public int getRecipeTime() {
        return this.recipeTime;
    }

    public void setRecipeTime(int recipeTime) {
        this.recipeTime = recipeTime;
    }

    public int getMaxRecipeTime() {
        return this.maxRecipeTime;
    }

    public void setMaxRecipeTime(int maxRecipeTime) {
        this.maxRecipeTime = maxRecipeTime;
    }

    @Override
    public int getEnergy() {
        return this.ENERGY_STORAGE.getEnergyStored();
    }

    @Override
    public void setEnergy(int energy) {
        this.ENERGY_STORAGE.setEnergy(energy);
    }

    @Override
    public int getCapacity() {
        return this.ENERGY_STORAGE.getMaxEnergyStored();
    }

    @Override
    public void setCapacity(int capacity) {
    }

    public int getMaxInput() {
        return 12500;
    }

    public boolean supportsEnergy() {
        return this.getEnergyCapacity() > 0L;
    }

    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    public void setOutputItem(ItemStack outputItem) {
        this.outputItem = outputItem;
    }

    public void setSecondaryOutputItem(ItemStack secondaryOutputItem) {
        this.secondaryOutputItem = secondaryOutputItem;
    }

    public ItemStack getSecondaryOutputItem() {
        return this.secondaryOutputItem;
    }

    public void setSecondaryChance(int secondaryChance) {
        this.secondaryChance = secondaryChance;
    }

    public int getSecondaryChance() {
        return this.secondaryChance;
    }

    public void setRecipeDefinedTicks(int recipeDefinedTicks) {
        this.recipeDefinedTicks = recipeDefinedTicks;
    }

    public int getRecipeDefinedTicks() {
        return this.recipeDefinedTicks;
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("Energy", this.getEnergy());
        nbt.m_128405_("RecipeTime", this.getRecipeTime());
        nbt.m_128405_("MaxRecipeTime", this.getMaxRecipeTime());
        nbt.m_128405_("RedstoneMode", this.getRedstoneMode());
        nbt.m_128405_("Temp", this.getDegree());
        nbt.m_128405_("WorkingTemp", this.getWorkingDegree());
        nbt.m_128405_("MaxFuel", this.getMaxFuel());
        nbt.m_128405_("Fuel", this.getFuel());
        nbt.m_128379_("Powerable", this.isPowerable());
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.setEnergy(tag.m_128451_("Energy"));
        this.setRecipeTime(tag.m_128451_("RecipeTime"));
        this.setMaxRecipeTime(tag.m_128451_("MaxRecipeTime"));
        this.setRedstoneMode(tag.m_128451_("RedstoneMode"));
        this.setDegree(tag.m_128451_("Temp"));
        this.setWorkingDegree(tag.m_128451_("WorkingTemp"));
        this.setMaxFuel(tag.m_128451_("MaxFuel"));
        this.setFuel(tag.m_128451_("Fuel"));
        this.setPowerable(tag.m_128471_("Powerable"));
    }

    public void m_183515_(@NotNull CompoundTag nbt) {
        nbt.m_128405_("Energy", this.getEnergy());
        nbt.m_128405_("RecipeTime", this.getRecipeTime());
        nbt.m_128405_("MaxRecipeTime", this.getMaxRecipeTime());
        nbt.m_128405_("RedstoneMode", this.getRedstoneMode());
        nbt.m_128405_("Temp", this.getDegree());
        nbt.m_128405_("WorkingTemp", this.getWorkingDegree());
        nbt.m_128405_("MaxFuel", this.getMaxFuel());
        nbt.m_128405_("Fuel", this.getFuel());
        nbt.m_128379_("Powerable", this.isPowerable());
        nbt.m_128365_("OutputItem", (Tag)this.getOutputItem().m_41739_(new CompoundTag()));
        nbt.m_128365_("SecondaryOutputItem", (Tag)this.getSecondaryOutputItem().m_41739_(new CompoundTag()));
        nbt.m_128405_("SecondaryChance", this.getSecondaryChance());
        ContainerHelper.m_18976_((CompoundTag)nbt, this.items, (boolean)true);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
        this.setEnergy(nbt.m_128451_("Energy"));
        this.setRecipeTime(nbt.m_128451_("RecipeTime"));
        this.setMaxRecipeTime(nbt.m_128451_("MaxRecipeTime"));
        this.setRedstoneMode(nbt.m_128451_("RedstoneMode"));
        this.setDegree(nbt.m_128451_("Temp"));
        this.setWorkingDegree(nbt.m_128451_("WorkingTemp"));
        this.setMaxFuel(nbt.m_128451_("MaxFuel"));
        this.setFuel(nbt.m_128451_("Fuel"));
        this.setPowerable(nbt.m_128471_("Powerable"));
        this.setOutputItem(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("OutputItem")));
        this.setSecondaryOutputItem(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("SecondaryOutputItem")));
        this.setSecondaryChance(nbt.m_128451_("SecondaryChance"));
    }

    @Override
    public int m_6643_() {
        return 5;
    }

    @Override
    public boolean m_7983_() {
        for (ItemStack itemStack : this.items) {
            if (!itemStack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public ItemStack m_8020_(int index) {
        if (index < 0 || index >= this.items.size()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.items.get(index);
    }

    @Override
    @NotNull
    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    @Override
    @NotNull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    @Override
    public void m_6836_(int index, @NotNull ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    @Override
    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    @Override
    public void m_6211_() {
        this.items.clear();
    }

    @Override
    public long getEnergyStored() {
        return this.ENERGY_STORAGE.getEnergyStored();
    }

    @Override
    public long getEnergyCapacity() {
        return 25000L;
    }

    @Override
    public long getMaxEnergyTransfer() {
        return 12500L;
    }

    @Override
    public int getEnergyDrain() {
        return 0;
    }

    @Override
    public long removeEnergy(long energy, boolean simulate) {
        return this.ENERGY_STORAGE.extractEnergy((int)energy, simulate);
    }

    @Override
    public long addEnergy(long energy, boolean simulate) {
        return this.ENERGY_STORAGE.receiveEnergy((int)energy, simulate);
    }

    public int[] m_7071_(Direction pSide) {
        if (pSide == ((Direction)this.m_58900_().m_61143_((Property)MachineElectrolyticSaltSeparatorBlock.FACING)).m_122427_()) {
            return new int[]{1};
        }
        if (pSide == ((Direction)this.m_58900_().m_61143_((Property)MachineElectrolyticSaltSeparatorBlock.FACING)).m_122428_()) {
            return new int[]{2};
        }
        if (pSide == Direction.DOWN) {
            return new int[]{0};
        }
        return new int[0];
    }

    public boolean m_7155_(int pIndex, @NotNull ItemStack pItemStack, @Nullable Direction pDirection) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)MachineElectrolyticSaltSeparatorBlock.FACING);
        return facing.m_122427_() == pDirection || pDirection == Direction.DOWN;
    }

    public boolean m_7157_(int pIndex, @NotNull ItemStack pStack, @NotNull Direction pDirection) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)MachineElectrolyticSaltSeparatorBlock.FACING);
        return facing.m_122428_() == pDirection;
    }

    @Override
    protected Component m_6820_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Override
    protected AbstractContainerMenu m_6555_(int pContainerId, Inventory pInventory) {
        return new MachineBlastFurnaceContainer(pContainerId, pInventory, this.m_58899_(), this.m_58904_(), this.m_6643_());
    }
}

