/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.blockentity.chest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.common.container.chest.SteelChestContainer;
import unhappycodings.thoriumreactors.common.registration.ModBlockEntities;

public class SteelChestBlockEntity
extends ChestBlockEntity {
    private LazyOptional<?> itemHandler = LazyOptional.of(() -> this.createUnSidedHandler());
    private final ChestLidController chestLidController;
    private final ContainerOpenersCounter counter;
    public NonNullList<ItemStack> items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    public int openers = 0;
    public float angle;

    public SteelChestBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntityType.f_58918_, pPos, pBlockState);
        this.counter = new ContainerOpenersCounter(){

            protected void m_142292_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState) {
                SteelChestBlockEntity.this.m_58904_().m_7785_((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, SoundEvents.f_11749_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }

            protected void m_142289_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState) {
                SteelChestBlockEntity.this.m_58904_().m_7785_((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, SoundEvents.f_11747_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }

            protected void m_142148_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, int pCount, int pOpenCount) {
                SteelChestBlockEntity.this.m_142151_(pLevel, pPos, pState, pCount, pOpenCount);
                SteelChestBlockEntity.this.openers = pOpenCount;
                SteelChestBlockEntity.this.m_7531_(1, SteelChestBlockEntity.this.counter.m_155450_());
            }

            protected boolean m_142718_(@NotNull Player player) {
                if (!(player.f_36096_ instanceof ChestMenu)) {
                    return false;
                }
                Container container = ((ChestMenu)player.f_36096_).m_39261_();
                return container == SteelChestBlockEntity.this || container instanceof CompoundContainer && ((CompoundContainer)container).m_18927_((Container)SteelChestBlockEntity.this);
            }
        };
        this.chestLidController = new ChestLidController();
    }

    public <T extends BlockEntity> void lidAnimateTick() {
        this.chestLidController.m_155374_();
    }

    public void tick() {
        this.lidAnimateTick();
    }

    public void m_6596_() {
        Level level;
        super.m_6596_();
        if (!this.m_58904_().f_46443_ && this.m_58904_() != null && (level = this.m_58904_()) instanceof ServerLevel) {
            ServerLevel w = (ServerLevel)level;
            w.m_7726_().m_8450_(this.m_58899_());
        }
    }

    public void m_5856_(@NotNull Player pPlayer) {
        if (!this.f_58859_ && !pPlayer.m_5833_()) {
            this.counter.m_155452_(pPlayer, this.f_58857_, this.m_58899_(), this.m_58900_());
            this.m_6596_();
        }
    }

    public void m_5785_(@NotNull Player pPlayer) {
        if (!this.f_58859_ && !pPlayer.m_5833_()) {
            this.counter.m_155468_(pPlayer, this.f_58857_, this.m_58899_(), this.m_58900_());
            this.m_6596_();
        }
    }

    public boolean m_7531_(int pId, int pType) {
        if (pId == 1) {
            this.chestLidController.m_155377_(pType > 0);
            return true;
        }
        return super.m_7531_(pId, pType);
    }

    @NotNull
    public BlockEntityType<?> m_58903_() {
        return (BlockEntityType)ModBlockEntities.STEEL_CHEST_BLOCK.get();
    }

    public int m_6643_() {
        return 77;
    }

    public boolean m_7983_() {
        for (ItemStack itemStack : this.items) {
            if (!itemStack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        if (index < 0 || index >= this.items.size()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.items.get(index);
    }

    @NotNull
    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    @NotNull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, @NotNull ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    public boolean m_6542_(@NotNull Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        ContainerHelper.m_18976_((CompoundTag)nbt, this.items, (boolean)true);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237113_((String)"");
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int pContainerId, @NotNull Inventory pInventory) {
        return new SteelChestContainer(pContainerId, pInventory, this.m_58899_(), this.m_58904_(), this.m_6643_());
    }

    public float m_6683_(float pPartialTicks) {
        return this.chestLidController.m_155375_(pPartialTicks);
    }

    public boolean m_7525_(Player pPlayer) {
        return true;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void m_155350_() {
        if (!this.f_58859_) {
            this.counter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    protected void m_142151_(Level pLevel, BlockPos pPos, BlockState pState, int pEventId, int pEventParam) {
        Block block = pState.m_60734_();
        pLevel.m_7696_(pPos, block, 1, pEventParam);
    }

    protected IItemHandler createUnSidedHandler() {
        return new InvWrapper((Container)this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

