/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.blockentity;

import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class ModFluidTank
extends FluidTank {
    public final int slotId;
    public boolean canInput;
    public boolean canOutput;
    public boolean isCreative;
    public int allowedFluid;

    public ModFluidTank(int capacity, boolean canInput, boolean canOuput, int slotId, FluidStack fluid) {
        super(capacity);
        this.capacity = capacity;
        this.canInput = canInput;
        this.canOutput = canOuput;
        this.slotId = slotId;
        this.fluid = fluid;
        boolean bl = this.isCreative = capacity == -1;
        if (this.isCreative) {
            this.capacity = Integer.MAX_VALUE;
        }
    }

    public ModFluidTank(int capacity, boolean canInput, boolean canOuput, int slotId, FluidStack fluid, int allowedFluid) {
        super(allowedFluid);
        this.capacity = allowedFluid;
        this.canInput = canInput;
        this.canOutput = canOuput;
        this.slotId = slotId;
        this.fluid = fluid;
    }

    public void setAllowedFluid(int allowedFluid) {
        this.allowedFluid = allowedFluid;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.isCreative) {
            return resource.getAmount();
        }
        return this.canInput ? super.fill(resource.getAmount() > this.getMaxFluidTransfer() ? new FluidStack(resource.getFluid(), this.getMaxFluidTransfer()) : resource, action) : 0;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.isCreative) {
            return resource;
        }
        return this.canOutput ? super.drain(resource, action) : FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.isCreative) {
            return new FluidStack(this.fluid, maxDrain);
        }
        return super.drain(maxDrain, action);
    }

    public boolean isFluidValid(FluidStack stack) {
        return true;
    }

    public int getMaxFluidTransfer() {
        return this.isCreative ? 0x3FFFFFFF : this.capacity;
    }
}

