/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.block.turbine;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.common.block.turbine.base.TurbineFrameBlock;
import unhappycodings.thoriumreactors.common.blockentity.turbine.TurbineRotorBlockEntity;
import unhappycodings.thoriumreactors.common.registration.ModItems;

public class TurbineRotorBlock
extends TurbineFrameBlock {
    public VoxelShape SHAPE = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final IntegerProperty BLADES = IntegerProperty.m_61631_((String)"blades", (int)0, (int)8);
    public static final BooleanProperty RENDERING = BooleanProperty.m_61465_((String)"rendering");

    public TurbineRotorBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60978_(5.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BLADES, (Comparable)Integer.valueOf(0))).m_61124_((Property)RENDERING, (Comparable)Boolean.valueOf(false)));
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return 10;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)BLADES, (Comparable)Integer.valueOf(0))).m_61124_((Property)RENDERING, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{BLADES, RENDERING});
    }

    @Override
    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return (Boolean)state.m_61143_((Property)RENDERING) != false ? RenderShape.INVISIBLE : RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return this.SHAPE;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        int bladesCount;
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (pPlayer.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ModItems.TURBINE_BLADE.get())) {
            int bladesCount2 = (Integer)pState.m_61143_((Property)BLADES);
            if (bladesCount2 < 8) {
                pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)BLADES, (Comparable)Integer.valueOf(bladesCount2 + 1)));
                if (!pPlayer.m_7500_()) {
                    pPlayer.m_21120_(InteractionHand.MAIN_HAND).m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (pPlayer.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && (bladesCount = ((Integer)pState.m_61143_((Property)BLADES)).intValue()) > 0 && pPlayer.m_7066_(((Item)ModItems.TURBINE_BLADE.get()).m_7968_())) {
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)BLADES, (Comparable)Integer.valueOf(bladesCount - 1)));
            if (!pPlayer.m_7500_()) {
                pPlayer.m_36356_(((Item)ModItems.TURBINE_BLADE.get()).m_7968_());
            }
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pParams) {
        List drops = super.m_49635_(pState, pParams);
        int bladesCount = (Integer)pState.m_61143_((Property)BLADES);
        for (int i = 0; i < bladesCount; ++i) {
            drops.add(((Item)ModItems.TURBINE_BLADE.get()).m_7968_());
        }
        return drops;
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new TurbineRotorBlockEntity(pos, state);
    }
}

