/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.block.thermal;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.common.block.thermal.base.ThermalFrameBlock;
import unhappycodings.thoriumreactors.common.blockentity.thermal.ThermalControllerBlockEntity;
import unhappycodings.thoriumreactors.common.blockentity.thermal.base.ThermalFrameBlockEntity;
import unhappycodings.thoriumreactors.common.enums.ParticleTypeEnum;
import unhappycodings.thoriumreactors.common.multiblock.ThermalMultiblocks;
import unhappycodings.thoriumreactors.common.network.PacketHandler;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.ClientReactorParticleDataPacket;
import unhappycodings.thoriumreactors.common.registration.ModBlocks;
import unhappycodings.thoriumreactors.common.util.CalculationUtil;

public class ThermalControllerBlock
extends ThermalFrameBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public ThermalControllerBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60978_(5.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, POWERED});
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level levelIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hitResult) {
        ThermalControllerBlockEntity entity = (ThermalControllerBlockEntity)levelIn.m_7702_(pos);
        if (player.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!entity.isAssembled()) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            boolean canBeAssembled = false;
            List<Block> thermalBlocks = CalculationUtil.getBlocks(pos.m_5484_(facing.m_122427_(), 2).m_5484_(Direction.DOWN, 1), pos.m_5484_(facing.m_122428_(), 2).m_5484_(facing.m_122424_(), 2).m_5484_(Direction.UP, 1), levelIn);
            if (ThermalMultiblocks.isThermal(ThermalMultiblocks.getThermalFromDirection(facing), thermalBlocks)) {
                canBeAssembled = true;
            }
            if (entity.isAssembled() != canBeAssembled) {
                entity.valvePos = new ArrayList<BlockPos>(4);
                List<BlockPos> thermalPositions = CalculationUtil.getBlockPositions(pos.m_5484_(facing.m_122427_(), 2).m_5484_(Direction.DOWN, 1), pos.m_5484_(facing.m_122428_(), 2).m_5484_(facing.m_122424_(), 2).m_5484_(Direction.UP, 1), levelIn);
                for (BlockPos turbinePosition : thermalPositions) {
                    BlockEntity blockEntity = levelIn.m_7702_(turbinePosition);
                    if (blockEntity instanceof ThermalFrameBlockEntity) {
                        ThermalFrameBlockEntity thermalFrameBlockEntity = (ThermalFrameBlockEntity)blockEntity;
                        thermalFrameBlockEntity.setControllerPos(pos);
                    }
                    if (!levelIn.m_8055_(turbinePosition).m_60713_((Block)ModBlocks.THERMAL_VALVE.get())) continue;
                    entity.valvePos.add(turbinePosition);
                }
                if (entity.valvePos.size() != 4) {
                    return InteractionResult.CONSUME;
                }
                entity.setAssembled(canBeAssembled);
                levelIn.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(canBeAssembled)));
                long x = facing == Direction.WEST || facing == Direction.EAST ? 3L : 5L;
                long y = 3L;
                if (x == 3L) {
                    y = 5L;
                }
                for (Player loopPlayer : levelIn.m_6907_()) {
                    PacketHandler.sendToClient(new ClientReactorParticleDataPacket(this.addParticleOffset(pos.m_5484_(Direction.DOWN, 1), (Direction)state.m_61143_((Property)FACING)), ParticleTypeEnum.REACTOR, x, 3L, y), (ServerPlayer)loopPlayer);
                }
            }
        }
        return InteractionResult.CONSUME;
    }

    public BlockPos addParticleOffset(BlockPos pos, Direction direction) {
        return switch (direction) {
            case Direction.WEST -> pos.m_7918_(0, 0, -2);
            case Direction.EAST -> pos.m_7918_(-2, 0, -2);
            case Direction.SOUTH -> pos.m_7918_(-2, 0, -2);
            default -> pos.m_7918_(-2, 0, 0);
        };
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ThermalControllerBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> type) {
        if (level.f_46443_ || !((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue()) {
            return null;
        }
        return (a, b, c, blockEntity) -> ((ThermalControllerBlockEntity)blockEntity).tick();
    }
}

