/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.block.tank;

import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.common.blockentity.tank.FluidTankBlockEntity;
import unhappycodings.thoriumreactors.common.registration.ModBlocks;
import unhappycodings.thoriumreactors.common.registration.ModKeyBindings;
import unhappycodings.thoriumreactors.common.util.FormattingUtil;
import unhappycodings.thoriumreactors.common.util.KeyBindingUtil;
import unhappycodings.thoriumreactors.common.util.LootUtil;

public class FluidTankBlock
extends BaseEntityBlock {
    public int capacity = 0;
    public final RegistryObject<BlockEntityType<FluidTankBlockEntity>> type;

    public FluidTankBlock(int capacity, RegistryObject<BlockEntityType<FluidTankBlockEntity>> type) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60955_().m_60918_(SoundType.f_56744_).m_60978_(3.0f));
        this.capacity = capacity;
        this.type = type;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        FluidTankBlockEntity entity = (FluidTankBlockEntity)pLevel.m_7702_(pPos);
        if (pHand == InteractionHand.OFF_HAND) {
            return InteractionResult.FAIL;
        }
        ItemStack playerHandStack = pPlayer.m_21120_(InteractionHand.MAIN_HAND);
        if (!pPlayer.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && playerHandStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
            playerHandStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(storage -> {
                if (!storage.getFluidInTank(0).isEmpty()) {
                    int amount;
                    FluidStack itemAmount;
                    FluidStack playerFluidStack = storage.getFluidInTank(0);
                    if ((entity.getFluidIn().isEmpty() || entity.getFluidIn().isFluidEqual(playerFluidStack)) && (itemAmount = storage.drain(amount = entity.getFluidTank().fill(playerFluidStack, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE)).getAmount() > 0) {
                        entity.getFluidTank().fill(itemAmount, IFluidHandler.FluidAction.EXECUTE);
                        if (!pPlayer.m_7500_()) {
                            storage.drain(itemAmount, IFluidHandler.FluidAction.EXECUTE);
                            if (storage.getFluidInTank(0).isEmpty() && playerHandStack.hasCraftingRemainingItem()) {
                                pPlayer.m_21008_(InteractionHand.MAIN_HAND, playerHandStack.getCraftingRemainingItem());
                            }
                        }
                        pLevel.m_5594_(null, pPos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                } else {
                    int playerFluidStack = entity.getFluidAmountIn();
                    FluidStack amount = entity.getFluidTank().drain(playerFluidStack, IFluidHandler.FluidAction.SIMULATE);
                    int itemAmount = storage.fill(amount, IFluidHandler.FluidAction.SIMULATE);
                    if (itemAmount > 0) {
                        if (playerHandStack.m_150930_(Items.f_42446_) && itemAmount >= 1000) {
                            if (!pPlayer.m_7500_()) {
                                pPlayer.m_21008_(InteractionHand.MAIN_HAND, entity.getFluidIn().getFluid().m_6859_().m_7968_());
                            }
                            entity.getFluidTank().drain(1000, IFluidHandler.FluidAction.EXECUTE);
                        } else {
                            storage.fill(new FluidStack(entity.getFluidIn(), itemAmount), IFluidHandler.FluidAction.EXECUTE);
                            entity.getFluidTank().drain(itemAmount, IFluidHandler.FluidAction.EXECUTE);
                        }
                        pLevel.m_5594_(null, pPos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
            });
            return InteractionResult.SUCCESS;
        }
        MenuProvider namedContainerProvider = this.m_7246_(pState, pLevel, pPos);
        if (namedContainerProvider != null) {
            if (pPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)pPlayer;
                NetworkHooks.openScreen((ServerPlayer)serverPlayerEntity, (MenuProvider)namedContainerProvider, (BlockPos)pPos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public List<ItemStack> m_49635_(@NotNull BlockState pState, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootParams.Builder pParams) {
        return Collections.singletonList(LootUtil.getLoot((BlockEntity)pParams.m_287261_(LootContextParams.f_81462_), (Block)this));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return LootUtil.getLoot(level.m_7702_(pos), (Block)this);
    }

    public CompoundTag writeToNBT(FluidStack fluidStack) {
        CompoundTag dataTag = new CompoundTag();
        CompoundTag fluidTag = new CompoundTag();
        dataTag.m_128359_("FluidName", ForgeRegistries.FLUIDS.getKey((Object)fluidStack.getFluid()).toString());
        dataTag.m_128405_("Amount", fluidStack.getAmount());
        fluidTag.m_128365_("Fluid", (Tag)dataTag);
        return fluidTag;
    }

    public void m_5871_(@NotNull ItemStack pStack, @Nullable BlockGetter pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        CompoundTag tag = pStack.m_41784_().m_128469_("BlockEntityTag");
        if (this.m_49966_().m_60713_((Block)ModBlocks.CREATIVE_FLUID_TANK.get())) {
            FluidStack fluidIn = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("Fluid"));
            pTooltip.add((Component)Component.m_237113_((String)(fluidIn.getFluid().getFluidType().getDescription().getString() + ": ")).m_130948_(FormattingUtil.hex(708302)).m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.infinite")).m_130940_(ChatFormatting.GRAY)));
            pTooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.capacity")).m_130948_(FormattingUtil.hex(3908563)).m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.infinite")).m_130940_(ChatFormatting.GRAY)));
            return;
        }
        if (tag.m_128423_("Fluid") == null) {
            pTooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.not_placed")).m_130948_(FormattingUtil.hex(13508362)));
            return;
        }
        if (KeyBindingUtil.isKeyPressed(ModKeyBindings.SHOW_DETAILS)) {
            if (!tag.m_128469_("Fluid").m_128456_()) {
                FluidStack fluidIn = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("Fluid"));
                pTooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.capacity")).m_130948_(FormattingUtil.hex(3908563)).m_7220_((Component)Component.m_237113_((String)("" + this.getTankCapacity(pStack))).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)" mB").m_130948_(FormattingUtil.hex(3908563))));
                pTooltip.add((Component)(fluidIn.isEmpty() ? Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.empty")).m_130948_(FormattingUtil.hex(708302)) : Component.m_237113_((String)(fluidIn.getFluid().getFluidType().getDescription().getString() + ": ")).m_130948_(FormattingUtil.hex(708302)).m_7220_((Component)Component.m_237113_((String)(fluidIn.getAmount() + " ")).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)"mB").m_130948_(FormattingUtil.hex(708302)))));
            }
        } else if (KeyBindingUtil.isKeyPressed(ModKeyBindings.SHOW_DESCRIPTION)) {
            pTooltip.add((Component)Component.m_237115_((String)(this.m_7374_().m_7705_() + "_description")).m_130940_(ChatFormatting.GRAY));
        } else {
            pTooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.hold")).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)ModKeyBindings.SHOW_DETAILS.getKey().m_84875_().getString()).m_130948_(FormattingUtil.hex(8311637))).m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.for_details")).m_130940_(ChatFormatting.GRAY)));
            pTooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.hold")).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)ModKeyBindings.SHOW_DESCRIPTION.getKey().m_84875_().getString()).m_130948_(FormattingUtil.hex(5624714))).m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.for_description")).m_130940_(ChatFormatting.GRAY)));
        }
    }

    public int getTankCapacity(ItemStack stack) {
        if (stack.m_150930_(((FluidTankBlock)((Object)ModBlocks.SIMPLE_FLUID_TANK.get())).m_5456_())) {
            return ((FluidTankBlock)((Object)ModBlocks.SIMPLE_FLUID_TANK.get())).capacity;
        }
        if (stack.m_150930_(((FluidTankBlock)((Object)ModBlocks.GENERIC_FLUID_TANK.get())).m_5456_())) {
            return ((FluidTankBlock)((Object)ModBlocks.GENERIC_FLUID_TANK.get())).capacity;
        }
        return ((FluidTankBlock)((Object)ModBlocks.PROGRESSIVE_FLUID_TANK.get())).capacity;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new FluidTankBlockEntity(pos, state, this.capacity, (BlockEntityType<FluidTankBlockEntity>)((BlockEntityType)this.type.get()));
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> type) {
        return level.f_46443_ ? null : (a, b, c, blockEntity) -> ((FluidTankBlockEntity)blockEntity).tick();
    }
}

