/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.block.tank;

import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.client.config.ClientConfig;
import unhappycodings.thoriumreactors.common.blockentity.tank.EnergyTankBlockEntity;
import unhappycodings.thoriumreactors.common.registration.ModBlocks;
import unhappycodings.thoriumreactors.common.registration.ModKeyBindings;
import unhappycodings.thoriumreactors.common.util.FormattingUtil;
import unhappycodings.thoriumreactors.common.util.KeyBindingUtil;
import unhappycodings.thoriumreactors.common.util.LootUtil;

public class EnergyTankBlock
extends BaseEntityBlock {
    public final RegistryObject<BlockEntityType<EnergyTankBlockEntity>> type;
    public int capacity = 0;

    public EnergyTankBlock(RegistryObject<BlockEntityType<EnergyTankBlockEntity>> type, int capacity) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60955_().m_60918_(SoundType.f_56744_).m_60978_(3.0f));
        this.type = type;
        this.capacity = capacity;
    }

    public void m_5871_(@NotNull ItemStack pStack, @Nullable BlockGetter pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        CompoundTag tag = pStack.m_41784_().m_128469_("BlockEntityTag");
        if (this.m_49966_().m_60713_((Block)ModBlocks.CREATIVE_ENERGY_TANK.get()) && tag.m_128451_("Energy") == Integer.MAX_VALUE) {
            pTooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.energy")).m_130948_(FormattingUtil.hex(4182051)).m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.infinite")).m_130940_(ChatFormatting.GRAY)));
            pTooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.capacity")).m_130948_(FormattingUtil.hex(3908563)).m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.infinite")).m_130940_(ChatFormatting.GRAY)));
            return;
        }
        if (tag.m_128423_("Energy") == null) {
            pTooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.not_placed")).m_130948_(FormattingUtil.hex(13508362)));
            return;
        }
        if (KeyBindingUtil.isKeyPressed(ModKeyBindings.SHOW_DETAILS) && ((Boolean)ClientConfig.showBlockDetails.get()).booleanValue()) {
            int energy = tag.m_128451_("Energy");
            pTooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.energy")).m_130948_(FormattingUtil.hex(4182051)).m_7220_((Component)Component.m_237113_((String)FormattingUtil.formatEnergy(energy)).m_130940_(ChatFormatting.GRAY)));
            pTooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.capacity")).m_130948_(FormattingUtil.hex(3908563)).m_7220_((Component)Component.m_237113_((String)FormattingUtil.formatEnergy(this.getCapacityForType(pStack))).m_130940_(ChatFormatting.GRAY)));
        } else if (KeyBindingUtil.isKeyPressed(ModKeyBindings.SHOW_DESCRIPTION) && ((Boolean)ClientConfig.showBlockDescription.get()).booleanValue()) {
            pTooltip.add((Component)Component.m_237115_((String)(this.m_7374_().m_7705_() + "_description")).m_130940_(ChatFormatting.GRAY));
        } else {
            if (((Boolean)ClientConfig.showBlockDetails.get()).booleanValue()) {
                pTooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.hold")).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)ModKeyBindings.SHOW_DETAILS.getKey().m_84875_().getString()).m_130948_(FormattingUtil.hex(8311637))).m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.for_details")).m_130940_(ChatFormatting.GRAY)));
            }
            if (((Boolean)ClientConfig.showBlockDescription.get()).booleanValue()) {
                pTooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.hold")).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)ModKeyBindings.SHOW_DESCRIPTION.getKey().m_84875_().getString()).m_130948_(FormattingUtil.hex(5624714))).m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.for_description")).m_130940_(ChatFormatting.GRAY)));
            }
        }
    }

    private int getCapacityForType(ItemStack stack) {
        if (stack.m_150930_(((EnergyTankBlock)((Object)ModBlocks.SIMPLE_ENERGY_TANK.get())).m_5456_())) {
            return ((EnergyTankBlock)((Object)ModBlocks.SIMPLE_ENERGY_TANK.get())).capacity;
        }
        if (stack.m_150930_(((EnergyTankBlock)((Object)ModBlocks.GENERIC_ENERGY_TANK.get())).m_5456_())) {
            return ((EnergyTankBlock)((Object)ModBlocks.GENERIC_ENERGY_TANK.get())).capacity;
        }
        if (stack.m_150930_(((EnergyTankBlock)((Object)ModBlocks.PROGRESSIVE_ENERGY_TANK.get())).m_5456_())) {
            return ((EnergyTankBlock)((Object)ModBlocks.PROGRESSIVE_ENERGY_TANK.get())).capacity;
        }
        return Integer.MAX_VALUE;
    }

    @NotNull
    public List<ItemStack> m_49635_(@NotNull BlockState pState, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootParams.Builder pParams) {
        return Collections.singletonList(LootUtil.getLoot((BlockEntity)pParams.m_287261_(LootContextParams.f_81462_), (Block)this));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return LootUtil.getLoot(level.m_7702_(pos), (Block)this);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new EnergyTankBlockEntity((BlockEntityType)this.type.get(), pos, state, this.capacity);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> type) {
        return level.f_46443_ ? null : (a, b, c, blockEntity) -> ((EnergyTankBlockEntity)blockEntity).tick();
    }
}

