/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.block.machine;

import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.client.config.ClientConfig;
import unhappycodings.thoriumreactors.common.blockentity.machine.MachineFluidEnricherBlockEntity;
import unhappycodings.thoriumreactors.common.registration.ModBlockEntities;
import unhappycodings.thoriumreactors.common.registration.ModKeyBindings;
import unhappycodings.thoriumreactors.common.util.FormattingUtil;
import unhappycodings.thoriumreactors.common.util.KeyBindingUtil;
import unhappycodings.thoriumreactors.common.util.LootUtil;
import unhappycodings.thoriumreactors.common.util.ParticleUtil;

public class MachineFluidEnricherBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public MachineFluidEnricherBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60978_(5.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)POWERED) != false ? 6 : 0;
    }

    public void m_214162_(BlockState pState, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource randomSource) {
        if (((Boolean)pState.m_61143_((Property)POWERED)).booleanValue()) {
            ParticleUtil.renderSmokeParticles(pos, randomSource, level);
        }
    }

    @NotNull
    public List<ItemStack> m_49635_(@NotNull BlockState pState, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootParams.Builder pParams) {
        return Collections.singletonList(LootUtil.getLoot((BlockEntity)pParams.m_287261_(LootContextParams.f_81462_), (Block)this));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return LootUtil.getLoot(level.m_7702_(pos), (Block)this);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level levelIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hitResult) {
        MenuProvider namedContainerProvider = this.m_7246_(state, levelIn, pos);
        if (namedContainerProvider != null) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)serverPlayerEntity, (MenuProvider)namedContainerProvider, (BlockPos)pos);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, levelIn, pos, player, interactionHand, hitResult);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public void m_5871_(@NotNull ItemStack pStack, @Nullable BlockGetter pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        CompoundTag tag = pStack.m_41784_().m_128469_("BlockEntityTag");
        if (tag.m_128423_("RecipeTime") == null) {
            pTooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.not_placed")).m_130948_(FormattingUtil.hex(13508362)));
            return;
        }
        if (KeyBindingUtil.isKeyPressed(ModKeyBindings.SHOW_DETAILS) && ((Boolean)ClientConfig.showBlockDetails.get()).booleanValue()) {
            ListTag listtag;
            pTooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.energy_buffer")).m_130948_(FormattingUtil.hex(4182051)).m_7220_((Component)Component.m_237113_((String)FormattingUtil.formatEnergy(Integer.parseInt(String.valueOf(tag.m_128423_("Energy"))))).m_130940_(ChatFormatting.GRAY)));
            pTooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.recipe_status")).m_130948_(FormattingUtil.hex(3908563)).m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.fluid_enricher.name")).m_130946_(" " + FormattingUtil.formatPercentNum(tag.m_128451_("RecipeTime"), tag.m_128451_("MaxRecipeTime"))).m_130940_(ChatFormatting.GRAY)));
            if (!tag.m_128469_("FluidIn").m_128456_()) {
                FluidStack fluidIn = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("FluidIn"));
                pTooltip.add((Component)(fluidIn.isEmpty() ? Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.empty")).m_130948_(FormattingUtil.hex(708302)) : Component.m_237113_((String)(fluidIn.getFluid().getFluidType().getDescription().getString() + ": ")).m_130948_(FormattingUtil.hex(708302)).m_7220_((Component)Component.m_237113_((String)(fluidIn.getAmount() + " ")).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)"mB").m_130948_(FormattingUtil.hex(708302)))));
            }
            if (!tag.m_128469_("FluidOut").m_128456_()) {
                FluidStack fluidOut = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("FluidOut"));
                pTooltip.add((Component)(fluidOut.isEmpty() ? Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.empty")).m_130948_(FormattingUtil.hex(8449023)) : Component.m_237113_((String)(fluidOut.getFluid().getFluidType().getDescription().getString() + ": ")).m_130948_(FormattingUtil.hex(8449023)).m_7220_((Component)Component.m_237113_((String)(fluidOut.getAmount() + " ")).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)"mB").m_130948_(FormattingUtil.hex(8449023)))));
            }
            if (!(listtag = tag.m_128437_("Items", 10)).isEmpty()) {
                pTooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.contains_items")).m_130940_(ChatFormatting.GRAY));
            }
        } else if (KeyBindingUtil.isKeyPressed(ModKeyBindings.SHOW_DESCRIPTION) && ((Boolean)ClientConfig.showBlockDescription.get()).booleanValue()) {
            pTooltip.add((Component)Component.m_237115_((String)(this.m_7374_().m_7705_() + "_description")).m_130940_(ChatFormatting.GRAY));
        } else {
            if (((Boolean)ClientConfig.showBlockDetails.get()).booleanValue()) {
                pTooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.hold")).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)ModKeyBindings.SHOW_DETAILS.getKey().m_84875_().getString()).m_130948_(FormattingUtil.hex(8311637))).m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.for_details")).m_130940_(ChatFormatting.GRAY)));
            }
            if (((Boolean)ClientConfig.showBlockDescription.get()).booleanValue()) {
                pTooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.hold")).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)ModKeyBindings.SHOW_DESCRIPTION.getKey().m_84875_().getString()).m_130948_(FormattingUtil.hex(5624714))).m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.for_description")).m_130940_(ChatFormatting.GRAY)));
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, POWERED});
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> type) {
        return level.f_46443_ ? null : (a, b, c, blockEntity) -> ((MachineFluidEnricherBlockEntity)blockEntity).tick();
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)ModBlockEntities.FLUID_ENRICHER_BLOCK.get()).m_155264_(pos, state);
    }
}

