/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.LavaFluid;
import net.minecraft.world.level.material.WaterFluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import unhappycodings.thoriumreactors.client.config.ClientConfig;
import unhappycodings.thoriumreactors.common.block.tank.EnergyTankBlock;
import unhappycodings.thoriumreactors.common.block.tank.FluidTankBlock;
import unhappycodings.thoriumreactors.common.registration.ModBlocks;
import unhappycodings.thoriumreactors.common.registration.ModItems;

public class CompleteItemCreativeTabs {
    public static void populateCreativeTabBuilder(CreativeModeTab.Builder builder) {
        builder.m_257501_((features, output) -> {
            for (ItemStack item : CompleteItemCreativeTabs.getDisplayItems()) {
                output.m_246342_(item);
            }
        });
        builder.m_257737_(() -> ((Item)ModItems.THORIUM.get()).m_5456_().m_7968_());
        builder.withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256731_});
        builder.m_257941_((Component)Component.m_237115_((String)"itemGroup.thoriumreactors"));
    }

    public static Collection<ItemStack> getDisplayItems() {
        NonNullList items = NonNullList.m_122779_();
        int index = 0;
        ArrayList machines = new ArrayList();
        Collections.addAll(machines, (Block)ModBlocks.MACHINE_CASING.get(), (Block)ModBlocks.GENERATOR_BLOCK.get(), (Block)ModBlocks.FLUID_EVAPORATION_BLOCK.get(), (Block)ModBlocks.ELECTROLYTIC_SALT_SEPARATOR_BLOCK.get(), (Block)ModBlocks.SALT_MELTER_BLOCK.get(), (Block)ModBlocks.CONCENTRATOR_BLOCK.get(), (Block)ModBlocks.DECOMPOSER_BLOCK.get(), (Block)ModBlocks.URANIUM_OXIDIZER_BLOCK.get(), (Block)ModBlocks.FLUID_CENTRIFUGE_BLOCK.get(), (Block)ModBlocks.CRYSTALLIZER_BLOCK.get(), (Block)ModBlocks.BLAST_FURNACE_BLOCK.get(), (Block)ModBlocks.FLUID_ENRICHER_BLOCK.get());
        for (Object i : machines) {
            items.add(index, (Object)new ItemStack((ItemLike)i));
            ++index;
        }
        ArrayList tanksOne = new ArrayList();
        Collections.addAll(tanksOne, (EnergyTankBlock)((Object)ModBlocks.SIMPLE_ENERGY_TANK.get()), (EnergyTankBlock)((Object)ModBlocks.GENERIC_ENERGY_TANK.get()), (EnergyTankBlock)((Object)ModBlocks.PROGRESSIVE_ENERGY_TANK.get()));
        for (Block i : tanksOne) {
            items.add(index, (Object)new ItemStack((ItemLike)i));
            ++index;
        }
        ItemStack blockStack = ((EnergyTankBlock)((Object)ModBlocks.CREATIVE_ENERGY_TANK.get())).m_5456_().m_7968_();
        if (((Boolean)ClientConfig.showCreativeFluidTanksInCreativeTAB.get()).booleanValue()) {
            items.add(index, (Object)((EnergyTankBlock)((Object)ModBlocks.CREATIVE_ENERGY_TANK.get())).m_5456_().m_7968_());
            blockStack.m_41784_().m_128365_("BlockEntityTag", (Tag)CompleteItemCreativeTabs.writeEnergyToNbt(Integer.MAX_VALUE));
            items.add(++index, (Object)blockStack);
            ++index;
        }
        ArrayList tanksTwo = new ArrayList();
        Collections.addAll(tanksTwo, (FluidTankBlock)((Object)ModBlocks.SIMPLE_FLUID_TANK.get()), (FluidTankBlock)((Object)ModBlocks.GENERIC_FLUID_TANK.get()), (FluidTankBlock)((Object)ModBlocks.PROGRESSIVE_FLUID_TANK.get()));
        for (Block block : tanksTwo) {
            items.add(index, (Object)new ItemStack((ItemLike)block));
            ++index;
        }
        if (((Boolean)ClientConfig.showCreativeFluidTanksInCreativeTAB.get()).booleanValue()) {
            blockStack = ((FluidTankBlock)((Object)ModBlocks.CREATIVE_FLUID_TANK.get())).m_5456_().m_7968_();
            items.add(index, (Object)blockStack);
            ++index;
            for (Fluid fluid : CompleteItemCreativeTabs.getKnownFluids()) {
                if (!(fluid instanceof ForgeFlowingFluid.Source) && !(fluid instanceof LavaFluid.Source) && !(fluid instanceof WaterFluid.Source)) continue;
                FluidStack stack = new FluidStack(fluid, Integer.MAX_VALUE);
                blockStack = ((FluidTankBlock)((Object)ModBlocks.CREATIVE_FLUID_TANK.get())).m_5456_().m_7968_();
                blockStack.m_41784_().m_128365_("BlockEntityTag", (Tag)CompleteItemCreativeTabs.writeFluidToNbt(stack));
                if (items.contains((Object)blockStack)) continue;
                items.add(index, (Object)blockStack);
                ++index;
            }
        }
        ArrayList buckets = new ArrayList();
        Collections.addAll(buckets, (BucketItem)ModItems.MOLTEN_SALT_BUCKET.get(), (BucketItem)ModItems.DEPLETED_MOLTEN_SALT_BUCKET.get(), (BucketItem)ModItems.HEATED_MOLTEN_SALT_BUCKET.get(), (BucketItem)ModItems.URANIUM_HEXAFLUORITE_BUCKET.get(), (BucketItem)ModItems.ENRICHED_URANIUM_HEXAFLUORITE_BUCKET.get(), (BucketItem)ModItems.HYDROFLUORITE_BUCKET.get(), (BucketItem)ModItems.STEAM_BUCKET.get());
        for (Object i : buckets) {
            items.add(index, (Object)new ItemStack((ItemLike)i));
            ++index;
        }
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, (BaseEntityBlock)ModBlocks.WATER_SOURCE_BLOCK.get(), (BaseEntityBlock)ModBlocks.REACTOR_CASING.get(), (BaseEntityBlock)ModBlocks.REACTOR_CONTROLLER_BLOCK.get(), (BaseEntityBlock)ModBlocks.REACTOR_VALVE.get(), (BaseEntityBlock)ModBlocks.REACTOR_ROD_CONTROLLER.get(), (BaseEntityBlock)ModBlocks.REACTOR_CORE.get(), (BaseEntityBlock)ModBlocks.TURBINE_CASING.get(), (BaseEntityBlock)ModBlocks.TURBINE_CONTROLLER_BLOCK.get(), (BaseEntityBlock)ModBlocks.TURBINE_POWER_PORT.get(), (BaseEntityBlock)ModBlocks.TURBINE_VALVE.get(), (BaseEntityBlock)ModBlocks.TURBINE_ROTATION_MOUNT.get(), (BaseEntityBlock)ModBlocks.TURBINE_VENT.get(), (BaseEntityBlock)ModBlocks.ELECTROMAGNETIC_COIL.get(), (BaseEntityBlock)ModBlocks.THERMAL_CONDUCTOR.get(), (BaseEntityBlock)ModBlocks.THERMAL_CONTROLLER.get(), (BaseEntityBlock)ModBlocks.THERMAL_VALVE.get(), (BaseEntityBlock)ModBlocks.THERMAL_HEAT_SINK.get(), (BaseEntityBlock)ModBlocks.REACTOR_GLASS.get(), (BaseEntityBlock)ModBlocks.TURBINE_GLASS.get(), (BaseEntityBlock)ModBlocks.REACTOR_GRAPHITE_MODERATOR.get(), (BaseEntityBlock)ModBlocks.TURBINE_ROTOR.get(), (BaseEntityBlock)ModBlocks.THORIUM_CRAFTING_TABLE.get(), (BaseEntityBlock)ModBlocks.BLASTED_IRON_CHEST_BLOCK.get(), (BaseEntityBlock)ModBlocks.STEEL_CHEST_BLOCK.get(), (BaseEntityBlock)ModBlocks.THORIUM_CHEST_BLOCK.get());
        for (Object i : arrayList) {
            items.add(index, (Object)new ItemStack((ItemLike)i));
            ++index;
        }
        ArrayList allItems = new ArrayList();
        Collections.addAll(allItems, (Item)ModItems.CONFIGURATOR.get(), (Item)ModItems.MODULE_EMPTY.get(), (Item)ModItems.MODULE_IO.get(), (Item)ModItems.MODULE_ENERGY.get(), (Item)ModItems.MODULE_STORAGE.get(), (Item)ModItems.MODULE_TANK.get(), (Item)ModItems.MODULE_SENSOR.get(), (Item)ModItems.MODULE_PROCESSING.get(), (Item)ModItems.GRAPHITE_TUBE.get(), (Item)ModItems.TURBINE_BLADE.get(), (Item)ModItems.REDSTONE_PROCESSOR.get());
        for (Object i : allItems) {
            items.add(index, (Object)new ItemStack((ItemLike)i));
            ++index;
        }
        ArrayList resourceItems = new ArrayList();
        Collections.addAll(resourceItems, (Item)ModItems.SODIUM.get(), (Item)ModItems.POTASSIUM.get(), (Item)ModItems.URAN_THREE_CHLORIDE.get(), (Item)ModItems.YELLOW_CAKE.get(), (Item)ModItems.THORIUM.get(), (Item)ModItems.RAW_URANIUM.get(), (Item)ModItems.ENRICHED_URANIUM.get(), (Item)ModItems.DEPLETED_URANIUM.get(), (Item)ModItems.FLUORITE.get(), (Item)ModItems.GRAPHITE_CRYSTAL.get(), (Item)ModItems.CHROMIUM_NUGGET.get(), (Item)ModItems.GRAPHITE_NUGGET.get(), (Item)ModItems.STEEL_NUGGET.get(), (Item)ModItems.BLASTED_IRON_NUGGET.get(), (Item)ModItems.TITANIUM_NUGGET.get(), (Item)ModItems.MOLYBDENUM_NUGGET.get(), (Item)ModItems.COBALT_NUGGET.get(), (Item)ModItems.FLUORITE_NUGGET.get(), (Item)ModItems.NICKEL_NUGGET.get(), (Item)ModItems.URANIUM_NUGGET.get(), (Item)ModItems.ALUMINUM_NUGGET.get(), (Item)ModItems.MANGANESE_NUGGET.get(), (Item)ModItems.NIOB_NUGGET.get(), (Item)ModItems.CHROMIUM_INGOT.get(), (Item)ModItems.GRAPHITE_INGOT.get(), (Item)ModItems.STEEL_INGOT.get(), (Item)ModItems.BLASTED_IRON_INGOT.get(), (Item)ModItems.TITANIUM_INGOT.get(), (Item)ModItems.MOLYBDENUM_INGOT.get(), (Item)ModItems.COBALT_INGOT.get(), (Item)ModItems.FLUORITE_INGOT.get(), (Item)ModItems.NICKEL_INGOT.get(), (Item)ModItems.URANIUM_INGOT.get(), (Item)ModItems.ALUMINUM_INGOT.get(), (Item)ModItems.MANGANESE_INGOT.get(), (Item)ModItems.NIOB_INGOT.get());
        for (Object i : resourceItems) {
            items.add(index, (Object)new ItemStack((ItemLike)i));
            ++index;
        }
        ArrayList resourceBlocks = new ArrayList();
        Collections.addAll(resourceBlocks, (Block)ModBlocks.THORIUM_BLOCK.get(), (Block)ModBlocks.CHROMIUM_BLOCK.get(), (Block)ModBlocks.GRAPHITE_BLOCK.get(), (Block)ModBlocks.STEEL_BLOCK.get(), (Block)ModBlocks.BLASTED_IRON_BLOCK.get(), (Block)ModBlocks.TITANIUM_BLOCK.get(), (Block)ModBlocks.MOLYBDENUM_BLOCK.get(), (Block)ModBlocks.COBALT_BLOCK.get(), (Block)ModBlocks.FLUORITE_BLOCK.get(), (Block)ModBlocks.NICKEL_BLOCK.get(), (Block)ModBlocks.URANIUM_BLOCK.get(), (Block)ModBlocks.ALUMINUM_BLOCK.get(), (Block)ModBlocks.MANGANESE_BLOCK.get(), (Block)ModBlocks.NIOB_BLOCK.get(), (Block)ModBlocks.DEEPSLATE_TITANIC_IRON_ORE.get(), (Block)ModBlocks.TITANIC_IRON_ORE.get(), (Block)ModBlocks.DEEPSLATE_CHROMITE_ORE.get(), (Block)ModBlocks.CHROMITE_ORE.get(), (Block)ModBlocks.DEEPSLATE_GRAPHITE_ORE.get(), (Block)ModBlocks.GRAPHITE_ORE.get(), (Block)ModBlocks.DEEPSLATE_MOLYBDENUM_ORE.get(), (Block)ModBlocks.MOLYBDENUM_ORE.get(), (Block)ModBlocks.DEEPSLATE_FLUORITE_ORE.get(), (Block)ModBlocks.FLUORITE_ORE.get(), (Block)ModBlocks.DEEPSLATE_NICKEL_ORE.get(), (Block)ModBlocks.NICKEL_ORE.get(), (Block)ModBlocks.DEEPSLATE_URANIUM_ORE.get(), (Block)ModBlocks.URANIUM_ORE.get(), (Block)ModBlocks.DEEPSLATE_PYROCHLOR_ORE.get(), (Block)ModBlocks.PYROCHLOR_ORE.get(), (Block)ModBlocks.DEEPSLATE_MANGANESE_ORE.get(), (Block)ModBlocks.MANGANESE_ORE.get(), (Block)ModBlocks.DEEPSLATE_BAUXITE_ORE.get(), (Block)ModBlocks.BAUXITE_ORE.get(), (Block)ModBlocks.BLASTED_STONE.get());
        for (Block i : resourceBlocks) {
            items.add(index, (Object)new ItemStack((ItemLike)i));
            ++index;
        }
        ArrayList buildingBlocks = new ArrayList();
        Collections.addAll(buildingBlocks, (Block)ModBlocks.INDUSTRAL_BLOCK.get(), (Block)ModBlocks.INDUSTRAL_BLOCK_BIG_TILE.get(), (Block)ModBlocks.INDUSTRAL_BLOCK_BRICK.get(), (Block)ModBlocks.INDUSTRAL_BLOCK_PAVING.get(), (Block)ModBlocks.INDUSTRAL_BLOCK_SMOOTH.get(), (Block)ModBlocks.BLACK_INDUSTRAL_BLOCK.get(), (Block)ModBlocks.BLACK_INDUSTRAL_BLOCK_BIG_TILE.get(), (Block)ModBlocks.BLACK_INDUSTRAL_BLOCK_BRICK.get(), (Block)ModBlocks.BLACK_INDUSTRAL_BLOCK_PAVING.get(), (Block)ModBlocks.BLACK_INDUSTRAL_BLOCK_SMOOTH.get(), (Block)ModBlocks.WHITE_INDUSTRAL_BLOCK.get(), (Block)ModBlocks.WHITE_INDUSTRAL_BLOCK_BIG_TILE.get(), (Block)ModBlocks.WHITE_INDUSTRAL_BLOCK_BRICK.get(), (Block)ModBlocks.WHITE_INDUSTRAL_BLOCK_PAVING.get(), (Block)ModBlocks.WHITE_INDUSTRAL_BLOCK_SMOOTH.get(), (Block)ModBlocks.FACTORY_BLOCK.get(), (Block)ModBlocks.INVERTED_FACTORY_BLOCK.get(), (Block)ModBlocks.BLACK_FACTORY_BLOCK.get(), (Block)ModBlocks.BLACK_INVERTED_FACTORY_BLOCK.get(), (Block)ModBlocks.WARNING_BLOCK_LINED_BLACK_YELLOW_LEFT.get(), (Block)ModBlocks.WARNING_BLOCK_LINED_BLACK_YELLOW_RIGHT.get(), (Block)ModBlocks.WARNING_BLOCK_LINED_WHITE_ORANGE_LEFT.get(), (Block)ModBlocks.WARNING_BLOCK_LINED_WHITE_ORANGE_RIGHT.get(), (Block)ModBlocks.WARNING_BLOCK_LINED_WHITE_BLACK_LEFT.get(), (Block)ModBlocks.WARNING_BLOCK_LINED_WHITE_BLACK_RIGHT.get(), (Block)ModBlocks.INDUSTRAL_BLOCK_FLOOR.get(), (Block)ModBlocks.FRAMELESS_INDUSTRAL_BLOCK_FLOOR.get(), (Block)ModBlocks.BLACK_INDUSTRAL_BLOCK_FLOOR.get(), (Block)ModBlocks.FRAMELESS_BLACK_INDUSTRAL_BLOCK_FLOOR.get(), (Block)ModBlocks.GRATE_FLOOR_BLOCK.get(), (Block)ModBlocks.GRATE_WALL_BLOCK.get());
        for (Block i : buildingBlocks) {
            items.add(index, (Object)new ItemStack((ItemLike)i));
            ++index;
        }
        return items;
    }

    public static CompoundTag writeFluidToNbt(FluidStack fluidStack) {
        CompoundTag dataTag = new CompoundTag();
        CompoundTag fluidTag = new CompoundTag();
        dataTag.m_128359_("FluidName", ForgeRegistries.FLUIDS.getKey((Object)fluidStack.getFluid()).toString());
        dataTag.m_128405_("Amount", fluidStack.getAmount());
        fluidTag.m_128365_("Fluid", (Tag)dataTag);
        return fluidTag;
    }

    public static CompoundTag writeEnergyToNbt(int energy) {
        CompoundTag fluidTag = new CompoundTag();
        fluidTag.m_128405_("Energy", energy);
        return fluidTag;
    }

    @NotNull
    protected static Iterable<Fluid> getKnownFluids() {
        return ForgeRegistries.FLUIDS.getEntries().stream().map(Map.Entry::getValue)::iterator;
    }
}

