/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import unhappycodings.thoriumreactors.client.gui.GuiUtil;

public class RenderUtil {
    public static void renderFluid(int x, int y, int h, int w, int volumeFilled, int volumeTotal, Fluid fluid) {
        FluidStack stack = new FluidStack(fluid, 1);
        TextureAtlasSprite icon = RenderUtil.getStillFluidSprite(stack);
        if (icon == null) {
            return;
        }
        GuiUtil.bind(TextureAtlas.f_118259_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder tes = tesselator.m_85915_();
        tes.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        float minU = icon.m_118409_();
        float maxU = icon.m_118410_();
        float minV = icon.m_118411_();
        float maxV = icon.m_118412_();
        int color = RenderUtil.getColorTint(stack);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GuiUtil.color(r, g, b, 0.8f);
        int amount = (int)Math.floor((float)volumeFilled * ((float)h / (float)volumeTotal));
        for (int i = 0; i < amount; i += 16) {
            int height = y - i + 1;
            int endHeight = Math.min(amount - i, 16);
            tes.m_5483_((double)(x + 1), (double)(height - endHeight), 0.0).m_7421_(minU, minV + (maxV - minV) * (float)endHeight / 16.0f).m_5752_();
            tes.m_5483_((double)(x + 1), (double)height, 0.0).m_7421_(minU, minV).m_5752_();
            tes.m_5483_((double)(x + w + 1), (double)height, 0.0).m_7421_(minU + (maxU - minU) * (float)w / 16.0f, minV).m_5752_();
            tes.m_5483_((double)(x + w + 1), (double)(height - endHeight), 0.0).m_7421_(minU + (maxU - minU) * (float)w / 16.0f, minV + (maxV - minV) * (float)endHeight / 16.0f).m_5752_();
        }
        tesselator.m_85914_();
        GuiUtil.reset();
    }

    public static TextureAtlasSprite getStillFluidSprite(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation fluidStill = renderProperties.getStillTexture(fluidStack);
        if (fluidStill == null) {
            return null;
        }
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidStill);
    }

    public static int getColorTint(FluidStack ingredient) {
        Fluid fluid = ingredient.getFluid();
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        return renderProperties.getTintColor(ingredient);
    }

    public static void resetGuiTextures(ResourceLocation texture) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
    }

    public static enum Perspective {
        UP,
        DOWN,
        RIGHT,
        LEFT,
        FRONT,
        BACK;

    }
}

