/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import unhappycodings.thoriumreactors.client.renderer.model.TurbineBladeModel;
import unhappycodings.thoriumreactors.client.renderer.model.TurbineRotorModel;
import unhappycodings.thoriumreactors.common.block.turbine.TurbineControllerBlock;
import unhappycodings.thoriumreactors.common.block.turbine.TurbineRotorBlock;
import unhappycodings.thoriumreactors.common.blockentity.turbine.TurbineControllerBlockEntity;
import unhappycodings.thoriumreactors.common.registration.ModBlocks;

public class TurbineControllerBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<TurbineControllerBlockEntity> {
    public final TurbineBladeModel<?> modelTurbine = new TurbineBladeModel(Minecraft.m_91087_().m_167973_().m_171103_(TurbineBladeModel.LAYER_LOCATION));
    public final TurbineRotorModel<?> modelRotor = new TurbineRotorModel(Minecraft.m_91087_().m_167973_().m_171103_(TurbineRotorModel.LAYER_LOCATION));

    public TurbineControllerBlockEntityRenderer(BlockEntityRendererProvider.Context ignored) {
    }

    public void render(@NotNull TurbineControllerBlockEntity entity, float pPartialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int pPackedLight, int pPackedOverlay) {
        int i;
        Level level = entity.m_58904_();
        Direction facing = (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING);
        BlockPos rotorPos = entity.m_58899_().m_5484_(facing.m_122424_(), 2);
        for (i = 0; i < 9; ++i) {
            BlockPos pos = rotorPos.m_5484_(Direction.UP, i);
            BlockState state = level.m_8055_(pos);
            if (!state.m_60713_((Block)ModBlocks.TURBINE_ROTOR.get()) || ((Boolean)state.m_61143_((Property)TurbineRotorBlock.RENDERING)).booleanValue() == entity.isAssembled()) continue;
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)TurbineRotorBlock.RENDERING, (Comparable)Boolean.valueOf(entity.isAssembled())));
        }
        if (entity.isAssembled()) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.5f + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.X, facing), -0.5f, 0.5f + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.Y, facing));
            poseStack.m_252781_(Axis.f_252392_.m_252961_(entity.getRotation() / 5.1f));
            for (i = 0; i < entity.getTurbineHeight() - 1; ++i) {
                if (i < entity.getTurbineHeight() - 3) {
                    this.modelTurbine.m_7695_(poseStack, bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)new ResourceLocation("thoriumreactors", "textures/block/turbine_blades.png"))), this.getLightLevel(level, rotorPos), pPackedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                } else {
                    this.modelRotor.m_7695_(poseStack, bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)new ResourceLocation("thoriumreactors", "textures/block/turbine_blades.png"))), this.getLightLevel(level, rotorPos), pPackedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                poseStack.m_252880_(0.0f, 1.0f, 0.0f);
            }
            poseStack.m_85849_();
            if (level.m_46467_() % 20L == 0L) {
                if (entity.getTurbinetime() == 4L && entity.getRpm() > 10.0f) {
                    TurbineControllerBlockEntityRenderer.showVenting(entity);
                }
            } else if (level.m_46467_() % 7L == 0L) {
                if (level.m_46467_() % 14L == 0L && entity.getLastRpm() < entity.getRpm()) {
                    for (i = 0; i < 3; ++i) {
                        TurbineControllerBlockEntityRenderer.showFloorParticles(entity);
                    }
                }
                if (entity.getLastRpm() < entity.getRpm() && entity.getRpm() > 10.0f) {
                    TurbineControllerBlockEntityRenderer.showSteamParticles(entity);
                }
            }
            float rpm = entity.getRpm();
            float rps = rpm / 60.0f;
            float rad = (float)((double)rps * (Math.PI * 2));
            if ((double)entity.getRotation() < Math.PI * 2) {
                if (entity.getTicks() > pPartialTick) {
                    float partial = 1.0f - entity.getTicks() < 0.0f ? -(1.0f - entity.getTicks()) : 1.0f - entity.getTicks();
                    entity.setRotation(entity.getRotation() + rad / 20.0f * partial);
                    entity.setTicks(0.0f);
                }
                entity.setRotation(entity.getRotation() + rad / 20.0f * (entity.getTicks() - pPartialTick));
                entity.setTicks(pPartialTick);
            } else {
                entity.setRotation(0.0f);
            }
            entity.m_6596_();
            entity.setLastRpm(entity.getRpm());
        }
    }

    public int getLightLevel(Level level, BlockPos pos) {
        int block = level.m_45517_(LightLayer.BLOCK, pos);
        int sky = level.m_45517_(LightLayer.SKY, pos);
        return LightTexture.m_109885_((int)block, (int)sky);
    }

    public static void showVenting(TurbineControllerBlockEntity entity) {
        Level level = entity.m_58904_();
        Random random = new Random();
        level.m_6493_((ParticleOptions)ParticleTypes.f_123796_, true, (double)((float)entity.m_58899_().m_123341_() - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.X, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)) + 0.0f), (double)(entity.m_58899_().m_123342_() + entity.getTurbineHeight() - 1), (double)((float)entity.m_58899_().m_123343_() - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.Y, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)) - 1.0f), 0.0, -0.1, -0.1);
        level.m_6493_((ParticleOptions)ParticleTypes.f_123796_, true, (double)((float)entity.m_58899_().m_123341_() - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.X, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)) + 1.0f), (double)(entity.m_58899_().m_123342_() + entity.getTurbineHeight() - 1), (double)((float)entity.m_58899_().m_123343_() - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.Y, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)) - 1.0f), 0.0, -0.1, -0.1);
        level.m_6493_((ParticleOptions)ParticleTypes.f_123796_, true, (double)((float)entity.m_58899_().m_123341_() - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.X, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)) + 2.0f), (double)(entity.m_58899_().m_123342_() + entity.getTurbineHeight() - 1), (double)((float)entity.m_58899_().m_123343_() - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.Y, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)) - 1.0f), 0.0, -0.1, -0.1);
        level.m_6493_((ParticleOptions)ParticleTypes.f_123796_, true, (double)((float)entity.m_58899_().m_123341_() - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.X, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)) + 0.0f), (double)(entity.m_58899_().m_123342_() + entity.getTurbineHeight() - 1), (double)((float)entity.m_58899_().m_123343_() - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.Y, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)) - 1.0f + 4.0f), 0.0, -0.1, 0.1);
        level.m_6493_((ParticleOptions)ParticleTypes.f_123796_, true, (double)((float)entity.m_58899_().m_123341_() - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.X, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)) + 1.0f), (double)(entity.m_58899_().m_123342_() + entity.getTurbineHeight() - 1), (double)((float)entity.m_58899_().m_123343_() - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.Y, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)) - 1.0f + 4.0f), 0.0, -0.1, 0.1);
        level.m_6493_((ParticleOptions)ParticleTypes.f_123796_, true, (double)((float)entity.m_58899_().m_123341_() - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.X, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)) + 2.0f), (double)(entity.m_58899_().m_123342_() + entity.getTurbineHeight() - 1), (double)((float)entity.m_58899_().m_123343_() - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.Y, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)) - 1.0f + 4.0f), 0.0, -0.1, 0.1);
        level.m_6493_((ParticleOptions)ParticleTypes.f_123796_, true, (double)((float)entity.m_58899_().m_123341_() - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.X, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)) + 1.0f + 2.0f), (double)(entity.m_58899_().m_123342_() + entity.getTurbineHeight() - 1), (double)((float)entity.m_58899_().m_123343_() - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.Y, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)) - 1.0f + 1.0f), 0.1, -0.1, 0.0);
        level.m_6493_((ParticleOptions)ParticleTypes.f_123796_, true, (double)((float)entity.m_58899_().m_123341_() - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.X, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)) + 1.0f + 2.0f), (double)(entity.m_58899_().m_123342_() + entity.getTurbineHeight() - 1), (double)((float)entity.m_58899_().m_123343_() - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.Y, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)) - 1.0f + 2.0f), 0.1, -0.1, 0.0);
        level.m_6493_((ParticleOptions)ParticleTypes.f_123796_, true, (double)((float)entity.m_58899_().m_123341_() - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.X, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)) + 1.0f + 2.0f), (double)(entity.m_58899_().m_123342_() + entity.getTurbineHeight() - 1), (double)((float)entity.m_58899_().m_123343_() - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.Y, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)) - 1.0f + 3.0f), 0.1, -0.1, 0.0);
        level.m_6493_((ParticleOptions)ParticleTypes.f_123796_, true, (double)((float)entity.m_58899_().m_123341_() - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.X, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)) + 1.0f - 2.0f), (double)(entity.m_58899_().m_123342_() + entity.getTurbineHeight() - 1), (double)((float)entity.m_58899_().m_123343_() - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.Y, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)) - 1.0f + 1.0f), -0.1, -0.1, 0.0);
        level.m_6493_((ParticleOptions)ParticleTypes.f_123796_, true, (double)((float)entity.m_58899_().m_123341_() - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.X, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)) + 1.0f - 2.0f), (double)(entity.m_58899_().m_123342_() + entity.getTurbineHeight() - 1), (double)((float)entity.m_58899_().m_123343_() - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.Y, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)) - 1.0f + 2.0f), -0.1, -0.1, 0.0);
        level.m_6493_((ParticleOptions)ParticleTypes.f_123796_, true, (double)((float)entity.m_58899_().m_123341_() - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.X, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)) + 1.0f - 2.0f), (double)(entity.m_58899_().m_123342_() + entity.getTurbineHeight() - 1), (double)((float)entity.m_58899_().m_123343_() - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.Y, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING)) - 1.0f + 3.0f), -0.1, -0.1, 0.0);
    }

    public static void showSteamParticles(TurbineControllerBlockEntity entity) {
        Level level = entity.m_58904_();
        Random random = new Random();
        level.m_6493_((ParticleOptions)ParticleTypes.f_123796_, true, (double)((float)entity.m_58899_().m_123341_() + 0.5f + random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.X, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING))), (double)entity.m_58899_().m_123342_(), (double)((float)entity.m_58899_().m_123343_() + 0.5f + random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.Y, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING))), 0.0, (double)(random.nextFloat() / 3.0f), 0.0);
        level.m_6493_((ParticleOptions)ParticleTypes.f_123796_, true, (double)((float)entity.m_58899_().m_123341_() + 0.5f - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.X, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING))), (double)entity.m_58899_().m_123342_(), (double)((float)entity.m_58899_().m_123343_() + 0.5f - random.nextFloat() + TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.Y, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING))), 0.0, (double)(random.nextFloat() / 3.0f), 0.0);
    }

    public static void showFloorParticles(TurbineControllerBlockEntity entity) {
        float xOffset = TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.X, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING));
        float yOffset = TurbineControllerBlockEntityRenderer.getRenderOffset(OffsetType.Y, (Direction)entity.m_58900_().m_61143_((Property)TurbineControllerBlock.FACING));
        BlockPos pos = entity.m_58899_();
        Level level = entity.m_58904_();
        float i = 0.0f;
        while (i < 3.0f) {
            float e = 0.0f;
            while (e < 3.0f) {
                level.m_6493_((ParticleOptions)ParticleTypes.f_123796_, true, (double)((float)pos.m_123341_() + 0.5f + xOffset + i - 1.0f), (double)pos.m_123342_() + 0.2, (double)((float)pos.m_123343_() + 0.5f + yOffset + e - 1.0f), 0.0, 0.0, 0.0);
                e = (float)((double)e + 0.5);
            }
            i = (float)((double)i + 0.5);
        }
    }

    public static float getRenderOffset(OffsetType type, Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> 0.0f;
            case Direction.UP -> 0.0f;
            case Direction.NORTH -> {
                if (type == OffsetType.X) {
                    yield 0.0f;
                }
                yield 2.0f;
            }
            case Direction.SOUTH -> {
                if (type == OffsetType.X) {
                    yield 0.0f;
                }
                yield -2.0f;
            }
            case Direction.WEST -> {
                if (type == OffsetType.X) {
                    yield 2.0f;
                }
                yield 0.0f;
            }
            case Direction.EAST -> type == OffsetType.X ? -2.0f : 0.0f;
        };
    }

    static enum OffsetType {
        X,
        Y;

    }
}

