/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import unhappycodings.thoriumreactors.client.util.RenderUtil;
import unhappycodings.thoriumreactors.common.block.reactor.ReactorControllerBlock;
import unhappycodings.thoriumreactors.common.blockentity.reactor.ReactorControllerBlockEntity;
import unhappycodings.thoriumreactors.common.registration.ModFluids;

public class ReactorControllerBlockEntityRenderer
implements BlockEntityRenderer<ReactorControllerBlockEntity> {
    public ReactorControllerBlockEntityRenderer(BlockEntityRendererProvider.Context ignored) {
    }

    public void render(@NotNull ReactorControllerBlockEntity entity, float pPartialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int pPackedLight, int pPackedOverlay) {
        VertexConsumer boxVertexConsumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)TextureAtlas.f_118259_));
        if (entity.getReactorHeight() > 0 && entity.isAssembled()) {
            float height = (float)entity.getFluidAmountIn() / (float)entity.getReactorCapacity() * ((float)entity.getReactorHeight() - 1.0f);
            float heightOut = (float)entity.getFluidAmountOut() / (float)entity.getReactorCapacity() * ((float)entity.getReactorHeight() - 1.0f);
            BlockPos pos = entity.m_58899_().m_7494_();
            Level level = entity.m_58904_();
            int brightness = LightTexture.m_109885_((int)level.m_45517_(LightLayer.BLOCK, pos), (int)level.m_45517_(LightLayer.SKY, pos));
            Direction direction = (Direction)entity.m_58900_().m_61143_((Property)ReactorControllerBlock.FACING);
            if (entity.getFluidAmountIn() > 20) {
                ReactorControllerBlockEntityRenderer.drawBox(poseStack, boxVertexConsumer, new FluidStack((Fluid)ModFluids.FLOWING_MOLTEN_SALT.get(), 1), height, this.getFluidRenderOffset(FluidOffsetType.X, direction), 0.1f * height * 5.0f, this.getFluidRenderOffset(FluidOffsetType.Y, direction), 15.999f, height, 15.999f, 0.0f, 0.0f, 16.0f, 16.0f, 0.0f, true, brightness);
            }
            if (entity.getFluidAmountOut() > 20) {
                ReactorControllerBlockEntityRenderer.drawBox(poseStack, boxVertexConsumer, new FluidStack((Fluid)ModFluids.FLOWING_HEATED_MOLTEN_SALT.get(), 1), heightOut, this.getFluidRenderOffset(FluidOffsetType.X, direction), 0.1f * heightOut * 5.0f, this.getFluidRenderOffset(FluidOffsetType.Y, direction), 15.999f, heightOut, 15.999f, 0.0f, 0.0f, 16.0f, 16.0f, height - 0.01f, false, brightness);
            }
        }
    }

    public static void drawBox(PoseStack stack, VertexConsumer buffer, FluidStack fluidStack, float height, float pX, float pY, float pZ, float sX, float sY, float sZ, float pUOffset, float pVOffset, float pWidth, float pHeight, float yHeightOffset, boolean renderDown, int pPackedLight) {
        stack.m_85836_();
        ReactorControllerBlockEntityRenderer.drawPlane(stack, buffer, fluidStack, RenderUtil.Perspective.UP, height, pX /= 16.0f, pY /= 16.0f, pZ /= 16.0f, sX /= 16.0f, sY /= 16.0f, sZ /= 16.0f, pUOffset, pVOffset, pWidth, pHeight, yHeightOffset, pPackedLight);
        if (renderDown) {
            ReactorControllerBlockEntityRenderer.drawPlane(stack, buffer, fluidStack, RenderUtil.Perspective.DOWN, height, pX, pY, pZ, sX, sY, sZ, pUOffset, pVOffset, pWidth, pHeight, yHeightOffset, pPackedLight);
        }
        ReactorControllerBlockEntityRenderer.drawPlane(stack, buffer, fluidStack, RenderUtil.Perspective.RIGHT, height, pX, pY, pZ, sX, sY, sZ, pUOffset, pVOffset, pWidth, pHeight, yHeightOffset, pPackedLight);
        ReactorControllerBlockEntityRenderer.drawPlane(stack, buffer, fluidStack, RenderUtil.Perspective.LEFT, height, pX, pY, pZ, sX, sY, sZ, pUOffset, pVOffset, pWidth, pHeight, yHeightOffset, pPackedLight);
        ReactorControllerBlockEntityRenderer.drawPlane(stack, buffer, fluidStack, RenderUtil.Perspective.FRONT, height, pX, pY, pZ, sX, sY, sZ, pUOffset, pVOffset, pWidth, pHeight, yHeightOffset, pPackedLight);
        ReactorControllerBlockEntityRenderer.drawPlane(stack, buffer, fluidStack, RenderUtil.Perspective.BACK, height, pX, pY, pZ, sX, sY, sZ, pUOffset, pVOffset, pWidth, pHeight, yHeightOffset, pPackedLight);
        stack.m_85849_();
    }

    public static void drawPlane(PoseStack stack, VertexConsumer buffer, FluidStack fluidStack, RenderUtil.Perspective perspective, float height, float pX, float pY, float pZ, float sX, float sY, float sZ, float pUOffset, float pVOffset, float pWidth, float pHeight, float yHeightOffset, int pPackedLight) {
        int valueB;
        int valueA;
        int i;
        Integer[] positionIntegers;
        stack.m_85836_();
        Matrix4f matrix4f = stack.m_85850_().m_252922_();
        TextureAtlasSprite icon = RenderUtil.getStillFluidSprite(fluidStack);
        if (icon == null) {
            return;
        }
        sX /= 2.0f;
        sY /= 2.0f;
        sZ /= 2.0f;
        float u1 = icon.m_118367_((double)pUOffset);
        float u2 = icon.m_118367_((double)pWidth);
        float v1 = icon.m_118393_((double)pVOffset);
        float v2 = icon.m_118393_((double)pHeight);
        int color = RenderUtil.getColorTint(fluidStack);
        if (perspective == RenderUtil.Perspective.UP) {
            positionIntegers = new Integer[]{0, 0, -1, -1, 0, -1, 1, -1, 1, 1, 1, 0, 0, 1, -1, 1, -1, 0};
            for (i = 0; i < positionIntegers.length; i += 2) {
                valueA = positionIntegers[i];
                valueB = positionIntegers[i + 1];
                buffer.m_252986_(matrix4f, -sX + pX + (float)valueA, yHeightOffset - 0.01f + height, sZ + pZ + (float)valueB).m_193479_(color).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
                buffer.m_252986_(matrix4f, sX + pX + (float)valueA, yHeightOffset - 0.01f + height, sZ + pZ + (float)valueB).m_193479_(color).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
                buffer.m_252986_(matrix4f, sX + pX + (float)valueA, yHeightOffset - 0.01f + height, -sZ + pZ + (float)valueB).m_193479_(color).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
                buffer.m_252986_(matrix4f, -sX + pX + (float)valueA, yHeightOffset - 0.01f + height, -sZ + pZ + (float)valueB).m_193479_(color).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
            }
        }
        if (perspective == RenderUtil.Perspective.DOWN) {
            positionIntegers = new Integer[]{0, 0, -1, -1, 0, -1, 1, -1, 1, 1, 1, 0, 0, 1, -1, 1, -1, 0};
            for (i = 0; i < positionIntegers.length; i += 2) {
                valueA = positionIntegers[i];
                valueB = positionIntegers[i + 1];
                buffer.m_252986_(matrix4f, -sX + pX + (float)valueA, yHeightOffset + 0.001f, sZ + pZ + (float)valueB).m_193479_(color).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, -sX + pX + (float)valueA, yHeightOffset + 0.001f, -sZ + pZ + (float)valueB).m_193479_(color).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, sX + pX + (float)valueA, yHeightOffset + 0.001f, -sZ + pZ + (float)valueB).m_193479_(color).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, sX + pX + (float)valueA, yHeightOffset + 0.001f, sZ + pZ + (float)valueB).m_193479_(color).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
            }
        }
        Integer[] integerArray = positionIntegers = new Integer[]{1, 0, -1};
        int n = integerArray.length;
        for (int j = 0; j < n; ++j) {
            int valueA2 = integerArray[j];
            float tempHeight = height;
            int j2 = 0;
            while ((double)j2 < Math.ceil(height)) {
                float curHeight = tempHeight < 1.0f ? tempHeight : 1.0f;
                float size = tempHeight > 1.0f ? 16.0f : tempHeight * 16.0f;
                float pY1 = yHeightOffset - sY + pY + ((float)j2 + 1.0f * curHeight) - ((double)(j2 + 1) == Math.ceil(height) ? 0.01f : 0.0f);
                if (perspective == RenderUtil.Perspective.BACK) {
                    v2 = icon.m_118393_((double)size);
                    buffer.m_252986_(matrix4f, sX + pX + 0.999f, pY1, sZ + pZ + (float)valueA2).m_193479_(color).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                    buffer.m_252986_(matrix4f, sX + pX + 0.999f, pY1, -sZ + pZ + (float)valueA2).m_193479_(color).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                    buffer.m_252986_(matrix4f, sX + pX + 0.999f, yHeightOffset + (float)j2, -sZ + pZ + (float)valueA2).m_193479_(color).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                    buffer.m_252986_(matrix4f, sX + pX + 0.999f, yHeightOffset + (float)j2, sZ + pZ + (float)valueA2).m_193479_(color).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                }
                if (perspective == RenderUtil.Perspective.FRONT) {
                    v2 = icon.m_118393_((double)size);
                    buffer.m_252986_(matrix4f, -sX + pX - 0.999f, pY1, sZ + pZ + (float)valueA2).m_193479_(color).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                    buffer.m_252986_(matrix4f, -sX + pX - 0.999f, yHeightOffset + (float)j2, sZ + pZ + (float)valueA2).m_193479_(color).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                    buffer.m_252986_(matrix4f, -sX + pX - 0.999f, yHeightOffset + (float)j2, -sZ + pZ + (float)valueA2).m_193479_(color).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                    buffer.m_252986_(matrix4f, -sX + pX - 0.999f, pY1, -sZ + pZ + (float)valueA2).m_193479_(color).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                }
                if (perspective == RenderUtil.Perspective.RIGHT) {
                    u2 = icon.m_118367_((double)size);
                    buffer.m_252986_(matrix4f, -sX + pX + (float)valueA2, pY1, -sZ + pZ - 0.999f).m_193479_(color).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                    buffer.m_252986_(matrix4f, -sX + pX + (float)valueA2, yHeightOffset + (float)j2, -sZ + pZ - 0.999f).m_193479_(color).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                    buffer.m_252986_(matrix4f, sX + pX + (float)valueA2, yHeightOffset + (float)j2, -sZ + pZ - 0.999f).m_193479_(color).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                    buffer.m_252986_(matrix4f, sX + pX + (float)valueA2, pY1, -sZ + pZ - 0.999f).m_193479_(color).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                }
                if (perspective == RenderUtil.Perspective.LEFT) {
                    u2 = icon.m_118367_((double)size);
                    buffer.m_252986_(matrix4f, -sX + pX + (float)valueA2, pY1, sZ + pZ + 0.999f).m_193479_(color).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                    buffer.m_252986_(matrix4f, sX + pX + (float)valueA2, pY1, sZ + pZ + 0.999f).m_193479_(color).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                    buffer.m_252986_(matrix4f, sX + pX + (float)valueA2, yHeightOffset + (float)j2, sZ + pZ + 0.999f).m_193479_(color).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                    buffer.m_252986_(matrix4f, -sX + pX + (float)valueA2, yHeightOffset + (float)j2, sZ + pZ + 0.999f).m_193479_(color).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                }
                tempHeight -= curHeight;
                ++j2;
            }
        }
        stack.m_85849_();
    }

    public int getFluidRenderOffset(FluidOffsetType type, Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP -> 0;
            case Direction.NORTH -> {
                if (type == FluidOffsetType.X) {
                    yield 8;
                }
                yield 40;
            }
            case Direction.SOUTH -> {
                if (type == FluidOffsetType.X) {
                    yield 8;
                }
                yield -24;
            }
            case Direction.WEST -> {
                if (type == FluidOffsetType.X) {
                    yield 40;
                }
                yield 8;
            }
            case Direction.EAST -> type == FluidOffsetType.X ? -24 : 8;
        };
    }

    static enum FluidOffsetType {
        X,
        Y;

    }
}

