/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import unhappycodings.thoriumreactors.client.renderer.FluidTankBlockEntityRenderer;
import unhappycodings.thoriumreactors.common.block.tank.FluidTankBlock;
import unhappycodings.thoriumreactors.common.registration.ModBlocks;

public class FluidTankItemStackRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final ResourceLocation MODEL_LOCATION = new ResourceLocation("thoriumreactors", "block/fluid_tank");

    public FluidTankItemStackRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet modelSet) {
        super(dispatcher, modelSet);
    }

    public void m_108829_(ItemStack stack, @NotNull ItemDisplayContext displayContext, PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
        poseStack.m_85849_();
        poseStack.m_85836_();
        BakedModel mainModel = Minecraft.m_91087_().m_91304_().getModel(MODEL_LOCATION);
        mainModel = mainModel.applyTransform(displayContext, poseStack, FluidTankItemStackRenderer.isLeftHand(displayContext));
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        boolean glint = stack.m_41790_();
        for (RenderType type : mainModel.getRenderTypes(stack, true)) {
            type = RenderTypeHelper.getEntityRenderType((RenderType)type, (boolean)true);
            VertexConsumer consumer = ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)type, (boolean)true, (boolean)glint);
            renderer.m_115189_(mainModel, stack, packedLight, packedOverlay, poseStack, consumer);
            CompoundTag tag = stack.m_41784_().m_128469_("BlockEntityTag");
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("Fluid"));
            VertexConsumer boxVertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)TextureAtlas.f_118259_));
            if (fluidStack.getAmount() <= 0) continue;
            float height = (float)fluidStack.getAmount() / (float)this.getCapacityForType(stack) * 0.94f;
            FluidTankBlockEntityRenderer.drawBox(poseStack, boxVertexConsumer, fluidStack, 0.0f, 0.0f, 0.0f, 11.0f, 0.01f, 11.0f, 0.0f, 0.0f, 16.0f, 16.0f, height, 0.032f, packedLight);
        }
    }

    private int getCapacityForType(ItemStack stack) {
        if (stack.m_150930_(((FluidTankBlock)((Object)ModBlocks.SIMPLE_FLUID_TANK.get())).m_5456_())) {
            return 32000;
        }
        if (stack.m_150930_(((FluidTankBlock)((Object)ModBlocks.GENERIC_FLUID_TANK.get())).m_5456_())) {
            return 64000;
        }
        if (stack.m_150930_(((FluidTankBlock)((Object)ModBlocks.PROGRESSIVE_FLUID_TANK.get())).m_5456_())) {
            return 128000;
        }
        return Integer.MAX_VALUE;
    }

    private static boolean isLeftHand(ItemDisplayContext type) {
        return type == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || type == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
    }
}

