/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import unhappycodings.thoriumreactors.client.util.RenderUtil;
import unhappycodings.thoriumreactors.common.blockentity.tank.FluidTankBlockEntity;

public class FluidTankBlockEntityRenderer
implements BlockEntityRenderer<FluidTankBlockEntity> {
    public FluidTankBlockEntityRenderer(BlockEntityRendererProvider.Context ignored) {
    }

    public void render(@NotNull FluidTankBlockEntity entity, float pPartialTick, @NotNull PoseStack stack, @NotNull MultiBufferSource buffer, int pPackedLight, int pPackedOverlay) {
        VertexConsumer boxVertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)TextureAtlas.f_118259_));
        if (entity.getFluidAmountIn() > 0) {
            float height = (float)entity.getFluidAmountIn() / (float)entity.getFluidCapacityIn() * 0.94f;
            FluidTankBlockEntityRenderer.drawBox(stack, boxVertexConsumer, entity.getFluidIn(), 0.0f, 0.0f, 0.0f, 11.0f, 0.01f, 11.0f, 0.0f, 0.0f, 16.0f, 16.0f, height, 0.032f, pPackedLight);
        }
    }

    public static void drawBox(PoseStack stack, VertexConsumer buffer, FluidStack fluid, float pX, float pY, float pZ, float sX, float sY, float sZ, float pUOffset, float pVOffset, float pWidth, float pHeight, float height, float yOffset, int pPackedLight) {
        stack.m_85836_();
        pX += 8.0f;
        pY += sY / 2.0f;
        pZ += 8.0f;
        FluidTankBlockEntityRenderer.drawPlane(stack, buffer, fluid, RenderUtil.Perspective.UP, height, pX /= 16.0f, pY /= 16.0f, pZ /= 16.0f, sX /= 16.0f, sY /= 16.0f, sZ /= 16.0f, pUOffset, pVOffset, pWidth, pHeight, yOffset, pPackedLight);
        FluidTankBlockEntityRenderer.drawPlane(stack, buffer, fluid, RenderUtil.Perspective.DOWN, height, pX, pY, pZ, sX, sY, sZ, pUOffset, pVOffset, pWidth, pHeight, yOffset, pPackedLight);
        FluidTankBlockEntityRenderer.drawPlane(stack, buffer, fluid, RenderUtil.Perspective.RIGHT, height, pX, pY, pZ, sX, sY, sZ, pUOffset, pVOffset, pWidth, pHeight, yOffset, pPackedLight);
        FluidTankBlockEntityRenderer.drawPlane(stack, buffer, fluid, RenderUtil.Perspective.LEFT, height, pX, pY, pZ, sX, sY, sZ, pUOffset, pVOffset, pWidth, pHeight, yOffset, pPackedLight);
        FluidTankBlockEntityRenderer.drawPlane(stack, buffer, fluid, RenderUtil.Perspective.FRONT, height, pX, pY, pZ, sX, sY, sZ, pUOffset, pVOffset, pWidth, pHeight, yOffset, pPackedLight);
        FluidTankBlockEntityRenderer.drawPlane(stack, buffer, fluid, RenderUtil.Perspective.BACK, height, pX, pY, pZ, sX, sY, sZ, pUOffset, pVOffset, pWidth, pHeight, yOffset, pPackedLight);
        stack.m_85849_();
    }

    public static void drawPlane(PoseStack stack, VertexConsumer buffer, FluidStack fluidStack, RenderUtil.Perspective perspective, float height, float pX, float pY, float pZ, float sX, float sY, float sZ, float pUOffset, float pVOffset, float pWidth, float pHeight, float yHeightOffset, int pPackedLight) {
        stack.m_85836_();
        Matrix4f matrix4f = stack.m_85850_().m_252922_();
        TextureAtlasSprite icon = RenderUtil.getStillFluidSprite(fluidStack);
        if (icon == null) {
            return;
        }
        sX /= 2.0f;
        sY /= 2.0f;
        sZ /= 2.0f;
        float u1 = icon.m_118367_((double)pUOffset);
        float u2 = icon.m_118367_((double)pWidth);
        float v1 = icon.m_118393_((double)pVOffset);
        float v2 = icon.m_118393_((double)pHeight);
        int color = RenderUtil.getColorTint(fluidStack);
        if (perspective == RenderUtil.Perspective.UP) {
            buffer.m_252986_(matrix4f, -sX + pX, yHeightOffset - 0.01f + height, sZ + pZ).m_193479_(color).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
            buffer.m_252986_(matrix4f, sX + pX, yHeightOffset - 0.01f + height, sZ + pZ).m_193479_(color).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
            buffer.m_252986_(matrix4f, sX + pX, yHeightOffset - 0.01f + height, -sZ + pZ).m_193479_(color).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
            buffer.m_252986_(matrix4f, -sX + pX, yHeightOffset - 0.01f + height, -sZ + pZ).m_193479_(color).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        }
        if (perspective == RenderUtil.Perspective.DOWN) {
            buffer.m_252986_(matrix4f, -sX + pX, yHeightOffset, sZ + pZ).m_193479_(color).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix4f, -sX + pX, yHeightOffset, -sZ + pZ).m_193479_(color).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix4f, sX + pX, yHeightOffset, -sZ + pZ).m_193479_(color).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix4f, sX + pX, yHeightOffset, sZ + pZ).m_193479_(color).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
        }
        float tempHeight = height;
        int j = 0;
        while ((double)j < Math.ceil(height)) {
            float curHeight = tempHeight < 1.0f ? tempHeight : 1.0f;
            float size = tempHeight > 1.0f ? 16.0f : tempHeight * 16.0f;
            float pY1 = yHeightOffset - sY + pY + ((float)j + 1.0f * curHeight) - ((double)(j + 1) == Math.ceil(height) ? 0.01f : 0.0f);
            if (perspective == RenderUtil.Perspective.BACK) {
                v2 = icon.m_118393_((double)size);
                buffer.m_252986_(matrix4f, sX + pX, pY1, sZ + pZ).m_193479_(color).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, sX + pX, pY1, -sZ + pZ).m_193479_(color).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, sX + pX, yHeightOffset + (float)j, -sZ + pZ).m_193479_(color).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, sX + pX, yHeightOffset + (float)j, sZ + pZ).m_193479_(color).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            }
            if (perspective == RenderUtil.Perspective.FRONT) {
                v2 = icon.m_118393_((double)size);
                buffer.m_252986_(matrix4f, -sX + pX, pY1, sZ + pZ).m_193479_(color).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, -sX + pX, yHeightOffset + (float)j, sZ + pZ).m_193479_(color).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, -sX + pX, yHeightOffset + (float)j, -sZ + pZ).m_193479_(color).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, -sX + pX, pY1, -sZ + pZ).m_193479_(color).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            }
            if (perspective == RenderUtil.Perspective.RIGHT) {
                v2 = icon.m_118393_((double)size);
                buffer.m_252986_(matrix4f, -sX + pX, pY1, -sZ + pZ).m_193479_(color).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, -sX + pX, yHeightOffset + (float)j, -sZ + pZ).m_193479_(color).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, sX + pX, yHeightOffset + (float)j, -sZ + pZ).m_193479_(color).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, sX + pX, pY1, -sZ + pZ).m_193479_(color).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            }
            if (perspective == RenderUtil.Perspective.LEFT) {
                v2 = icon.m_118393_((double)size);
                buffer.m_252986_(matrix4f, -sX + pX, pY1, sZ + pZ).m_193479_(color).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, sX + pX, pY1, sZ + pZ).m_193479_(color).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, sX + pX, yHeightOffset + (float)j, sZ + pZ).m_193479_(color).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, -sX + pX, yHeightOffset + (float)j, sZ + pZ).m_193479_(color).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            }
            tempHeight -= curHeight;
            ++j;
        }
        stack.m_85849_();
    }
}

