/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.client.integration.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import unhappycodings.thoriumreactors.client.integration.jei.JEIModIntegration;
import unhappycodings.thoriumreactors.common.recipe.BlastingRecipe;
import unhappycodings.thoriumreactors.common.registration.ModBlocks;
import unhappycodings.thoriumreactors.common.util.ScreenUtil;

public class BlastingRecipeCategory
implements IRecipeCategory<BlastingRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("thoriumreactors", "blasting");
    public static final ResourceLocation TEXTURE = new ResourceLocation("thoriumreactors", "textures/gui/gui_jei.png");
    private final IGuiHelper helper;
    private final IDrawable background;
    private final IDrawable icon;
    private IDrawable progress;
    private IDrawable heating;

    public BlastingRecipeCategory(IGuiHelper helper) {
        this.background = helper.drawableBuilder(TEXTURE, 0, 108, 116, 35).addPadding(20, 20, 10, 22).build();
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.BLAST_FURNACE_BLOCK.get()));
        this.helper = helper;
    }

    @NotNull
    public List<Component> getTooltipStrings(@NotNull BlastingRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (ScreenUtil.mouseInArea(62, 20, 77, 35, (int)mouseX, (int)mouseY)) {
            list.add((Component)Component.m_237113_((String)(recipe.getTemperature() + "\u00b0C")));
        }
        return list;
    }

    public void draw(@NotNull BlastingRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        if (this.progress == null || this.heating == null) {
            this.progress = this.helper.createAnimatedDrawable(this.helper.createDrawable(TEXTURE, 222, 247, 34, 9), recipe.getTicks(), IDrawableAnimated.StartDirection.LEFT, false);
            this.heating = this.helper.createAnimatedDrawable(this.helper.createDrawable(TEXTURE, 240, 231, 16, 16), 80, IDrawableAnimated.StartDirection.BOTTOM, false);
        }
        this.progress.draw(guiGraphics, 53, 41);
        this.heating.draw(guiGraphics, 62, 20);
        ScreenUtil.drawCenteredText("Blasting", guiGraphics, this.getBackground().getWidth() / 2, 6, false);
        ScreenUtil.drawCenteredText(recipe.getTicks() / 20 + "s ", guiGraphics, this.getBackground().getWidth() / 2, 60, false);
        if (recipe.getSecondaryChance() > 0) {
            ScreenUtil.drawCenteredText(recipe.getSecondaryChance() + "%", guiGraphics, 120, 60, false);
        }
    }

    @NotNull
    public RecipeType<BlastingRecipe> getRecipeType() {
        return JEIModIntegration.BLASTING_RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)"block.thoriumreactors.blast_furnace_block");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BlastingRecipe recipe, @NotNull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, 11, 38).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 32, 38).addIngredients(((Ingredient)recipe.m_7527_().get(1)).m_43908_().length > 0 ? (Ingredient)recipe.m_7527_().get(1) : Ingredient.f_43901_);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 91, 38).addItemStack(recipe.m_8043_(null));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 109, 38).addItemStack(recipe.getSecondaryResultItem());
    }
}

