/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.client.integration.jade;

import java.text.SimpleDateFormat;
import mcjty.theoneprobe.api.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IBoxStyle;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import unhappycodings.thoriumreactors.common.block.reactor.ReactorValveBlock;
import unhappycodings.thoriumreactors.common.block.thermal.ThermalValveBlock;
import unhappycodings.thoriumreactors.common.blockentity.base.MachineContainerBlockEntity;
import unhappycodings.thoriumreactors.common.blockentity.machine.MachineBlastFurnaceBlockEntity;
import unhappycodings.thoriumreactors.common.blockentity.reactor.ReactorControllerBlockEntity;
import unhappycodings.thoriumreactors.common.blockentity.reactor.ReactorValveBlockEntity;
import unhappycodings.thoriumreactors.common.blockentity.tank.EnergyTankBlockEntity;
import unhappycodings.thoriumreactors.common.blockentity.thermal.ThermalValveBlockEntity;
import unhappycodings.thoriumreactors.common.blockentity.turbine.TurbineControllerBlockEntity;
import unhappycodings.thoriumreactors.common.blockentity.turbine.TurbinePowerPortBlockEntity;
import unhappycodings.thoriumreactors.common.blockentity.turbine.TurbineValveBlockEntity;
import unhappycodings.thoriumreactors.common.enums.ThermalValveTypeEnum;
import unhappycodings.thoriumreactors.common.enums.ValveTypeEnum;
import unhappycodings.thoriumreactors.common.registration.ModBlocks;
import unhappycodings.thoriumreactors.common.util.FormattingUtil;

public enum JadeTooltipRenderer implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;

    public static final int COLOR_A;
    public static final int COLOR_B;

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity != null && accessor.getBlockState().m_60734_().m_7705_().contains("thoriumreactors")) {
            BlockEntity entity;
            String[] fluids;
            CompoundTag serverData = accessor.getServerData();
            IElementHelper elements = tooltip.getElementHelper();
            if (serverData.m_128441_("Energy")) {
                tooltip.add(this.energyBar(elements, serverData.m_128454_("Energy"), serverData.m_128454_("EnergyCapacity"), (Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.top_info.energy")).m_130940_(ChatFormatting.WHITE)));
            }
            for (String fluidName : fluids = new String[]{"FluidIn", "FluidOut"}) {
                if (!serverData.m_128441_(fluidName)) continue;
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)serverData.m_128469_(fluidName));
                tooltip.add(this.fluidBar(elements, fluid, fluid.getAmount(), serverData.m_128451_(fluidName + "Capacity")));
            }
            if (blockEntity instanceof TurbineControllerBlockEntity) {
                entity = (TurbineControllerBlockEntity)blockEntity;
                if (!serverData.m_128471_("TurbineActivated")) {
                    tooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("turbine.top_info.turbine")).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.top_info.inactive"))).m_130948_(FormattingUtil.hex(10420230)));
                    return;
                }
                tooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("turbine.top_info.turbine")).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.top_info.active"))).m_130948_(FormattingUtil.hex(43275)));
                tooltip.add(this.energyBar(elements, serverData.m_128454_("TurbineEnergy"), serverData.m_128454_("TurbineEnergyCapacity"), (Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.top_info.energy")).m_130940_(ChatFormatting.WHITE)));
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)serverData.m_128469_("TurbineFluid"));
                tooltip.add(this.fluidBar(elements, fluid, fluid.getAmount(), 10000));
                tooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("turbine.top_info.producing")).m_130948_(FormattingUtil.hex(8311637)).m_7220_((Component)Component.m_237113_((String)(entity.isCoilsEngaged() ? FormattingUtil.formatEnergy(entity.getTurbineGeneration()) : "0 FE/t")).m_130940_(ChatFormatting.WHITE)));
                tooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("turbine.top_info.speed")).m_130948_(FormattingUtil.hex(5624714)).m_7220_((Component)Component.m_237113_((String)(Math.floor(entity.getRpm() * 100.0f) / 100.0 + " ")).m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("turbine.top_info.rpm"))).m_130940_(ChatFormatting.WHITE)));
                tooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("turbine.top_info.flowrate")).m_130948_(FormattingUtil.hex(708302)).m_7220_((Component)Component.m_237113_((String)(entity.getCurrentFlowrate() + " mB/t")).m_130940_(ChatFormatting.WHITE)));
                tooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("turbine.top_info.best_performing_at")).m_130948_(FormattingUtil.hex(5624714)));
            }
            if (blockEntity instanceof ReactorControllerBlockEntity) {
                int i;
                entity = (ReactorControllerBlockEntity)blockEntity;
                if (!serverData.m_128471_("ReactorActivated")) {
                    tooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.top_info.reactor")).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.top_info.inactive"))).m_130948_(FormattingUtil.hex(10420230)));
                    return;
                }
                tooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.top_info.reactor")).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.top_info.active"))).m_130948_(FormattingUtil.hex(43275)));
                for (int i2 = 0; i2 < 4; ++i2) {
                    ReactorValveBlockEntity valveBlockEntity;
                    String fluidName;
                    fluidName = accessor.getLevel().m_7702_(BlockEntity.m_187472_((CompoundTag)serverData.m_128469_("ValvePos-" + i2)));
                    if (!(fluidName instanceof ReactorValveBlockEntity) || (valveBlockEntity = (ReactorValveBlockEntity)((Object)fluidName)).m_58900_().m_61143_(ReactorValveBlock.TYPE) != ValveTypeEnum.FLUID_INPUT && valveBlockEntity.m_58900_().m_61143_(ReactorValveBlock.TYPE) != ValveTypeEnum.FLUID_OUTPUT) continue;
                    FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)serverData.m_128469_("ValveFluid-" + i2));
                    tooltip.add(this.fluidBar(elements, fluid, fluid.getAmount(), 1000));
                }
                int fuelValue = 0;
                int controlValue = 0;
                for (i = 0; i < entity.getFuelRodStatus().length; ++i) {
                    fuelValue += entity.getFuelRodStatus()[i];
                }
                for (i = 0; i < entity.getControlRodStatus().length; ++i) {
                    controlValue += entity.getControlRodStatus()[i];
                }
                tooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.top_info.rod_insert")).m_130948_(FormattingUtil.hex(8311637)).m_7220_((Component)Component.m_237113_((String)((int)((float)controlValue / 6400.0f * 100.0f) + "%")).m_130940_(ChatFormatting.WHITE)));
                tooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.top_info.uranium_fuel")).m_130948_(FormattingUtil.hex(5624714)).m_7220_((Component)Component.m_237113_((String)((int)((float)fuelValue / 8100.0f * 100.0f) + "%")).m_130940_(ChatFormatting.WHITE)));
                tooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.top_info.reactor_load")).m_130948_(FormattingUtil.hex(708302)).m_7220_((Component)Component.m_237113_((String)((int)((entity.getReactorCurrentTemperature() - 22.0f) / 949.0f * 100.0f) + "%")).m_130940_(ChatFormatting.WHITE)));
                tooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.top_info.status")).m_130948_(FormattingUtil.hex(708302)).m_7220_((Component)Component.m_237113_((String)(Math.floor(entity.getReactorStatus() * 10.0f) / 10.0 + "%")).m_130940_(ChatFormatting.WHITE)));
            }
            if (blockEntity instanceof ReactorValveBlockEntity) {
                entity = (ReactorValveBlockEntity)blockEntity;
                tooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.top_info.type")).m_130948_(FormattingUtil.hex(8311637)).m_7220_((Component)Component.m_237115_((String)((ValveTypeEnum)((Object)entity.m_58900_().m_61143_(ReactorValveBlock.TYPE))).m_7912_()).m_130940_(ChatFormatting.WHITE)));
            }
            if (blockEntity instanceof ThermalValveBlockEntity) {
                entity = (ThermalValveBlockEntity)blockEntity;
                tooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("reactor.top_info.type")).m_130948_(FormattingUtil.hex(8311637)).m_7220_((Component)Component.m_237115_((String)((ThermalValveTypeEnum)((Object)entity.m_58900_().m_61143_(ThermalValveBlock.TYPE))).m_7912_()).m_130940_(ChatFormatting.WHITE)));
            }
            if (serverData.m_128441_("Production")) {
                tooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.top_info.producing")).m_130948_(FormattingUtil.hex(8311637)).m_7220_((Component)Component.m_237113_((String)(FormattingUtil.formatEnergy(serverData.m_128451_("Production")) + "/t")).m_130940_(ChatFormatting.WHITE)));
            }
            if (serverData.m_128441_("Fuel") && blockEntity instanceof MachineBlastFurnaceBlockEntity) {
                SimpleDateFormat format = new SimpleDateFormat("mm'm' ss's'");
                float fuel = (float)serverData.m_128451_("Fuel") / 20.0f * 1000.0f + (float)(serverData.m_128451_("Fuel") > 0 ? 1000 : 0);
                tooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.top_info.fuel")).m_130948_(FormattingUtil.hex(5624714)).m_7220_((Component)Component.m_237113_((String)format.format(Float.valueOf(fuel))).m_130940_(ChatFormatting.WHITE)));
            }
            if (serverData.m_128441_("RecipeTime")) {
                tooltip.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.top_info.recipe")).m_130948_(FormattingUtil.hex(8311637)).m_7220_((Component)Component.m_237113_((String)FormattingUtil.formatPercentNum(serverData.m_128451_("MaxRecipeTime") - serverData.m_128451_("RecipeTime"), serverData.m_128451_("MaxRecipeTime"), false)).m_130940_(ChatFormatting.WHITE)));
            }
        }
    }

    private IElement energyBar(IElementHelper helper, long min, long max, Component prefix) {
        BoxStyle style = new BoxStyle();
        style.borderColor = Color.rgb((int)65, (int)65, (int)65, (int)255);
        style.borderWidth = 0.75f;
        return helper.progress((float)min / (float)max, (Component)prefix.m_6881_().m_7220_((Component)Component.m_237113_((String)(min == Integer.MAX_VALUE ? "Infinite" : FormattingUtil.formatNum(min)))), helper.progressStyle().color(COLOR_A, COLOR_B).textColor(0xFFFFFF), (IBoxStyle)style, true);
    }

    private IElement fluidBar(IElementHelper helper, FluidStack fluid, int amount, int capacity) {
        BoxStyle style = new BoxStyle();
        style.borderColor = Color.rgb((int)65, (int)65, (int)65, (int)255);
        style.borderWidth = 0.75f;
        return helper.progress((float)amount / (float)capacity, (Component)fluid.getDisplayName().m_6881_().m_7220_((Component)Component.m_237113_((String)(": " + (String)(amount == Integer.MAX_VALUE ? "Infinite" : amount + " mB")))), helper.progressStyle().overlay(helper.fluid(JadeFluidObject.of((Fluid)fluid.getFluid()))), (IBoxStyle)style, true);
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        CompoundTag tag;
        Object entity;
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof MachineContainerBlockEntity && (entity = (MachineContainerBlockEntity)blockEntity).m_5995_().m_128441_("Energy")) {
            data.m_128356_("Energy", (long)((MachineContainerBlockEntity)((Object)entity)).getEnergy());
            data.m_128356_("EnergyCapacity", (long)((MachineContainerBlockEntity)((Object)entity)).getCapacity());
        }
        if (blockEntity instanceof TurbinePowerPortBlockEntity && ((TurbinePowerPortBlockEntity)(entity = (TurbinePowerPortBlockEntity)blockEntity)).m_5995_().m_128441_("Energy")) {
            data.m_128356_("Energy", (long)((TurbinePowerPortBlockEntity)entity).getEnergy());
            data.m_128356_("EnergyCapacity", (long)((TurbinePowerPortBlockEntity)entity).getCapacity());
        }
        if (blockEntity instanceof EnergyTankBlockEntity && ((EnergyTankBlockEntity)(entity = (EnergyTankBlockEntity)blockEntity)).m_5995_().m_128441_("Energy")) {
            data.m_128356_("Energy", (long)((EnergyTankBlockEntity)entity).getEnergy());
            data.m_128356_("EnergyCapacity", (long)((EnergyTankBlockEntity)entity).getCapacity());
        }
        for (Direction value : Direction.values()) {
            blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, value).ifPresent(storage -> {
                String[] fluids;
                for (String fluid : fluids = new String[]{"FluidIn", "FluidOut"}) {
                    if (!blockEntity.m_5995_().m_128441_(fluid)) continue;
                    data.m_128365_(fluid, blockEntity.m_5995_().m_128423_(fluid));
                    data.m_128405_(fluid + "Capacity", storage.getTankCapacity(0));
                }
            });
        }
        if (blockEntity instanceof ReactorControllerBlockEntity) {
            entity = (ReactorControllerBlockEntity)blockEntity;
            data.m_128379_("ReactorActivated", ((ReactorControllerBlockEntity)((Object)entity)).isReactorActive());
            if (((ReactorControllerBlockEntity)((Object)entity)).valvePos == null) {
                return;
            }
            for (int i = 0; i < ((ReactorControllerBlockEntity)((Object)entity)).valvePos.size(); ++i) {
                ReactorValveBlockEntity valveBlockEntity;
                BlockEntity blockEntity2 = accessor.getLevel().m_7702_(((ReactorControllerBlockEntity)((Object)entity)).valvePos.get(i));
                if (!(blockEntity2 instanceof ReactorValveBlockEntity) || (valveBlockEntity = (ReactorValveBlockEntity)blockEntity2).m_58900_().m_61143_(ReactorValveBlock.TYPE) != ValveTypeEnum.FLUID_INPUT && valveBlockEntity.m_58900_().m_61143_(ReactorValveBlock.TYPE) != ValveTypeEnum.FLUID_OUTPUT) continue;
                data.m_128365_("ValveFluid-" + i, valveBlockEntity.m_5995_().m_128423_("FluidIn"));
                data.m_128365_("ValvePos-" + i, (Tag)this.parsePosToTag(valveBlockEntity.m_58899_()));
            }
        }
        if (blockEntity instanceof TurbineControllerBlockEntity) {
            entity = (TurbineControllerBlockEntity)blockEntity;
            data.m_128379_("TurbineActivated", ((TurbineControllerBlockEntity)((Object)entity)).isActivated());
            BlockEntity blockEntity3 = entity.m_58904_().m_7702_(((TurbineControllerBlockEntity)((Object)entity)).getValvePos());
            if (blockEntity3 instanceof TurbineValveBlockEntity) {
                TurbineValveBlockEntity valveBlockEntity = (TurbineValveBlockEntity)blockEntity3;
                data.m_128365_("TurbineFluid", valveBlockEntity.m_5995_().m_128423_("FluidIn"));
            }
            if ((blockEntity3 = entity.m_58904_().m_7702_(((TurbineControllerBlockEntity)((Object)entity)).getPowerPortPos())) instanceof TurbinePowerPortBlockEntity) {
                TurbinePowerPortBlockEntity powerPortBlockEntity = (TurbinePowerPortBlockEntity)blockEntity3;
                data.m_128405_("TurbineEnergy", powerPortBlockEntity.getEnergy());
                data.m_128405_("TurbineEnergyCapacity", powerPortBlockEntity.getCapacity());
            }
        }
        if ((tag = blockEntity.m_5995_()).m_128441_("RecipeTime")) {
            data.m_128405_("RecipeTime", tag.m_128451_("RecipeTime"));
            data.m_128405_("MaxRecipeTime", tag.m_128451_("MaxRecipeTime"));
        }
        if (tag.m_128441_("Production")) {
            data.m_128405_("Production", tag.m_128451_("Production"));
        }
        if (tag.m_128441_("Fuel") && blockEntity.m_58900_().m_60713_((Block)ModBlocks.GENERATOR_BLOCK.get())) {
            data.m_128405_("Fuel", tag.m_128451_("Fuel"));
            data.m_128405_("MaxFuel", tag.m_128451_("MaxFuel"));
        }
    }

    public CompoundTag parsePosToTag(BlockPos pos) {
        CompoundTag position = new CompoundTag();
        position.m_128405_("x", pos.m_123341_());
        position.m_128405_("y", pos.m_123342_());
        position.m_128405_("z", pos.m_123343_());
        return position;
    }

    public ResourceLocation getUid() {
        return new ResourceLocation("thoriumreactors", "machines");
    }

    public boolean enabledByDefault() {
        return true;
    }

    static {
        COLOR_A = Color.rgb((int)66, (int)150, (int)0, (int)255);
        COLOR_B = Color.rgb((int)67, (int)204, (int)0, (int)255);
    }
}

