/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.recipe.result;

import com.klikli_dev.theurgy.content.recipe.result.RecipeResult;
import com.klikli_dev.theurgy.util.TagUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class TagRecipeResult
extends RecipeResult {
    public static final Codec<TagRecipeResult> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)TagKey.m_203877_((ResourceKey)Registries.f_256913_).fieldOf("tag").forGetter(getter -> getter.tag), (App)Codec.INT.fieldOf("count").forGetter(getter -> getter.count), (App)CompoundTag.f_128325_.optionalFieldOf("nbt").forGetter(getter -> Optional.ofNullable(getter.nbt))).apply((Applicative)builder, TagRecipeResult::new));
    public static byte TYPE = 1;
    private final TagKey<Item> tag;
    private final int count;
    @Nullable
    private final CompoundTag nbt;
    @Nullable
    protected ItemStack cachedOutputStack;
    @Nullable
    private ItemStack[] cachedStacks;

    public TagRecipeResult(TagKey<Item> tag, int count) {
        this(tag, count, (CompoundTag)null);
    }

    public TagRecipeResult(TagKey<Item> tag, int count, Optional<CompoundTag> nbt) {
        this(tag, count, (CompoundTag)nbt.orElse(null));
    }

    public TagRecipeResult(TagKey<Item> tag, int count, @Nullable CompoundTag nbt) {
        this.tag = tag;
        this.count = count;
        this.nbt = nbt;
    }

    public static TagRecipeResult fromNetwork(FriendlyByteBuf pBuffer) {
        TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)pBuffer.m_130281_());
        int count = pBuffer.m_130242_();
        CompoundTag nbt = pBuffer.readBoolean() ? pBuffer.m_130260_() : null;
        return new TagRecipeResult((TagKey<Item>)tag, count, nbt);
    }

    public TagKey<Item> getTag() {
        return this.tag;
    }

    public int getCount() {
        return this.count;
    }

    @Nullable
    public CompoundTag getNbt() {
        return this.nbt;
    }

    public boolean hasNbt() {
        return this.nbt != null;
    }

    @Override
    public ItemStack getStack() {
        if (this.cachedOutputStack == null) {
            ItemStack item = TagUtil.getItemStackForTag(this.tag).m_41777_();
            item.m_41764_(this.count);
            item.m_41751_(this.nbt);
            if (item.m_41619_()) {
                item = new ItemStack((ItemLike)Blocks.f_50375_).m_41714_((Component)Component.m_237113_((String)("Empty Tag: " + String.valueOf(this.tag.f_203868_()))));
            }
            this.cachedOutputStack = item;
        }
        return this.cachedOutputStack;
    }

    @Override
    public ItemStack[] getStacks() {
        if (this.cachedStacks == null) {
            this.cachedStacks = (ItemStack[])ForgeRegistries.ITEMS.tags().getTag(this.tag).stream().map(ItemStack::new).toArray(ItemStack[]::new);
        }
        return this.cachedStacks;
    }

    @Override
    public byte getType() {
        return TYPE;
    }

    @Override
    public void toNetwork(FriendlyByteBuf pBuffer) {
        super.toNetwork(pBuffer);
        pBuffer.m_130085_(this.tag.f_203868_());
        pBuffer.m_130130_(this.count);
        pBuffer.writeBoolean(this.nbt != null);
        if (this.nbt != null) {
            pBuffer.m_130079_(this.nbt);
        }
    }
}

