/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.klikli_dev.theurgy.content.recipe.ingredient.FluidIngredient;
import com.klikli_dev.theurgy.content.recipe.wrapper.RecipeWrapperWithFluid;
import com.klikli_dev.theurgy.datagen.recipe.IngredientWithCount;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.RecipeSerializerRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class DigestionRecipe
implements Recipe<RecipeWrapperWithFluid> {
    public static final int DEFAULT_TIME = 200;
    public static final Codec<DigestionRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FluidIngredient.CODEC.fieldOf("fluid").forGetter(r -> r.fluid), (App)Codec.INT.fieldOf("fluidAmount").forGetter(r -> r.fluidAmount), (App)IngredientWithCount.CODEC.listOf().fieldOf("ingredients").forGetter(r -> r.ingredientsWithCount), (App)ItemStack.f_41582_.fieldOf("result").forGetter(r -> r.result), (App)Codec.INT.optionalFieldOf("time", (Object)200).forGetter(r -> r.time)).apply((Applicative)instance, DigestionRecipe::new));
    protected final FluidIngredient fluid;
    protected final int fluidAmount;
    protected final List<IngredientWithCount> ingredientsWithCount;
    protected final NonNullList<Ingredient> ingredients;
    protected final ItemStack result;
    protected final int time;
    protected ResourceLocation id;

    public DigestionRecipe(FluidIngredient fluid, int fluidAmount, List<IngredientWithCount> ingredientsWithCount, ItemStack result, int time) {
        this.fluid = fluid;
        this.fluidAmount = fluidAmount;
        this.ingredientsWithCount = ingredientsWithCount;
        this.ingredients = ingredientsWithCount.stream().map(IngredientWithCount::ingredient).collect(NonNullList::m_122779_, AbstractList::add, AbstractCollection::addAll);
        this.result = result;
        this.time = time;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypeRegistry.DIGESTION.get();
    }

    public boolean matches(RecipeWrapperWithFluid pContainer, Level pLevel) {
        boolean fluidMatches;
        FluidStack fluid = pContainer.getTank().getFluidInTank(0);
        boolean bl = fluidMatches = this.fluid.test(fluid) && fluid.getAmount() >= this.fluidAmount;
        if (!fluidMatches) {
            return false;
        }
        IntArrayList visited = new IntArrayList();
        for (IngredientWithCount ingredient : this.ingredientsWithCount) {
            boolean found = false;
            for (int i = 0; i < pContainer.m_6643_(); ++i) {
                if (visited.contains(i)) continue;
                ItemStack stack = pContainer.m_8020_(i);
                if (!ingredient.ingredient().test(stack) || stack.m_41613_() < ingredient.count()) continue;
                found = true;
                visited.add(i);
                break;
            }
            if (found) continue;
            return false;
        }
        for (int i = 0; i < pContainer.m_6643_(); ++i) {
            ItemStack stack;
            if (visited.contains(i) || (stack = pContainer.m_8020_(i)).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(RecipeWrapperWithFluid pInv, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public List<IngredientWithCount> getIngredientsWithCount() {
        return this.ingredientsWithCount;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ItemRegistry.DIGESTION_VAT.get());
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializerRegistry.DIGESTION.get();
    }

    public FluidIngredient getFluid() {
        return this.fluid;
    }

    public int getFluidAmount() {
        return this.fluidAmount;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public int getTime() {
        return this.time;
    }

    public static class Serializer
    implements RecipeSerializer<DigestionRecipe> {
        public DigestionRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            DigestionRecipe recipe = (DigestionRecipe)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)pJson).getOrThrow(false, s -> {
                throw new JsonParseException(s);
            });
            recipe.id = pRecipeId;
            return recipe;
        }

        public DigestionRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            DigestionRecipe recipe = (DigestionRecipe)pBuffer.m_271872_(CODEC);
            recipe.id = pRecipeId;
            return recipe;
        }

        public void toNetwork(FriendlyByteBuf pBuffer, DigestionRecipe pRecipe) {
            pBuffer.m_272073_(CODEC, (Object)pRecipe);
        }
    }
}

