/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.klikli_dev.theurgy.content.item.AlchemicalSulfurTier;
import com.klikli_dev.theurgy.content.item.AlchemicalSulfurType;
import com.klikli_dev.theurgy.content.item.render.AlchemicalSulfurBEWLR;
import com.klikli_dev.theurgy.content.recipe.LiquefactionRecipe;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.registry.SulfurRegistry;
import com.klikli_dev.theurgy.util.LevelUtil;
import com.klikli_dev.theurgy.util.TagUtil;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;

public class AlchemicalSulfurItem
extends Item {
    public boolean useAutomaticIconRendering = true;
    public boolean useAutomaticNameRendering = true;
    public boolean useAutomaticNameLangGeneration = true;
    public boolean provideAutomaticTooltipData = true;
    public boolean useAutomaticTooltipLangGeneration = true;
    public boolean overrideTagSourceName = false;
    public boolean overrideSourceName = false;
    public boolean autoGenerateSourceIdInRecipe = true;
    public Supplier<ItemStack> sourceStackSupplier;
    public Supplier<ItemStack> emptyJarStackSupplier;
    public AlchemicalSulfurTier tier;
    public AlchemicalSulfurType type;

    public AlchemicalSulfurItem(Item.Properties pProperties) {
        this(pProperties, (Supplier<ItemStack>)Suppliers.memoize(() -> ItemStack.f_41583_));
    }

    public AlchemicalSulfurItem(Item.Properties pProperties, Supplier<ItemStack> sourceStackSupplier) {
        super(pProperties);
        this.sourceStackSupplier = sourceStackSupplier;
        this.emptyJarStackSupplier = Suppliers.memoize(() -> new ItemStack((ItemLike)ItemRegistry.EMPTY_JAR_ICON.get()));
        this.tier = AlchemicalSulfurTier.ABUNDANT;
        this.type = AlchemicalSulfurType.MISC;
    }

    public static String getSourceItemId(ItemStack sulfurStack) {
        if (!sulfurStack.m_41782_()) {
            List<LiquefactionRecipe> liquefactionRecipes;
            AlchemicalSulfurItem sulfur;
            Optional<ItemStack> preferred;
            Item item;
            RegistryAccess registryAccess;
            Level level = LevelUtil.getLevelWithoutContext();
            RecipeManager recipeManager = level == null ? null : level.m_7465_();
            RegistryAccess registryAccess2 = registryAccess = level == null ? null : level.m_9598_();
            if (recipeManager != null && (item = sulfurStack.m_41720_()) instanceof AlchemicalSulfurItem && (preferred = SulfurRegistry.getPreferredSulfurVariant(sulfur = (AlchemicalSulfurItem)item, liquefactionRecipes = recipeManager.m_44013_((RecipeType)RecipeTypeRegistry.LIQUEFACTION.get()).stream().filter(r -> r.m_8043_(registryAccess) != null).toList(), level)).isPresent() && preferred.get().m_41782_()) {
                sulfurStack.m_41751_(preferred.get().m_41783_());
            }
        }
        if (sulfurStack.m_41782_() && sulfurStack.m_41783_().m_128441_("theurgy:sulfur.source.id")) {
            return sulfurStack.m_41783_().m_128461_("theurgy:sulfur.source.id");
        }
        return "";
    }

    public static ItemStack getEmptyJarStack(ItemStack sulfurStack) {
        Item item = sulfurStack.m_41720_();
        if (item instanceof AlchemicalSulfurItem) {
            AlchemicalSulfurItem sulfur = (AlchemicalSulfurItem)item;
            return sulfur.emptyJarStackSupplier.get();
        }
        return ItemStack.f_41583_;
    }

    public static AlchemicalSulfurTier getTier(ItemStack sulfurStack) {
        Item item = sulfurStack.m_41720_();
        if (item instanceof AlchemicalSulfurItem) {
            AlchemicalSulfurItem sulfur = (AlchemicalSulfurItem)item;
            return sulfur.tier;
        }
        return AlchemicalSulfurTier.ABUNDANT;
    }

    public static AlchemicalSulfurType getType(ItemStack sulfurStack) {
        Item item = sulfurStack.m_41720_();
        if (item instanceof AlchemicalSulfurItem) {
            AlchemicalSulfurItem sulfur = (AlchemicalSulfurItem)item;
            return sulfur.type;
        }
        return AlchemicalSulfurType.MISC;
    }

    public static ItemStack getSourceStack(ItemStack sulfurStack) {
        AlchemicalSulfurItem sulfur;
        ItemStack sourceStack;
        Item item = sulfurStack.m_41720_();
        if (item instanceof AlchemicalSulfurItem && !(sourceStack = (sulfur = (AlchemicalSulfurItem)item).getSourceStack()).m_41619_()) {
            return sourceStack;
        }
        String itemSourceId = AlchemicalSulfurItem.getSourceItemId(sulfurStack);
        if (sulfurStack.m_41782_() && sulfurStack.m_41783_().m_128441_("theurgy:sulfur.source.id")) {
            if (itemSourceId.startsWith("#")) {
                ResourceLocation tagId = new ResourceLocation(itemSourceId.substring(1));
                TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagId);
                sourceStack = TagUtil.getItemStackForTag((TagKey<Item>)tag);
            } else {
                ResourceLocation itemId = new ResourceLocation(itemSourceId);
                sourceStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(itemId));
            }
            if (sulfurStack.m_41783_().m_128441_("theurgy:sulfur.source.nbt")) {
                sourceStack.m_41751_(sulfurStack.m_41783_().m_128469_("theurgy:sulfur.source.nbt"));
            }
            return sourceStack;
        }
        return ItemStack.f_41583_;
    }

    public static List<MutableComponent> getTooltipData(ItemStack sulfurStack) {
        Item item = sulfurStack.m_41720_();
        if (item instanceof AlchemicalSulfurItem) {
            AlchemicalSulfurItem sulfur = (AlchemicalSulfurItem)item;
            if (sulfur.provideAutomaticTooltipData) {
                AlchemicalSulfurTier tier = AlchemicalSulfurItem.getTier(sulfurStack);
                AlchemicalSulfurType type = AlchemicalSulfurItem.getType(sulfurStack);
                return ImmutableList.of((Object)sulfur.getSourceName(sulfurStack), (Object)ComponentUtils.m_130748_((Component)Component.m_237115_((String)tier.descriptionId()).m_130948_(Style.f_131099_.m_178520_(tier.color).m_131155_(Boolean.valueOf(true)))), (Object)ComponentUtils.m_130748_((Component)Component.m_237115_((String)type.descriptionId()).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY).m_131155_(Boolean.valueOf(true)))));
            }
        }
        return ImmutableList.of();
    }

    public static MutableComponent formatSourceName(MutableComponent sourceName, AlchemicalSulfurTier tier) {
        return sourceName.m_130948_(Style.f_131099_.m_178520_(tier.color()).m_131155_(Boolean.valueOf(true)));
    }

    public AlchemicalSulfurItem tier(AlchemicalSulfurTier tier) {
        this.tier = tier;
        return this;
    }

    public AlchemicalSulfurTier tier() {
        return this.tier;
    }

    public AlchemicalSulfurItem type(AlchemicalSulfurType type) {
        this.type = type;
        return this;
    }

    public AlchemicalSulfurType type() {
        return this.type;
    }

    public ItemStack getSourceStack() {
        return this.sourceStackSupplier.get();
    }

    public AlchemicalSulfurItem noAuto() {
        this.useAutomaticIconRendering = false;
        this.useAutomaticNameRendering = false;
        this.useAutomaticNameLangGeneration = false;
        this.provideAutomaticTooltipData = false;
        this.useAutomaticTooltipLangGeneration = false;
        this.overrideTagSourceName = false;
        return this;
    }

    public AlchemicalSulfurItem autoIcon(boolean value) {
        this.useAutomaticIconRendering = value;
        return this;
    }

    public AlchemicalSulfurItem withJarIcon(Supplier<ItemStack> emptyJarStackSupplier) {
        this.emptyJarStackSupplier = emptyJarStackSupplier;
        return this;
    }

    public AlchemicalSulfurItem autoName(boolean value) {
        return this.autoName(value, value);
    }

    public AlchemicalSulfurItem autoName(boolean rendering, boolean langGeneration) {
        this.useAutomaticNameRendering = rendering;
        this.useAutomaticNameLangGeneration = langGeneration;
        return this;
    }

    public AlchemicalSulfurItem autoTooltip(boolean value) {
        return this.autoTooltip(value, value);
    }

    public AlchemicalSulfurItem autoTooltip(boolean rendering, boolean langGeneration) {
        this.provideAutomaticTooltipData = rendering;
        this.useAutomaticTooltipLangGeneration = langGeneration;
        return this;
    }

    public AlchemicalSulfurItem overrideTagSourceName(boolean value) {
        this.overrideTagSourceName = value;
        return this;
    }

    public AlchemicalSulfurItem overrideSourceName(boolean value) {
        this.overrideSourceName = value;
        this.autoGenerateSourceIdInRecipe = !value;
        return this;
    }

    public AlchemicalSulfurItem autoGenerateSourceIdInRecipe(boolean value) {
        this.autoGenerateSourceIdInRecipe = value;
        return this;
    }

    public MutableComponent getSourceName(ItemStack pStack) {
        if (this.overrideSourceName) {
            return AlchemicalSulfurItem.formatSourceName(Component.m_237115_((String)(pStack.m_41778_() + ".source")), this.tier);
        }
        ItemStack source = AlchemicalSulfurItem.getSourceStack(pStack);
        if (!source.m_41619_()) {
            String sourceId = AlchemicalSulfurItem.getSourceItemId(pStack);
            if (sourceId.startsWith("#") && this.overrideTagSourceName) {
                ResourceLocation tagId = new ResourceLocation(sourceId.substring(1));
                return AlchemicalSulfurItem.formatSourceName(Component.m_237115_((String)Util.m_137492_((String)"tag", (ResourceLocation)tagId)), this.tier);
            }
            Component component = source.m_41786_();
            if (component instanceof MutableComponent) {
                MutableComponent hoverName = (MutableComponent)component;
                return AlchemicalSulfurItem.formatSourceName(hoverName, this.tier);
            }
        }
        return Component.m_237115_((String)"item.theurgy.alchemical_sulfur.unknown_source");
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return AlchemicalSulfurBEWLR.get();
            }
        });
    }

    public Component m_7626_(ItemStack pStack) {
        if (this.useAutomaticNameRendering) {
            AlchemicalSulfurTier tier = AlchemicalSulfurItem.getTier(pStack);
            AlchemicalSulfurType type = AlchemicalSulfurItem.getType(pStack);
            return Component.m_237110_((String)this.m_5671_(pStack), (Object[])new Object[]{ComponentUtils.m_130748_((Component)this.getSourceName(pStack)), ComponentUtils.m_130748_((Component)Component.m_237115_((String)tier.descriptionId()).m_130948_(Style.f_131099_.m_178520_(tier.color).m_131155_(Boolean.valueOf(true)))), ComponentUtils.m_130748_((Component)Component.m_237115_((String)type.descriptionId()).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY).m_131155_(Boolean.valueOf(true))))});
        }
        return super.m_7626_(pStack);
    }
}

