/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.reformationarray;

import com.klikli_dev.theurgy.content.apparatus.reformationarray.ReformationArrayCraftingBehaviour;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.ReformationResultPedestalBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.ReformationSourcePedestalBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.ReformationTargetPedestalBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.SulfuricFluxEmitterBlock;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.SulfuricFluxEmitterSelectedPoint;
import com.klikli_dev.theurgy.content.behaviour.CraftingBehaviour;
import com.klikli_dev.theurgy.content.behaviour.selection.SelectionBehaviour;
import com.klikli_dev.theurgy.content.capability.DefaultMercuryFluxStorage;
import com.klikli_dev.theurgy.content.entity.FollowProjectile;
import com.klikli_dev.theurgy.content.recipe.wrapper.ReformationArrayRecipeWrapper;
import com.klikli_dev.theurgy.content.render.Color;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import com.klikli_dev.theurgy.registry.CapabilityRegistry;
import com.klikli_dev.theurgy.util.EntityUtil;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SulfuricFluxEmitterBlockEntity
extends BlockEntity {
    public static final int CAPACITY = 1000;
    public MercuryFluxStorage mercuryFluxStorage = new MercuryFluxStorage(1000);
    public LazyOptional<MercuryFluxStorage> mercuryFluxStorageCapability = LazyOptional.of(() -> this.mercuryFluxStorage);
    public boolean isValidMultiblock;
    protected List<SulfuricFluxEmitterSelectedPoint> sourcePedestals = new ArrayList<SulfuricFluxEmitterSelectedPoint>();
    protected List<SulfuricFluxEmitterSelectedPoint> sourcePedestalsWithContents = new ArrayList<SulfuricFluxEmitterSelectedPoint>();
    protected SulfuricFluxEmitterSelectedPoint targetPedestal;
    protected SulfuricFluxEmitterSelectedPoint resultPedestal;
    protected CraftingBehaviour<?, ?, ?> craftingBehaviour = new ReformationArrayCraftingBehaviour((BlockEntity)this, () -> this.recipeWrapper, () -> null, this::getOutputInventory, () -> this.mercuryFluxStorage);
    protected boolean checkValidMultiblockOnNextQuery = true;
    protected boolean hasSourceItems;
    protected boolean hasTargetItem;
    private ReformationArrayRecipeWrapper recipeWrapper;

    public SulfuricFluxEmitterBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityRegistry.SULFURIC_FLUX_EMITTER.get(), pPos, pBlockState);
    }

    public void removeResultPedestal(ReformationResultPedestalBlockEntity pedestal) {
        this.isValidMultiblock = false;
        this.onDisassembleMultiblock();
    }

    public void removeTargetPedestal(ReformationTargetPedestalBlockEntity pedestal) {
        this.isValidMultiblock = false;
        this.hasTargetItem = false;
        this.onDisassembleMultiblock();
    }

    public void removeSourcePedestal(ReformationSourcePedestalBlockEntity pedestal) {
        boolean hasRemainingPedestals = this.sourcePedestals.stream().filter(p -> !p.getBlockPos().equals((Object)pedestal.m_58899_())).map(p -> this.f_58857_.m_7702_(p.getBlockPos())).anyMatch(e -> e instanceof ReformationSourcePedestalBlockEntity);
        if (!hasRemainingPedestals) {
            this.isValidMultiblock = false;
            this.hasSourceItems = false;
            this.onDisassembleMultiblock();
        } else {
            this.onSourcePedestalContentChange(null);
        }
    }

    public boolean isValidMultiblock() {
        if (this.checkValidMultiblockOnNextQuery) {
            this.checkValidMultiblockOnNextQuery = false;
            this.validateMultiblock();
        }
        return this.isValidMultiblock;
    }

    public void validateMultiblock() {
        boolean wasValidMultiblock = this.isValidMultiblock;
        this.isValidMultiblock = true;
        if (this.targetPedestal != null) {
            BlockEntity targetPedestalBlockEntity = this.f_58857_.m_7702_(this.targetPedestal.getBlockPos());
            if (!(targetPedestalBlockEntity instanceof ReformationTargetPedestalBlockEntity)) {
                this.isValidMultiblock = false;
            }
        } else {
            this.isValidMultiblock = false;
        }
        if (this.resultPedestal != null) {
            BlockEntity resultPedestalBlockEntity = this.f_58857_.m_7702_(this.resultPedestal.getBlockPos());
            if (!(resultPedestalBlockEntity instanceof ReformationResultPedestalBlockEntity)) {
                this.isValidMultiblock = false;
            }
        } else {
            this.isValidMultiblock = false;
        }
        boolean hasSourcePedestals = false;
        for (SulfuricFluxEmitterSelectedPoint sourcePedestal : this.sourcePedestals) {
            BlockEntity sourcePedestalBlockEntity = this.f_58857_.m_7702_(sourcePedestal.getBlockPos());
            if (!(sourcePedestalBlockEntity instanceof ReformationSourcePedestalBlockEntity)) continue;
            hasSourcePedestals = true;
        }
        this.sourcePedestalsWithContents.clear();
        if (!hasSourcePedestals) {
            this.isValidMultiblock = false;
        } else {
            this.onSourcePedestalContentChange(null);
        }
        if (wasValidMultiblock != this.isValidMultiblock) {
            if (this.isValidMultiblock) {
                this.onAssembleMultiblock();
            } else {
                this.onDisassembleMultiblock();
            }
        }
    }

    public void onAssembleMultiblock() {
        ReformationTargetPedestalBlockEntity targetPedestalBlockEntity = (ReformationTargetPedestalBlockEntity)this.f_58857_.m_7702_(this.targetPedestal.getBlockPos());
        targetPedestalBlockEntity.setSulfuricFluxEmitter(this);
        this.onTargetPedestalContentChange(targetPedestalBlockEntity);
        ReformationResultPedestalBlockEntity resultPedestalBlockEntity = (ReformationResultPedestalBlockEntity)this.f_58857_.m_7702_(this.resultPedestal.getBlockPos());
        resultPedestalBlockEntity.setSulfuricFluxEmitter(this);
        List<IItemHandlerModifiable> sourceInventories = this.sourcePedestals.stream().map(p -> this.f_58857_.m_7702_(p.getBlockPos())).filter(e -> e instanceof ReformationSourcePedestalBlockEntity).map(e -> (ReformationSourcePedestalBlockEntity)((Object)e)).peek(e -> e.setSulfuricFluxEmitter(this)).map(e -> e.inputInventory).map(e -> e).toList();
        this.onSourcePedestalContentChange(null);
        this.recipeWrapper = new ReformationArrayRecipeWrapper(sourceInventories, (IItemHandlerModifiable)targetPedestalBlockEntity.inputInventory, this.mercuryFluxStorage);
    }

    public void onDisassembleMultiblock() {
        this.recipeWrapper = null;
    }

    public IItemHandlerModifiable getOutputInventory() {
        BlockPos pos = this.resultPedestal.getBlockPos();
        BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
        if (blockEntity instanceof ReformationResultPedestalBlockEntity) {
            ReformationResultPedestalBlockEntity pedestal = (ReformationResultPedestalBlockEntity)blockEntity;
            return pedestal.outputInventory;
        }
        return null;
    }

    public void tickServer() {
        boolean hasInput = this.isValidMultiblock() && this.hasSourceItems && this.hasTargetItem;
        this.craftingBehaviour.tickServer(true, hasInput);
    }

    public void tickClient() {
        if (this.craftingBehaviour.isProcessing() && this.f_58857_.m_46467_() % 40L == 0L) {
            DistHelper.sendTargetProjectile(this);
        }
    }

    public void onLoad() {
        if (this.targetPedestal != null) {
            this.targetPedestal.setLevel(this.f_58857_);
        }
        if (this.resultPedestal != null) {
            this.resultPedestal.setLevel(this.f_58857_);
        }
        this.sourcePedestals.forEach(point -> point.setLevel(this.m_58904_()));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityRegistry.MERCURY_FLUX) {
            return this.mercuryFluxStorageCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.mercuryFluxStorageCapability.invalidate();
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("mercuryFluxStorage", this.mercuryFluxStorage.serializeNBT());
        pTag.m_128365_("sourcePedestals", (Tag)Util.m_260975_((DataResult)SulfuricFluxEmitterSelectedPoint.LIST_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, this.sourcePedestals), e -> new EncoderException("Failed to encode: " + e + " " + String.valueOf(this.sourcePedestals))));
        if (this.targetPedestal != null) {
            pTag.m_128365_("targetPedestal", (Tag)Util.m_260975_((DataResult)SulfuricFluxEmitterSelectedPoint.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.targetPedestal), e -> new EncoderException("Failed to encode: " + e + " " + String.valueOf(this.targetPedestal))));
        }
        if (this.resultPedestal != null) {
            pTag.m_128365_("resultPedestal", (Tag)Util.m_260975_((DataResult)SulfuricFluxEmitterSelectedPoint.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.resultPedestal), e -> new EncoderException("Failed to encode: " + e + " " + String.valueOf(this.resultPedestal))));
        }
        this.craftingBehaviour.saveAdditional(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("mercuryFluxStorage")) {
            this.mercuryFluxStorage.deserializeNBT(pTag.m_128423_("mercuryFluxStorage"));
        }
        if (pTag.m_128441_("sourcePedestals")) {
            this.sourcePedestals.clear();
            this.sourcePedestals.addAll((Collection)Util.m_260975_((DataResult)SulfuricFluxEmitterSelectedPoint.LIST_CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)pTag.m_128423_("sourcePedestals")), e -> new EncoderException("Failed to decode: " + e + " " + String.valueOf(pTag.m_128423_("sourcePedestals")))));
        }
        if (pTag.m_128441_("targetPedestal")) {
            this.targetPedestal = (SulfuricFluxEmitterSelectedPoint)Util.m_260975_((DataResult)SulfuricFluxEmitterSelectedPoint.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)pTag.m_128423_("targetPedestal")), e -> new EncoderException("Failed to decode: " + e + " " + String.valueOf(pTag.m_128423_("targetPedestal"))));
        }
        if (pTag.m_128441_("resultPedestal")) {
            this.resultPedestal = (SulfuricFluxEmitterSelectedPoint)Util.m_260975_((DataResult)SulfuricFluxEmitterSelectedPoint.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)pTag.m_128423_("resultPedestal")), e -> new EncoderException("Failed to decode: " + e + " " + String.valueOf(pTag.m_128423_("resultPedestal"))));
        }
        this.craftingBehaviour.load(pTag);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.writeNetwork(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.readNetwork(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet) {
        CompoundTag tag = packet.m_131708_();
        if (tag != null) {
            this.readNetwork(tag);
        }
    }

    public void readNetwork(CompoundTag pTag) {
        if (pTag.m_128441_("sourcePedestalsWithContents")) {
            this.sourcePedestalsWithContents.clear();
            this.sourcePedestalsWithContents.addAll((Collection)Util.m_260975_((DataResult)SulfuricFluxEmitterSelectedPoint.LIST_CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)pTag.m_128423_("sourcePedestalsWithContents")), e -> new EncoderException("Failed to decode: " + e + " " + String.valueOf(pTag.m_128423_("sourcePedestalsWithContents")))));
        }
        if (pTag.m_128441_("targetPedestal")) {
            this.targetPedestal = (SulfuricFluxEmitterSelectedPoint)Util.m_260975_((DataResult)SulfuricFluxEmitterSelectedPoint.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)pTag.m_128423_("targetPedestal")), e -> new EncoderException("Failed to decode: " + e + " " + String.valueOf(pTag.m_128423_("targetPedestal"))));
        }
        if (pTag.m_128441_("resultPedestal")) {
            this.resultPedestal = (SulfuricFluxEmitterSelectedPoint)Util.m_260975_((DataResult)SulfuricFluxEmitterSelectedPoint.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)pTag.m_128423_("resultPedestal")), e -> new EncoderException("Failed to decode: " + e + " " + String.valueOf(pTag.m_128423_("resultPedestal"))));
        }
        this.craftingBehaviour.readNetwork(pTag);
    }

    public void writeNetwork(CompoundTag pTag) {
        pTag.m_128365_("sourcePedestalsWithContents", (Tag)Util.m_260975_((DataResult)SulfuricFluxEmitterSelectedPoint.LIST_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, this.sourcePedestalsWithContents), e -> new EncoderException("Failed to encode: " + e + " " + String.valueOf(this.sourcePedestalsWithContents))));
        if (this.targetPedestal != null) {
            pTag.m_128365_("targetPedestal", (Tag)Util.m_260975_((DataResult)SulfuricFluxEmitterSelectedPoint.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.targetPedestal), e -> new EncoderException("Failed to encode: " + e + " " + String.valueOf(this.targetPedestal))));
        }
        if (this.resultPedestal != null) {
            pTag.m_128365_("resultPedestal", (Tag)Util.m_260975_((DataResult)SulfuricFluxEmitterSelectedPoint.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.resultPedestal), e -> new EncoderException("Failed to encode: " + e + " " + String.valueOf(this.resultPedestal))));
        }
        this.craftingBehaviour.writeNetwork(pTag);
    }

    public SelectionBehaviour<SulfuricFluxEmitterSelectedPoint> getSelectionBehaviour() {
        return ((SulfuricFluxEmitterBlock)((Object)BlockRegistry.SULFURIC_FLUX_EMITTER.get())).selectionBehaviour();
    }

    public void setSelectedPoints(List<SulfuricFluxEmitterSelectedPoint> sourcePedestals, SulfuricFluxEmitterSelectedPoint targetPedestal, SulfuricFluxEmitterSelectedPoint resultPedestal) {
        int range = this.getSelectionBehaviour().getBlockRange();
        this.sourcePedestals.clear();
        this.sourcePedestals.addAll(sourcePedestals);
        this.sourcePedestals.removeIf(p -> !p.getBlockPos().m_123314_((Vec3i)this.m_58899_(), (double)range));
        SulfuricFluxEmitterSelectedPoint sulfuricFluxEmitterSelectedPoint = targetPedestal == null ? null : (this.targetPedestal = targetPedestal.getBlockPos().m_123314_((Vec3i)this.m_58899_(), (double)range) ? targetPedestal : null);
        this.resultPedestal = resultPedestal == null ? null : (resultPedestal.getBlockPos().m_123314_((Vec3i)this.m_58899_(), (double)range) ? resultPedestal : null);
        this.checkValidMultiblockOnNextQuery = true;
        this.m_6596_();
    }

    public void setSelectedPointsClient(List<SulfuricFluxEmitterSelectedPoint> sourcePedestals, SulfuricFluxEmitterSelectedPoint targetPedestal, SulfuricFluxEmitterSelectedPoint resultPedestal) {
        this.sourcePedestals.clear();
        this.sourcePedestals.addAll(sourcePedestals);
        this.targetPedestal = targetPedestal;
        this.resultPedestal = resultPedestal;
    }

    public void onTargetPedestalContentChange(ReformationTargetPedestalBlockEntity pedestal) {
        this.hasTargetItem = !pedestal.inputInventory.getStackInSlot(0).m_41619_();
    }

    public void onSourcePedestalContentChange(ReformationSourcePedestalBlockEntity pedestal) {
        this.sourcePedestalsWithContents.clear();
        this.hasSourceItems = this.sourcePedestals.stream().map(p -> new Pair(p, (Object)this.f_58857_.m_7702_(p.getBlockPos()))).filter(p -> p.getSecond() instanceof ReformationSourcePedestalBlockEntity).map(p -> new Pair((Object)((SulfuricFluxEmitterSelectedPoint)p.getFirst()), (Object)((ReformationSourcePedestalBlockEntity)((Object)((Object)p.getSecond()))))).filter(p -> !((ReformationSourcePedestalBlockEntity)((Object)((Object)p.getSecond()))).inputInventory.getStackInSlot(0).m_41619_()).peek(p -> this.sourcePedestalsWithContents.add((SulfuricFluxEmitterSelectedPoint)p.getFirst())).count() > 0L;
        this.m_6596_();
    }

    public class MercuryFluxStorage
    extends DefaultMercuryFluxStorage {
        public MercuryFluxStorage(int capacity) {
            super(capacity);
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            int received = super.receiveEnergy(maxReceive, simulate);
            if (received > 0) {
                SulfuricFluxEmitterBlockEntity.this.m_6596_();
            }
            return received;
        }

        @Override
        public int extractEnergy(int maxExtract, boolean simulate) {
            int extracted = super.extractEnergy(maxExtract, simulate);
            if (extracted > 0) {
                SulfuricFluxEmitterBlockEntity.this.m_6596_();
            }
            return extracted;
        }
    }

    public static class DistHelper {
        static void sendTargetProjectile(SulfuricFluxEmitterBlockEntity emitter) {
            Vec3 normal = Vec3.m_82528_((Vec3i)((Direction)emitter.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122436_());
            Vec3 from = Vec3.m_82512_((Vec3i)emitter.m_58899_()).m_82546_(normal.m_82490_(0.5));
            Vec3 to = Vec3.m_82512_((Vec3i)emitter.targetPedestal.getBlockPos()).m_82520_(0.0, 0.5, 0.0);
            if (emitter.f_58857_.m_46749_(BlockPos.m_274446_((Position)to)) && emitter.f_58857_.m_46749_(BlockPos.m_274446_((Position)from)) && ((SulfuricFluxEmitterBlockEntity)emitter).f_58857_.f_46443_) {
                FollowProjectile projectile = new FollowProjectile(emitter.f_58857_, from, to, new Color(0xFFFFFF, false), new Color(255, false), 0.1f, 0.3f, targetProjectile -> DistHelper.sendSourceProjectiles(targetProjectile, emitter));
                projectile.m_20256_(normal.m_82490_((double)0.3f));
                EntityUtil.spawnEntityClientSide(emitter.f_58857_, (Entity)projectile);
            }
        }

        static void sendSourceProjectiles(FollowProjectile targetProjectile, SulfuricFluxEmitterBlockEntity emitter) {
            for (SulfuricFluxEmitterSelectedPoint sourcePedestal : emitter.sourcePedestalsWithContents) {
                Vec3 from = targetProjectile.m_20182_();
                Vec3 to = Vec3.m_82512_((Vec3i)sourcePedestal.getBlockPos()).m_82520_(0.0, 0.7, 0.0);
                Vec3 normal = targetProjectile.to().m_82546_(targetProjectile.from()).m_82541_();
                if (!emitter.f_58857_.m_46749_(BlockPos.m_274446_((Position)to)) || !emitter.f_58857_.m_46749_(BlockPos.m_274446_((Position)from))) continue;
                FollowProjectile projectile = new FollowProjectile(emitter.f_58857_, from, to, new Color(255, false), new Color(0xFF00FF, false), 0.1f, 0.3f, sourceProjectile -> DistHelper.sendResultProjectile(sourceProjectile, emitter));
                projectile.m_20256_(normal.m_82490_((double)0.3f));
                EntityUtil.spawnEntityClientSide(emitter.f_58857_, (Entity)projectile);
            }
        }

        static void sendResultProjectile(FollowProjectile sourceProjectile, SulfuricFluxEmitterBlockEntity emitter) {
            Vec3 from = sourceProjectile.m_20182_();
            Vec3 to = Vec3.m_82512_((Vec3i)emitter.resultPedestal.getBlockPos()).m_82520_(0.0, 0.7, 0.0);
            Vec3 normal = sourceProjectile.to().m_82546_(sourceProjectile.from()).m_82541_();
            if (emitter.f_58857_.m_46749_(BlockPos.m_274446_((Position)to)) && emitter.f_58857_.m_46749_(BlockPos.m_274446_((Position)from))) {
                FollowProjectile projectile = new FollowProjectile(emitter.f_58857_, from, to, new Color(0xAA08AA, false), new Color(65280, false), 0.1f, 1.0f);
                projectile.m_20256_(normal.m_82490_((double)0.3f));
                EntityUtil.spawnEntityClientSide(emitter.f_58857_, (Entity)projectile);
            }
        }
    }
}

