/*
 * Decompiled with CFR 0.152.
 */
package tgbridge.shaded.snakeyaml.engine.kmp.internal.utils;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tgbridge.shaded.snakeyaml.engine.kmp.internal.utils.Character;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0002\u0010\r\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\u001a'\u0010\u0004\u001a\u00020\u0001*\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a'\u0010\u0004\u001a\u00020\u0001*\u00020\u00062\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0007\u001a\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\b*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\t\u0010\n\u001a\u001b\u0010\f\u001a\u00020\u0001*\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"", "", "beginIndex", "endIndex", "codePointCount", "(Ljava/lang/CharSequence;II)I", "", "([CII)I", "", "toCodePoints", "(Ljava/lang/CharSequence;)Ljava/util/List;", "index", "codePointAt", "(Ljava/lang/CharSequence;I)I", "snakeyaml-engine-kmp"})
public final class CharSequenceExtensionsKt {
    public static final int codePointCount(@NotNull CharSequence $this$codePointCount, int beginIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$codePointCount, (String)"<this>");
        char[] cArray = ((Object)$this$codePointCount).toString().toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        return CharSequenceExtensionsKt.codePointCount(cArray, beginIndex, endIndex);
    }

    public static /* synthetic */ int codePointCount$default(CharSequence charSequence, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = charSequence.length();
        }
        return CharSequenceExtensionsKt.codePointCount(charSequence, n, n2);
    }

    public static final int codePointCount(@NotNull char[] $this$codePointCount, int beginIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$codePointCount, (String)"<this>");
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("beginIndex must not be less than 0, but was " + beginIndex);
        }
        if (endIndex > $this$codePointCount.length) {
            throw new IndexOutOfBoundsException("endIndex must not be greater than size (" + $this$codePointCount.length + "), but was " + endIndex);
        }
        if (beginIndex > endIndex) {
            throw new IndexOutOfBoundsException("beginIndex must not be greater than endIndex (" + endIndex + "), but was " + beginIndex);
        }
        int index = beginIndex;
        int count = 0;
        while (index < endIndex) {
            char nextChar;
            char firstChar = $this$codePointCount[index];
            if (java.lang.Character.isHighSurrogate(firstChar) && ++index < endIndex && java.lang.Character.isLowSurrogate(nextChar = $this$codePointCount[index])) {
                ++index;
            }
            ++count;
        }
        return count;
    }

    public static /* synthetic */ int codePointCount$default(char[] cArray, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = cArray.length;
        }
        return CharSequenceExtensionsKt.codePointCount(cArray, n, n2);
    }

    @NotNull
    public static final List<Integer> toCodePoints(@NotNull CharSequence $this$toCodePoints) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$toCodePoints, (String)"<this>");
        List $this$toCodePoints_u24lambda_u240 = list = CollectionsKt.createListBuilder((int)$this$toCodePoints.length());
        boolean bl = false;
        int i = 0;
        int c = 0;
        while (i < $this$toCodePoints.length()) {
            int cp = CharSequenceExtensionsKt.codePointAt($this$toCodePoints, i);
            $this$toCodePoints_u24lambda_u240.add(cp);
            i += Character.INSTANCE.charCount$snakeyaml_engine_kmp(cp);
            ++c;
        }
        return CollectionsKt.build((List)list);
    }

    public static final int codePointAt(@NotNull CharSequence $this$codePointAt, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$codePointAt, (String)"<this>");
        if (!(0 <= index ? index < $this$codePointAt.length() : false)) {
            throw new IndexOutOfBoundsException("index " + index + " was not in range " + StringsKt.getIndices((CharSequence)$this$codePointAt));
        }
        char firstChar = $this$codePointAt.charAt(index);
        if (java.lang.Character.isHighSurrogate(firstChar)) {
            java.lang.Character nextChar;
            java.lang.Character c = nextChar = StringsKt.getOrNull((CharSequence)$this$codePointAt, (int)(index + 1));
            boolean bl = c != null ? java.lang.Character.isLowSurrogate(c.charValue()) : false;
            if (bl) {
                return Character.INSTANCE.toCodePoint$snakeyaml_engine_kmp(firstChar, nextChar.charValue());
            }
        }
        return firstChar;
    }
}

