/*
 * Decompiled with CFR 0.152.
 */
package tgbridge.shaded.snakeyaml.engine.kmp.common;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tgbridge.shaded.snakeyaml.engine.kmp.exceptions.EmitterException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\n\u001a\u00020\t2\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000f\u001a\u0004\b\u0010\u0010\u0007\u00a8\u0006\u0012"}, d2={"Ltgbridge/shaded/snakeyaml/engine/kmp/common/Anchor;", "", "", "value", "<init>", "(Ljava/lang/String;)V", "toString", "()Ljava/lang/String;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Ljava/lang/String;", "getValue", "Companion", "snakeyaml-engine-kmp"})
@SourceDebugExtension(value={"SMAP\nAnchor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Anchor.kt\nit/krzeminski/snakeyaml/engine/kmp/common/Anchor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class Anchor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String value;
    @NotNull
    private static final Set<Character> INVALID_ANCHOR;
    @NotNull
    private static final Regex SPACES_PATTERN;

    public Anchor(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
        if (!(((CharSequence)this.value).length() > 0)) {
            boolean bl = false;
            String string = "Empty anchor.";
            throw new IllegalArgumentException(string.toString());
        }
        String string = this.value;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char element = string.charAt(i);
            if (!INVALID_ANCHOR.contains(Character.valueOf(element))) continue;
            throw new EmitterException("Invalid character '" + element + "' in the anchor: " + this.value);
        }
        if (SPACES_PATTERN.containsMatchIn((CharSequence)this.value)) {
            throw new EmitterException("Anchor may not contain spaces: " + this.value);
        }
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @NotNull
    public String toString() {
        return this.value;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Anchor)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.value, (Object)((Anchor)other).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf(','), Character.valueOf('*'), Character.valueOf('&')};
        INVALID_ANCHOR = SetsKt.setOf((Object[])objectArray);
        SPACES_PATTERN = new Regex("\\s");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Ltgbridge/shaded/snakeyaml/engine/kmp/common/Anchor$Companion;", "", "<init>", "()V", "", "", "INVALID_ANCHOR", "Ljava/util/Set;", "Lkotlin/text/Regex;", "SPACES_PATTERN", "Lkotlin/text/Regex;", "snakeyaml-engine-kmp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

