/*
 * Decompiled with CFR 0.152.
 */
package tgbridge.shaded.retrofit2;

import android.annotation.TargetApi;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import javax.annotation.Nullable;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import tgbridge.shaded.okhttp3.ResponseBody;
import tgbridge.shaded.retrofit2.Converter;
import tgbridge.shaded.retrofit2.Retrofit;

@IgnoreJRERequirement
@TargetApi(value=24)
public final class OptionalConverterFactory
extends Converter.Factory {
    public static OptionalConverterFactory create() {
        return new OptionalConverterFactory();
    }

    OptionalConverterFactory() {
    }

    @Override
    @Nullable
    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        if (OptionalConverterFactory.getRawType(type) != Optional.class) {
            return null;
        }
        Type innerType = OptionalConverterFactory.getParameterUpperBound(0, (ParameterizedType)type);
        Converter delegate = retrofit.responseBodyConverter(innerType, annotations);
        return new OptionalConverter(delegate);
    }

    @IgnoreJRERequirement
    static final class OptionalConverter<T>
    implements Converter<ResponseBody, Optional<T>> {
        private final Converter<ResponseBody, T> delegate;

        OptionalConverter(Converter<ResponseBody, T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Optional<T> convert(ResponseBody value) throws IOException {
            return Optional.ofNullable(this.delegate.convert(value));
        }
    }
}

