/*
 * Decompiled with CFR 0.152.
 */
package tgbridge.shaded.okio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tgbridge.shaded.okio.CipherSink;
import tgbridge.shaded.okio.CipherSource;
import tgbridge.shaded.okio.FileSystem;
import tgbridge.shaded.okio.HashingSink;
import tgbridge.shaded.okio.HashingSource;
import tgbridge.shaded.okio.InputStreamSource;
import tgbridge.shaded.okio.Okio;
import tgbridge.shaded.okio.OutputStreamSink;
import tgbridge.shaded.okio.Sink;
import tgbridge.shaded.okio.SocketAsyncTimeout;
import tgbridge.shaded.okio.Source;
import tgbridge.shaded.okio.Timeout;
import tgbridge.shaded.okio.internal.ResourceFileSystem;

@Metadata(mv={1, 9, 0}, k=5, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0011\u0010\u0006\u001a\u00020\u0005*\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0019\u0010\u000b\u001a\u00020\n*\u00020\u00012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u0019\u0010\u000f\u001a\u00020\u000e*\u00020\r2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u0019\u0010\u0014\u001a\u00020\u0013*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a\u0019\u0010\u0014\u001a\u00020\u0013*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0018\u001a\u0019\u0010\u001a\u001a\u00020\u0019*\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a\u0019\u0010\u001a\u001a\u00020\u0019*\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001c\u001a\u001d\u0010\u001f\u001a\u00020\u0001*\u00020\u00002\b\b\u0002\u0010\u001e\u001a\u00020\u001dH\u0007\u00a2\u0006\u0004\b\u001f\u0010 \u001a\u0011\u0010\u001f\u001a\u00020\u0001*\u00020!\u00a2\u0006\u0004\b\u001f\u0010\"\u001a\u0011\u0010\u001f\u001a\u00020\u0001*\u00020#\u00a2\u0006\u0004\b\u001f\u0010$\u001a%\u0010\u001f\u001a\u00020\u0001*\u00020%2\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020'0&\"\u00020'\u00a2\u0006\u0004\b\u001f\u0010)\u001a\u0011\u0010*\u001a\u00020\r*\u00020\u0000\u00a2\u0006\u0004\b*\u0010+\u001a\u0011\u0010*\u001a\u00020\r*\u00020,\u00a2\u0006\u0004\b*\u0010-\u001a\u0011\u0010*\u001a\u00020\r*\u00020#\u00a2\u0006\u0004\b*\u0010.\u001a%\u0010*\u001a\u00020\r*\u00020%2\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020'0&\"\u00020'\u00a2\u0006\u0004\b*\u0010/\"\u001c\u00102\u001a\n 1*\u0004\u0018\u000100008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103\"\u001c\u00106\u001a\u00020\u001d*\u000604j\u0002`58@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u00068"}, d2={"Ljava/io/File;", "Ltgbridge/shaded/okio/Sink;", "appendingSink", "(Ljava/io/File;)Ltgbridge/shaded/okio/Sink;", "Ljava/lang/ClassLoader;", "Ltgbridge/shaded/okio/FileSystem;", "asResourceFileSystem", "(Ljava/lang/ClassLoader;)Ltgbridge/shaded/okio/FileSystem;", "Ljavax/crypto/Cipher;", "cipher", "Ltgbridge/shaded/okio/CipherSink;", "cipherSink", "(Ltgbridge/shaded/okio/Sink;Ljavax/crypto/Cipher;)Ltgbridge/shaded/okio/CipherSink;", "Ltgbridge/shaded/okio/Source;", "Ltgbridge/shaded/okio/CipherSource;", "cipherSource", "(Ltgbridge/shaded/okio/Source;Ljavax/crypto/Cipher;)Ltgbridge/shaded/okio/CipherSource;", "Ljava/security/MessageDigest;", "digest", "Ltgbridge/shaded/okio/HashingSink;", "hashingSink", "(Ltgbridge/shaded/okio/Sink;Ljava/security/MessageDigest;)Ltgbridge/shaded/okio/HashingSink;", "Ljavax/crypto/Mac;", "mac", "(Ltgbridge/shaded/okio/Sink;Ljavax/crypto/Mac;)Ltgbridge/shaded/okio/HashingSink;", "Ltgbridge/shaded/okio/HashingSource;", "hashingSource", "(Ltgbridge/shaded/okio/Source;Ljava/security/MessageDigest;)Ltgbridge/shaded/okio/HashingSource;", "(Ltgbridge/shaded/okio/Source;Ljavax/crypto/Mac;)Ltgbridge/shaded/okio/HashingSource;", "", "append", "sink", "(Ljava/io/File;Z)Ltgbridge/shaded/okio/Sink;", "Ljava/io/OutputStream;", "(Ljava/io/OutputStream;)Ltgbridge/shaded/okio/Sink;", "Ljava/net/Socket;", "(Ljava/net/Socket;)Ltgbridge/shaded/okio/Sink;", "Ljava/nio/file/Path;", "", "Ljava/nio/file/OpenOption;", "options", "(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Lokio/Sink;", "source", "(Ljava/io/File;)Ltgbridge/shaded/okio/Source;", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)Ltgbridge/shaded/okio/Source;", "(Ljava/net/Socket;)Ltgbridge/shaded/okio/Source;", "(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Lokio/Source;", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "logger", "Ljava/util/logging/Logger;", "Ljava/lang/AssertionError;", "Lkotlin/AssertionError;", "isAndroidGetsocknameError", "(Ljava/lang/AssertionError;)Z", "tgbridge.shaded.okio"}, xs="tgbridge/shaded/okio/Okio")
final class Okio__JvmOkioKt {
    private static final Logger logger = Logger.getLogger("tgbridge.shaded.okio.Okio");

    @NotNull
    public static final Sink sink(@NotNull OutputStream $this$sink) {
        Intrinsics.checkNotNullParameter((Object)$this$sink, (String)"<this>");
        return new OutputStreamSink($this$sink, new Timeout());
    }

    @NotNull
    public static final Source source(@NotNull InputStream $this$source) {
        Intrinsics.checkNotNullParameter((Object)$this$source, (String)"<this>");
        return new InputStreamSource($this$source, new Timeout());
    }

    @NotNull
    public static final Sink sink(@NotNull Socket $this$sink) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$sink, (String)"<this>");
        SocketAsyncTimeout timeout = new SocketAsyncTimeout($this$sink);
        OutputStream outputStream2 = $this$sink.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream2, (String)"getOutputStream(...)");
        OutputStreamSink sink2 = new OutputStreamSink(outputStream2, timeout);
        return timeout.sink(sink2);
    }

    @NotNull
    public static final Source source(@NotNull Socket $this$source) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$source, (String)"<this>");
        SocketAsyncTimeout timeout = new SocketAsyncTimeout($this$source);
        InputStream inputStream2 = $this$source.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getInputStream(...)");
        InputStreamSource source2 = new InputStreamSource(inputStream2, timeout);
        return timeout.source(source2);
    }

    @JvmOverloads
    @NotNull
    public static final Sink sink(@NotNull File $this$sink, boolean append) throws FileNotFoundException {
        Intrinsics.checkNotNullParameter((Object)$this$sink, (String)"<this>");
        return Okio.sink(new FileOutputStream($this$sink, append));
    }

    public static /* synthetic */ Sink sink$default(File file, boolean bl, int n, Object object) throws FileNotFoundException {
        if ((n & 1) != 0) {
            bl = false;
        }
        return Okio.sink(file, bl);
    }

    @NotNull
    public static final Sink appendingSink(@NotNull File $this$appendingSink) throws FileNotFoundException {
        Intrinsics.checkNotNullParameter((Object)$this$appendingSink, (String)"<this>");
        return Okio.sink(new FileOutputStream($this$appendingSink, true));
    }

    @NotNull
    public static final Source source(@NotNull File $this$source) throws FileNotFoundException {
        Intrinsics.checkNotNullParameter((Object)$this$source, (String)"<this>");
        return new InputStreamSource(new FileInputStream($this$source), Timeout.NONE);
    }

    @NotNull
    public static final Sink sink(@NotNull Path $this$sink, OpenOption ... options) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$sink, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        OutputStream outputStream2 = Files.newOutputStream($this$sink, Arrays.copyOf(options, options.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream2, (String)"newOutputStream(...)");
        return Okio.sink(outputStream2);
    }

    @NotNull
    public static final Source source(@NotNull Path $this$source, OpenOption ... options) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$source, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        InputStream inputStream2 = Files.newInputStream($this$source, Arrays.copyOf(options, options.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"newInputStream(...)");
        return Okio.source(inputStream2);
    }

    @NotNull
    public static final CipherSink cipherSink(@NotNull Sink $this$cipherSink, @NotNull Cipher cipher) {
        Intrinsics.checkNotNullParameter((Object)$this$cipherSink, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cipher, (String)"cipher");
        return new CipherSink(Okio.buffer($this$cipherSink), cipher);
    }

    @NotNull
    public static final CipherSource cipherSource(@NotNull Source $this$cipherSource, @NotNull Cipher cipher) {
        Intrinsics.checkNotNullParameter((Object)$this$cipherSource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cipher, (String)"cipher");
        return new CipherSource(Okio.buffer($this$cipherSource), cipher);
    }

    @NotNull
    public static final HashingSink hashingSink(@NotNull Sink $this$hashingSink, @NotNull Mac mac) {
        Intrinsics.checkNotNullParameter((Object)$this$hashingSink, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)mac, (String)"mac");
        return new HashingSink($this$hashingSink, mac);
    }

    @NotNull
    public static final HashingSource hashingSource(@NotNull Source $this$hashingSource, @NotNull Mac mac) {
        Intrinsics.checkNotNullParameter((Object)$this$hashingSource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)mac, (String)"mac");
        return new HashingSource($this$hashingSource, mac);
    }

    @NotNull
    public static final HashingSink hashingSink(@NotNull Sink $this$hashingSink, @NotNull MessageDigest digest) {
        Intrinsics.checkNotNullParameter((Object)$this$hashingSink, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        return new HashingSink($this$hashingSink, digest);
    }

    @NotNull
    public static final HashingSource hashingSource(@NotNull Source $this$hashingSource, @NotNull MessageDigest digest) {
        Intrinsics.checkNotNullParameter((Object)$this$hashingSource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        return new HashingSource($this$hashingSource, digest);
    }

    @NotNull
    public static final FileSystem asResourceFileSystem(@NotNull ClassLoader $this$asResourceFileSystem) {
        Intrinsics.checkNotNullParameter((Object)$this$asResourceFileSystem, (String)"<this>");
        return new ResourceFileSystem($this$asResourceFileSystem, true, null, 4, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isAndroidGetsocknameError(@NotNull AssertionError $this$isAndroidGetsocknameError) {
        Intrinsics.checkNotNullParameter((Object)$this$isAndroidGetsocknameError, (String)"<this>");
        if (((Throwable)((Object)$this$isAndroidGetsocknameError)).getCause() == null) return false;
        String string = ((Throwable)((Object)$this$isAndroidGetsocknameError)).getMessage();
        if (string == null) return false;
        boolean bl = StringsKt.contains$default((CharSequence)string, (CharSequence)"getsockname failed", (boolean)false, (int)2, null);
        if (!bl) return false;
        return true;
    }

    @JvmOverloads
    @NotNull
    public static final Sink sink(@NotNull File $this$sink) throws FileNotFoundException {
        Intrinsics.checkNotNullParameter((Object)$this$sink, (String)"<this>");
        return Okio.sink$default($this$sink, false, 1, null);
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }
}

