/*
 * Decompiled with CFR 0.152.
 */
package tgbridge.shaded.okio;

import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import tgbridge.shaded.okio.Buffer;
import tgbridge.shaded.okio.Okio;
import tgbridge.shaded.okio.Segment;
import tgbridge.shaded.okio.SegmentPool;
import tgbridge.shaded.okio.Source;
import tgbridge.shaded.okio.Timeout;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0012\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000f\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0015R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0016\u00a8\u0006\u0017"}, d2={"Ltgbridge/shaded/okio/InputStreamSource;", "Ltgbridge/shaded/okio/Source;", "Ljava/io/InputStream;", "input", "Ltgbridge/shaded/okio/Timeout;", "timeout", "<init>", "(Ljava/io/InputStream;Lokio/Timeout;)V", "", "close", "()V", "Ltgbridge/shaded/okio/Buffer;", "sink", "", "byteCount", "read", "(Ltgbridge/shaded/okio/Buffer;J)J", "()Ltgbridge/shaded/okio/Timeout;", "", "toString", "()Ljava/lang/String;", "Ljava/io/InputStream;", "Ltgbridge/shaded/okio/Timeout;", "tgbridge.shaded.okio"})
@SourceDebugExtension(value={"SMAP\nJvmOkio.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmOkio.kt\nokio/InputStreamSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Util.kt\nokio/-SegmentedByteString\n*L\n1#1,236:1\n1#2:237\n86#3:238\n*S KotlinDebug\n*F\n+ 1 JvmOkio.kt\nokio/InputStreamSource\n*L\n92#1:238\n*E\n"})
class InputStreamSource
implements Source {
    @NotNull
    private final InputStream input;
    @NotNull
    private final Timeout timeout;

    public InputStreamSource(@NotNull InputStream input, @NotNull Timeout timeout) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        this.input = input;
        this.timeout = timeout;
    }

    @Override
    public long read(@NotNull Buffer sink2, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        if (byteCount == 0L) {
            return 0L;
        }
        if (!(byteCount >= 0L)) {
            boolean $i$a$-require-InputStreamSource$read$22 = false;
            String $i$a$-require-InputStreamSource$read$22 = "byteCount < 0: " + byteCount;
            throw new IllegalArgumentException($i$a$-require-InputStreamSource$read$22.toString());
        }
        try {
            this.timeout.throwIfReached();
            Segment tail = sink2.writableSegment$okio(1);
            int b$iv = 8192 - tail.limit;
            boolean $i$f$minOf = false;
            int maxToCopy = (int)Math.min(byteCount, (long)b$iv);
            int bytesRead = this.input.read(tail.data, tail.limit, maxToCopy);
            if (bytesRead == -1) {
                if (tail.pos == tail.limit) {
                    sink2.head = tail.pop();
                    SegmentPool.recycle(tail);
                }
                return -1L;
            }
            tail.limit += bytesRead;
            sink2.setSize$okio(sink2.size() + (long)bytesRead);
            return bytesRead;
        }
        catch (AssertionError e) {
            if (Okio.isAndroidGetsocknameError(e)) {
                throw new IOException((Throwable)((Object)e));
            }
            throw e;
        }
    }

    @Override
    public void close() {
        this.input.close();
    }

    @Override
    @NotNull
    public Timeout timeout() {
        return this.timeout;
    }

    @NotNull
    public String toString() {
        return "source(" + this.input + ')';
    }
}

