/*
 * Decompiled with CFR 0.152.
 */
package dev.vanutp.tgbridge.forge;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.vanutp.tgbridge.common.models.TBCommandContext;
import dev.vanutp.tgbridge.common.models.TBPlayerEventData;
import dev.vanutp.tgbridge.forge.ForgeTelegramBridge;
import dev.vanutp.tgbridge.forge.UtilsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u000f\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0003J\u000f\u0010\b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\u0003J\u000f\u0010\t\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J\u000f\u0010\n\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\u0003J\u001d\u0010\u000f\u001a\u00020\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0003\u00a8\u0006\u0012"}, d2={"Ldev/vanutp/tgbridge/forge/EventManager;", "", "<init>", "()V", "", "register", "registerChatMessageListener", "registerPlayerDeathListener", "registerPlayerJoinListener", "registerPlayerLeaveListener", "registerPlayerAdvancementListener", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/minecraft/commands/CommandSourceStack;", "ctx", "", "onReloadCommand", "(Lcom/mojang/brigadier/context/CommandContext;)I", "registerCommandHandlers", "tgbridge-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nEventManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventManager.kt\ndev/vanutp/tgbridge/forge/EventManager\n+ 2 Forge.kt\nthedarkcolour/kotlinforforge/forge/ForgeKt\n*L\n1#1,107:1\n27#2:108\n27#2:109\n27#2:110\n27#2:111\n27#2:112\n27#2:113\n*S KotlinDebug\n*F\n+ 1 EventManager.kt\ndev/vanutp/tgbridge/forge/EventManager\n*L\n28#1:108\n39#1:109\n55#1:110\n61#1:111\n67#1:112\n96#1:113\n*E\n"})
public final class EventManager {
    @NotNull
    public static final EventManager INSTANCE = new EventManager();

    private EventManager() {
    }

    public final void register() {
        this.registerChatMessageListener();
        this.registerPlayerDeathListener();
        this.registerPlayerJoinListener();
        this.registerPlayerLeaveListener();
        this.registerPlayerAdvancementListener();
        this.registerCommandHandlers();
    }

    private final void registerChatMessageListener() {
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = MinecraftForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(EventManager::registerChatMessageListener$lambda$0);
    }

    private final void registerPlayerDeathListener() {
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = MinecraftForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(EventManager::registerPlayerDeathListener$lambda$1);
    }

    private final void registerPlayerJoinListener() {
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = MinecraftForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(EventManager::registerPlayerJoinListener$lambda$2);
    }

    private final void registerPlayerLeaveListener() {
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = MinecraftForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(EventManager::registerPlayerLeaveListener$lambda$3);
    }

    private final void registerPlayerAdvancementListener() {
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = MinecraftForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(EventManager::registerPlayerAdvancementListener$lambda$4);
    }

    private final int onReloadCommand(CommandContext<CommandSourceStack> ctx) {
        boolean res = ForgeTelegramBridge.INSTANCE.onReloadCommand(new TBCommandContext((Function1<? super String, Unit>)((Function1)arg_0 -> EventManager.onReloadCommand$lambda$6(ctx, arg_0))));
        return res ? 1 : -1;
    }

    private final void registerCommandHandlers() {
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = MinecraftForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(EventManager::registerCommandHandlers$lambda$8);
    }

    private static final void registerChatMessageListener$lambda$0(ServerChatEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ServerPlayer serverPlayer = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayer(...)");
        String string = UtilsKt.getPlayerName((Player)serverPlayer).getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        Component component = e.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getMessage(...)");
        ForgeTelegramBridge.INSTANCE.onChatMessage(new TBPlayerEventData(string, UtilsKt.toAdventure(component)));
    }

    private static final void registerPlayerDeathListener$lambda$1(LivingDeathEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        LivingEntity player = e.getEntity();
        if (!(player instanceof Player)) {
            return;
        }
        Component deathMessage = e.getSource().m_6157_(player);
        String string = UtilsKt.getPlayerName((Player)player).getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        Intrinsics.checkNotNull((Object)deathMessage);
        ForgeTelegramBridge.INSTANCE.onPlayerDeath(new TBPlayerEventData(string, UtilsKt.toAdventure(deathMessage)));
    }

    private static final void registerPlayerJoinListener$lambda$2(PlayerEvent.PlayerLoggedInEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Player player = e.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
        String string = UtilsKt.getPlayerName(player).getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        ForgeTelegramBridge.INSTANCE.onPlayerJoin(string);
    }

    private static final void registerPlayerLeaveListener$lambda$3(PlayerEvent.PlayerLoggedOutEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Player player = e.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
        String string = UtilsKt.getPlayerName(player).getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        ForgeTelegramBridge.INSTANCE.onPlayerLeave(string);
    }

    private static final void registerPlayerAdvancementListener$lambda$4(AdvancementEvent.AdvancementEarnEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DisplayInfo display = e.getAdvancement().m_138320_();
        if (display == null || !display.m_14996_()) {
            return;
        }
        Object object = display.m_14992_();
        if (object == null || (object = object.m_15548_()) == null) {
            return;
        }
        String advancementTypeKey = "chat.type.advancement." + (String)object;
        Object[] objectArray = new Object[2];
        Player player = e.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
        objectArray[0] = UtilsKt.getPlayerName(player);
        objectArray[1] = e.getAdvancement().m_138330_();
        MutableComponent advancementText = Component.m_237110_((String)advancementTypeKey, (Object[])objectArray);
        Player player2 = e.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"getEntity(...)");
        String string = UtilsKt.getPlayerName(player2).getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        Intrinsics.checkNotNull((Object)advancementText);
        ForgeTelegramBridge.INSTANCE.onPlayerAdvancement(new TBPlayerEventData(string, UtilsKt.toAdventure((Component)advancementText)));
    }

    private static final Component onReloadCommand$lambda$6$lambda$5(String $text) {
        return (Component)Component.m_237113_((String)$text);
    }

    private static final Unit onReloadCommand$lambda$6(CommandContext $ctx, String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ((CommandSourceStack)$ctx.getSource()).m_288197_(() -> EventManager.onReloadCommand$lambda$6$lambda$5(text), false);
        return Unit.INSTANCE;
    }

    private static final boolean registerCommandHandlers$lambda$8$lambda$7(CommandSourceStack it) {
        return it.m_6761_(4);
    }

    private static final void registerCommandHandlers$lambda$8(RegisterCommandsEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"tgbridge").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").requires(EventManager::registerCommandHandlers$lambda$8$lambda$7)).executes(INSTANCE::onReloadCommand)));
    }
}

