/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.data.provider.number;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import se.mickelus.tetra.effect.data.ItemEffectContext;
import se.mickelus.tetra.effect.data.condition.FixedItemEffectCondition;
import se.mickelus.tetra.effect.data.condition.ItemEffectCondition;
import se.mickelus.tetra.effect.data.provider.number.NumberProvider;
import se.mickelus.tetra.effect.data.provider.vector.VectorProvider;

public class BlockPropertyNumberProvider
implements NumberProvider {
    VectorProvider position;
    BlockProperty property;
    ItemEffectCondition relative = new FixedItemEffectCondition(false);

    @Override
    public float getValue(ItemEffectContext context) {
        ServerLevel level = context.getLevel();
        BlockPos blockPos = this.position.getBlockPos(context);
        BlockState blockState = level.m_8055_(blockPos);
        return switch (this.property) {
            default -> throw new IncompatibleClassChangeError();
            case BlockProperty.hardness -> blockState.m_60800_((BlockGetter)level, blockPos);
            case BlockProperty.lightValue -> blockState.m_60739_((BlockGetter)level, blockPos);
            case BlockProperty.experienceDrop -> this.getExpDrop(context, level, blockPos, blockState);
            case BlockProperty.comparatorValue -> blockState.m_60674_((Level)level, blockPos);
            case BlockProperty.flammability -> blockState.getFlammability((BlockGetter)level, blockPos, Direction.UP);
            case BlockProperty.friction -> blockState.getFriction((LevelReader)level, blockPos, null);
        };
    }

    private float getExpDrop(ItemEffectContext context, ServerLevel level, BlockPos blockPos, BlockState blockState) {
        if (this.relative.test(context)) {
            return blockState.getExpDrop((LevelReader)level, level.m_213780_(), blockPos, EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44987_, (ItemStack)context.getUsedItemStack()), EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44985_, (ItemStack)context.getUsedItemStack()));
        }
        return blockState.getExpDrop((LevelReader)level, level.m_213780_(), blockPos, 0, 0);
    }

    static enum BlockProperty {
        hardness,
        lightValue,
        experienceDrop,
        comparatorValue,
        flammability,
        friction;

    }
}

