/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.data;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.gson.Gson;
import java.util.stream.Stream;
import se.mickelus.mutil.data.DataDistributor;
import se.mickelus.mutil.data.DataStore;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.data.ItemEffectData;

public class ItemEffectStore
extends DataStore<ItemEffectData> {
    public static Multimap<ItemEffect, ItemEffectData> onHitEffects = ArrayListMultimap.create();
    public static Multimap<ItemEffect, ItemEffectData> onMineBlockEffects = ArrayListMultimap.create();
    public static Multimap<ItemEffect, ItemEffectData> onBreakBlockEffects = ArrayListMultimap.create();

    public ItemEffectStore(Gson gson, String namespace, String directory, DataDistributor synchronizer) {
        super(gson, namespace, directory, ItemEffectData.class, synchronizer);
    }

    protected void processData() {
        onHitEffects = (Multimap)this.dataMap.values().stream().filter(data -> data.trigger.type.equals("tetra:apply_hit_effects")).collect(Multimaps.flatteningToMultimap(entry -> entry.effect, Stream::of, ArrayListMultimap::create));
        onMineBlockEffects = (Multimap)this.dataMap.values().stream().filter(data -> data.trigger.type.equals("tetra:mine_block")).collect(Multimaps.flatteningToMultimap(entry -> entry.effect, Stream::of, ArrayListMultimap::create));
        onBreakBlockEffects = (Multimap)this.dataMap.values().stream().filter(data -> data.trigger.type.equals("tetra:break_block")).collect(Multimaps.flatteningToMultimap(entry -> entry.effect, Stream::of, ArrayListMultimap::create));
    }
}

