/*
 * Decompiled with CFR 0.152.
 */
package chiefarug.mods.systeams.compat.jei;

import chiefarug.mods.systeams.compat.jei.SysteamsJEIPlugin;
import chiefarug.mods.systeams.recipe.BoilingRecipe;
import cofh.lib.common.fluid.FluidIngredient;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.compat.jei.TCoreJeiPlugin;
import cofh.thermal.expansion.client.gui.dynamo.DynamoCompressionScreen;
import cofh.thermal.lib.compat.jei.Drawables;
import cofh.thermal.lib.compat.jei.ThermalRecipeCategory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class BoilingCategory
extends ThermalRecipeCategory<BoilingRecipe> {
    private final IDrawableStatic tankOverlay;
    private final IDrawableStatic tankBackground;
    private final IDrawableAnimated duration;
    private final IDrawableStatic durationBackground;

    public BoilingCategory(IGuiHelper guiHelper, ItemStack icon, RecipeType<BoilingRecipe> type) {
        super(guiHelper, icon, type);
        this.background = guiHelper.drawableBuilder(DynamoCompressionScreen.TEXTURE, 26, 11, 70, 62).addPadding(0, 0, 16, 78).build();
        this.name = StringHelper.getTextComponent((String)"info.systeams.boiling_recipe");
        this.tankBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(1);
        this.tankOverlay = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(1);
        this.durationBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getScale(4);
        this.duration = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getScaleFill(4), 400, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void draw(BoilingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((ThermalRecipe)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        this.tankBackground.draw(guiGraphics, 33, 10);
        this.tankBackground.draw(guiGraphics, 106, 10);
        this.durationBackground.draw(guiGraphics, 70, 24);
        this.duration.draw(guiGraphics, 70, 24);
    }

    @NotNull
    public RecipeType<BoilingRecipe> getRecipeType() {
        return SysteamsJEIPlugin.BOILING_RECIPE_TYPE;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BoilingRecipe recipe, IFocusGroup focuses) {
        int inAmount;
        int outAmount;
        FluidStack output = ((FluidStack)recipe.getOutputFluids().get(0)).copy();
        FluidStack[] input = ((FluidIngredient)recipe.getInputFluids().get(0)).getFluids();
        double ratio = (double)input[0].getAmount() / (double)output.getAmount();
        if (ratio < 1.0) {
            outAmount = 1000;
            inAmount = (int)Math.round((double)outAmount * ratio);
        } else {
            inAmount = 1000;
            outAmount = (int)Math.round((double)inAmount / ratio);
        }
        output.setAmount(outAmount);
        List<FluidStack> inputs = Arrays.stream(input).map(FluidStack::copy).peek(stack -> stack.setAmount(inAmount)).toList();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 34, 11).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, inputs)).setFluidRenderer((long)TCoreJeiPlugin.tankSize((int)0), false, 16, 40).setOverlay((IDrawable)this.tankOverlay, 0, 0).addTooltipCallback(TCoreJeiPlugin.defaultFluidTooltip());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 106, 11).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, List.of(output))).setFluidRenderer((long)TCoreJeiPlugin.tankSize((int)0), false, 16, 40).setOverlay((IDrawable)this.tankOverlay, 0, 0).addTooltipCallback(TCoreJeiPlugin.defaultFluidTooltip());
    }
}

