/*
 * Decompiled with CFR 0.152.
 */
package chiefarug.mods.systeams.block_entities;

import chiefarug.mods.systeams.Systeams;
import chiefarug.mods.systeams.SysteamsRegistry;
import chiefarug.mods.systeams.compat.mekanism.SysteamsMekanismCompat;
import chiefarug.mods.systeams.recipe.BoilingRecipeManager;
import cofh.core.util.helpers.AugmentDataHelper;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.api.block.entity.ITickableTile;
import cofh.lib.api.fluid.IFluidStackHolder;
import cofh.lib.api.inventory.IItemStackHolder;
import cofh.lib.common.fluid.FluidStorageCoFH;
import cofh.lib.util.Constants;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.BlockStatePropertiesCoFH;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.lib.common.block.entity.AugmentableBlockEntity;
import cofh.thermal.lib.util.ThermalAugmentRules;
import cofh.thermal.lib.util.managers.IFuelManager;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import cofh.thermal.lib.util.recipes.internal.IDynamoFuel;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public abstract class BoilerBlockEntityBase
extends AugmentableBlockEntity
implements ITickableTile.IServerTickable,
IThermalInventory {
    private static final int TRANSFER_PER_TICK = 1000;
    private final Predicate<FluidStack> isWater = fluid -> this.filter.valid(fluid) && BoilingRecipeManager.instance().canBoil((FluidStack)fluid);
    public final FluidStorageCoFH waterTank = new FluidStorageCoFH(8000, this.isWater);
    private final Predicate<FluidStack> isSteam = fluid -> SysteamsRegistry.Fluids.STEAMISH_TAG.contains((Object)fluid.getFluid());
    public final FluidStorageCoFH steamTank = new FluidStorageCoFH(16000, this.isSteam);
    private LazyOptional<?> steamCap = LazyOptional.empty();
    private Direction facing;
    protected int maxEnergyBuffer;
    protected int remainingEnergyBuffer;
    protected int energyPerTick;
    protected int steamPerTick;
    protected double remainingwWaterBuffer;
    protected double waterPerTick;
    protected BoilingRecipeManager.BoiledFluid cachedOutput;
    protected int baseEnergyPerTick = this.getBaseProcessTick();
    public boolean gasMode = false;
    protected float generationModifier = 1.0f;
    protected float efficiencyModifier = 1.0f;

    public BoilerBlockEntityBase(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.tankInv.addTank(this.waterTank, StorageGroup.INPUT);
        this.tankInv.addTank(this.steamTank, StorageGroup.OUTPUT);
        this.facing = (Direction)state.m_61143_((Property)BlockStatePropertiesCoFH.FACING_ALL);
        this.recalculateEnergy();
        this.recalculateWater();
    }

    public void m_155250_(BlockState pBlockState) {
        super.m_155250_(pBlockState);
        this.updateFacing();
    }

    public void tickServer() {
        boolean curActive = this.isActive;
        if (this.isActive) {
            this.processTick();
            if (this.canProcessFinish()) {
                this.processFinish();
                this.isActive = false;
                if (this.redstoneControl.getState() && this.canProcessStart()) {
                    this.isActive = true;
                    this.processStart();
                }
            }
        } else if (Utils.timeCheckQuarter()) {
            if (!this.steamTank.isEmpty()) {
                this.transferSteamOut(100);
            }
            if (this.redstoneControl.getState() && this.canProcessStart()) {
                this.isActive = true;
                this.processStart();
                this.processTick();
            }
        }
        this.updateActiveState(curActive);
    }

    protected boolean canProcessStart() {
        if (!this.cacheBoilingRecipe()) {
            return false;
        }
        return this.tryHaveWaterToTick() && this.tryHaveEnergyToTick() && this.steamTank.getSpace() >= this.steamPerTick;
    }

    protected void processStart() {
        this.recalculateEnergy();
        this.recalculateWater();
    }

    protected void processFinish() {
        if (this.energyPerTick < this.remainingEnergyBuffer) {
            this.maxEnergyBuffer = -1;
        }
    }

    protected boolean canProcessFinish() {
        return !this.hasWaterToTick() || !this.hasEnergyToTick() || this.steamTank.getSpace() < this.steamPerTick;
    }

    protected void processTick() {
        if (this.waterTank.isEmpty() && this.cachedOutput == null) {
            this.remainingwWaterBuffer = 0.0;
            return;
        }
        FluidStack newSteam = new FluidStack(this.cachedOutput.fluidOut(), this.steamPerTick);
        this.remainingwWaterBuffer -= this.waterPerTick;
        this.tryHaveWaterToTick();
        this.remainingEnergyBuffer -= this.energyPerTick;
        this.tryHaveEnergyToTick();
        this.steamTank.fill(newSteam, IFluidHandler.FluidAction.EXECUTE);
        this.transferSteamOut(1000);
    }

    protected int getFuelEnergy() {
        IDynamoFuel fuel = this.getFuelManager().getFuel((IThermalInventory)this);
        return fuel == null ? 0 : fuel.getEnergy();
    }

    protected abstract int consumeFuel();

    protected abstract double getEnergyToSteamRatio();

    protected abstract IFuelManager getFuelManager();

    protected abstract double getSpeedMultiplier();

    protected boolean cacheBoilingRecipe() {
        if (this.waterTank.isEmpty()) {
            return this.cachedOutput != null;
        }
        this.cachedOutput = BoilingRecipeManager.instance().boil(this.waterTank.getFluidStack());
        return this.cachedOutput != null;
    }

    protected void recalculateEnergy() {
        if (this.isActive) {
            this.maxEnergyBuffer = Math.max(this.maxEnergyBuffer, this.remainingEnergyBuffer);
        }
        this.baseEnergyPerTick = this.getBaseProcessTick();
        this.energyPerTick = (int)((float)this.baseEnergyPerTick * this.generationModifier);
        this.steamPerTick = (int)((double)this.energyPerTick * this.getEnergyToSteamRatio());
    }

    protected boolean hasEnergyToTick() {
        return this.energyPerTick <= this.remainingEnergyBuffer;
    }

    protected boolean tryHaveEnergyToTick() {
        if (this.hasEnergyToTick()) {
            return true;
        }
        this.refillEnergy();
        return this.hasEnergyToTick();
    }

    protected void refillEnergy() {
        int refill = (int)((float)this.consumeFuel() * this.efficiencyModifier);
        if (refill == 0) {
            return;
        }
        this.remainingEnergyBuffer += refill;
        this.recalculateEnergy();
    }

    protected void recalculateWater() {
        if (this.cacheBoilingRecipe()) {
            this.waterPerTick = this.cachedOutput.getInPerTick(this.steamPerTick);
        }
    }

    protected boolean hasWaterToTick() {
        return this.waterPerTick <= this.remainingwWaterBuffer;
    }

    protected boolean tryHaveWaterToTick() {
        if (this.hasWaterToTick()) {
            return true;
        }
        this.refillWater();
        return this.hasWaterToTick();
    }

    protected void refillWater() {
        if (!this.cacheBoilingRecipe()) {
            return;
        }
        int refill = this.waterTank.drain((int)Math.ceil(this.waterPerTick), IFluidHandler.FluidAction.EXECUTE).getAmount();
        if (refill == 0) {
            return;
        }
        this.remainingwWaterBuffer += (double)refill;
        this.recalculateWater();
    }

    protected int getBaseProcessTick() {
        return (int)((double)super.getBaseProcessTick() * this.getSpeedMultiplier());
    }

    public int getScaledDuration(int scale) {
        if (this.maxEnergyBuffer <= 0 || this.remainingEnergyBuffer <= 0) {
            return 0;
        }
        return scale * this.remainingEnergyBuffer / this.maxEnergyBuffer;
    }

    protected Predicate<ItemStack> augValidator() {
        BiPredicate validator = this.tankInv.hasTanks() ? ThermalAugmentRules.DYNAMO_VALIDATOR : ThermalAugmentRules.DYNAMO_NO_FLUID_VALIDATOR;
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && validator.test(item, this.getAugmentsAsList());
    }

    protected void resetAttributes() {
        super.resetAttributes();
        this.generationModifier = 1.0f;
        this.efficiencyModifier = 1.0f;
        AugmentableHelper.setAttribute((CompoundTag)this.augmentNBT, (String)"DynamoPower", (float)this.generationModifier);
        AugmentableHelper.setAttribute((CompoundTag)this.augmentNBT, (String)"DynamoEnergy", (float)this.efficiencyModifier);
    }

    protected void setAttributesFromAugment(CompoundTag augmentData) {
        super.setAttributesFromAugment(augmentData);
        AugmentableHelper.setAttributeFromAugmentAdd((CompoundTag)this.augmentNBT, (CompoundTag)augmentData, (String)"DynamoPower");
        this.generationModifier += AugmentableHelper.getAttributeModWithDefault((CompoundTag)augmentData, (String)"DynamoPower", (float)0.0f);
        this.efficiencyModifier *= AugmentableHelper.getAttributeModWithDefault((CompoundTag)augmentData, (String)"DynamoEnergy", (float)1.0f);
    }

    protected void finalizeAttributes(Map<Enchantment, Integer> enchantmentMap) {
        super.finalizeAttributes(enchantmentMap);
        this.generationModifier *= AugmentableHelper.getAttributeModWithDefault((CompoundTag)this.augmentNBT, (String)"BaseMod", (float)1.0f);
        this.efficiencyModifier = MathHelper.clamp((float)this.efficiencyModifier, (float)Constants.AUG_SCALE_MIN, (float)Constants.AUG_SCALE_MAX);
        this.recalculateEnergy();
        this.recalculateWater();
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.maxEnergyBuffer = nbt.m_128451_("FuelMax");
        this.remainingEnergyBuffer = nbt.m_128451_("Fuel");
        this.energyPerTick = nbt.m_128451_("ProcTick");
        this.recalculateEnergy();
        this.remainingwWaterBuffer = nbt.m_128459_("Water");
        this.waterPerTick = nbt.m_128459_("WaterTick");
        this.recalculateEnergy();
        this.recalculateWater();
        this.updateHandlers();
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("FuelMax", this.maxEnergyBuffer);
        nbt.m_128347_("Fuel", (double)this.remainingEnergyBuffer);
        nbt.m_128347_("ProcTick", (double)this.energyPerTick);
        nbt.m_128347_("Water", this.remainingwWaterBuffer);
        nbt.m_128347_("WaterTick", this.waterPerTick);
    }

    public FriendlyByteBuf getGuiPacket(FriendlyByteBuf buffer) {
        super.getGuiPacket(buffer);
        buffer.writeInt(this.maxEnergyBuffer);
        buffer.writeInt(this.remainingEnergyBuffer);
        buffer.writeBoolean(this.gasMode);
        buffer.writeInt(this.steamPerTick);
        return buffer;
    }

    public void handleGuiPacket(FriendlyByteBuf buffer) {
        super.handleGuiPacket(buffer);
        this.maxEnergyBuffer = buffer.readInt();
        this.remainingEnergyBuffer = buffer.readInt();
        this.gasMode = buffer.readBoolean();
        this.steamPerTick = buffer.readInt();
    }

    public double getEfficiency() {
        if (this.efficiencyModifier <= 0.0f) {
            return Double.MIN_VALUE;
        }
        return this.efficiencyModifier;
    }

    public int getCurSpeed() {
        return this.isActive ? this.steamPerTick : 0;
    }

    public double currentWaterConsumption() {
        return this.isActive ? this.waterPerTick : 0.0;
    }

    public List<? extends IItemStackHolder> inputSlots() {
        return this.inventory.getInputSlots();
    }

    public List<? extends IFluidStackHolder> inputTanks() {
        return this.tankInv.getInputTanks();
    }

    protected void transferSteamOut(int rate) {
        if (FluidHelper.insertIntoAdjacent((BlockEntity)this, (FluidStorageCoFH)this.steamTank, (int)rate, (Direction)this.getFacing())) {
            this.gasMode = false;
        }
    }

    protected Direction getFacing() {
        if (this.facing == null) {
            this.updateFacing();
        }
        return this.facing;
    }

    protected void updateFacing() {
        this.facing = (Direction)this.m_58900_().m_61143_((Property)BlockStatePropertiesCoFH.FACING_ALL);
        this.updateHandlers();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == Systeams.GAS_HANDLER_CAPABILITY) {
            return this.getGasHandlerCapability(side);
        }
        return super.getCapability(cap, side);
    }

    protected <T> LazyOptional<T> getItemHandlerCapability(@Nullable Direction side) {
        if (side != null && side.equals((Object)this.getFacing())) {
            return LazyOptional.empty();
        }
        return super.getItemHandlerCapability(side);
    }

    protected <T> LazyOptional<T> getFluidHandlerCapability(@Nullable Direction side) {
        if (side != null && side.equals((Object)this.getFacing())) {
            if (!this.steamCap.isPresent()) {
                this.steamCap = LazyOptional.of(() -> this.tankInv.getHandler(StorageGroup.OUTPUT));
            }
            this.gasMode = false;
            return this.steamCap.cast();
        }
        return super.getFluidHandlerCapability(side);
    }

    protected <T> LazyOptional<T> getGasHandlerCapability(@Nullable Direction side) {
        if (side != null && side.equals((Object)this.getFacing())) {
            LazyOptional<T> fluidCap = this.getFluidHandlerCapability(side);
            this.gasMode = true;
            return SysteamsMekanismCompat.wrapLiquidCapability(fluidCap).cast();
        }
        return LazyOptional.empty();
    }
}

