/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modulesclient;

import java.util.Objects;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleRenderHelper;
import mcjty.rftoolsbase.api.screens.ITextRenderHelper;
import mcjty.rftoolsbase.api.screens.ModuleRenderInfo;
import mcjty.rftoolsbase.api.screens.data.IModuleDataString;
import mcjty.rftoolsbase.tools.ScreenTextHelper;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class MachineInformationClientScreenModule
implements IClientScreenModule<IModuleDataString> {
    private String line = "";
    private int labcolor = 0xFFFFFF;
    private int txtcolor = 0xFFFFFF;
    protected ResourceKey<Level> dim = Level.f_46428_;
    protected BlockPos coordinate = BlockPosTools.INVALID;
    private final ITextRenderHelper labelCache = new ScreenTextHelper();

    public IClientScreenModule.TransformMode getTransformMode() {
        return IClientScreenModule.TransformMode.TEXT;
    }

    public int getHeight() {
        return 10;
    }

    public void render(GuiGraphics graphics, MultiBufferSource buffer, IModuleRenderHelper renderHelper, Font fontRenderer, int currenty, IModuleDataString screenData, ModuleRenderInfo renderInfo) {
        int xoffset;
        if (!this.line.isEmpty()) {
            this.labelCache.setup(this.line, 160, renderInfo);
            this.labelCache.renderText(graphics, buffer, 0, currenty, this.labcolor, renderInfo);
            xoffset = 47;
        } else {
            xoffset = 7;
        }
        if (!BlockPosTools.INVALID.equals((Object)this.coordinate) && screenData != null) {
            renderHelper.renderText(graphics, buffer, xoffset, currenty, this.txtcolor, renderInfo, screenData.get());
        } else {
            renderHelper.renderText(graphics, buffer, xoffset, currenty, 0xFF0000, renderInfo, "<invalid>");
        }
    }

    public void mouseClick(Level world, int x, int y, boolean clicked) {
    }

    public void setupFromNBT(CompoundTag tagCompound, ResourceKey<Level> dim, BlockPos pos) {
        if (tagCompound != null) {
            this.line = tagCompound.m_128461_("text");
            this.labcolor = tagCompound.m_128441_("color") ? tagCompound.m_128451_("color") : 0xFFFFFF;
            this.txtcolor = tagCompound.m_128441_("txtcolor") ? tagCompound.m_128451_("txtcolor") : 0xFFFFFF;
            this.setupCoordinateFromNBT(tagCompound, dim, pos);
        }
    }

    protected void setupCoordinateFromNBT(CompoundTag tagCompound, ResourceKey<Level> dim, BlockPos pos) {
        this.coordinate = BlockPosTools.INVALID;
        if (tagCompound.m_128441_("monitorx")) {
            this.dim = LevelTools.getId((String)tagCompound.m_128461_("monitordim"));
            if (Objects.equals(dim, this.dim)) {
                BlockPos c = new BlockPos(tagCompound.m_128451_("monitorx"), tagCompound.m_128451_("monitory"), tagCompound.m_128451_("monitorz"));
                int dx = Math.abs(c.m_123341_() - pos.m_123341_());
                int dy = Math.abs(c.m_123342_() - pos.m_123342_());
                int dz = Math.abs(c.m_123343_() - pos.m_123343_());
                if (dx <= 64 && dy <= 64 && dz <= 64) {
                    this.coordinate = c;
                }
            }
        }
    }

    public boolean needsServerData() {
        return true;
    }
}

