/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.network;

import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public record PacketRequestItem(ResourceKey<Level> dimensionId, BlockPos pos, BlockPos inventoryPos, ItemStack item, Integer amount, Boolean craftable) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("rftoolsstorage", "requestitem");

    public void write(FriendlyByteBuf buf) {
        buf.m_130085_(this.dimensionId.m_135782_());
        buf.m_130064_(this.pos);
        buf.m_130064_(this.inventoryPos);
        NetworkTools.writeItemStack((FriendlyByteBuf)buf, (ItemStack)this.item);
        buf.writeInt(this.amount.intValue());
        buf.writeBoolean(this.craftable.booleanValue());
    }

    public ResourceLocation id() {
        return ID;
    }

    public static PacketRequestItem create(FriendlyByteBuf buf) {
        return new PacketRequestItem((ResourceKey<Level>)LevelTools.getId((ResourceLocation)buf.m_130281_()), buf.m_130135_(), buf.m_130135_(), NetworkTools.readItemStack((FriendlyByteBuf)buf), buf.readInt(), buf.readBoolean());
    }

    public static PacketRequestItem create(ResourceKey<Level> dimensionId, BlockPos pos, BlockPos inventoryPos, ItemStack item, int amount, boolean craftable) {
        return new PacketRequestItem(dimensionId, pos, inventoryPos, item, amount, craftable);
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> ctx.player().ifPresent(player -> {
            ServerLevel world = LevelTools.getLevel((Level)player.m_9236_(), this.dimensionId);
            if (world == null) {
                return;
            }
            if (!LevelTools.isLoaded((Level)world, (BlockPos)this.pos)) {
                return;
            }
            BlockEntity te = world.m_7702_(this.pos);
            if (te instanceof StorageScannerTileEntity) {
                StorageScannerTileEntity scanner = (StorageScannerTileEntity)te;
                if (this.craftable.booleanValue()) {
                    scanner.requestCraft(this.inventoryPos, this.item, this.amount, (Player)player);
                } else {
                    scanner.requestStack(this.inventoryPos, this.item, this.amount, (Player)player);
                }
            }
        }));
    }
}

