/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.knowledge.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import mcjty.rftoolsdim.modules.dimlets.data.DimletRarity;
import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import mcjty.rftoolsdim.modules.knowledge.data.DimletPattern;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeKey;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeSet;
import mcjty.rftoolsdim.modules.knowledge.data.PatternBuilder;

public class RandomPatternCreator {
    private static final List<String[]> PATTERNS = new ArrayList<String[]>();

    private static List<String[]> getPatterns() {
        if (PATTERNS.isEmpty()) {
            RandomPatternCreator.generatePattern("##", "##");
            RandomPatternCreator.generatePattern("# ", " #");
            RandomPatternCreator.generatePattern(" #", "# ");
            RandomPatternCreator.generatePattern("##", " #");
            RandomPatternCreator.generatePattern("##", "# ");
            RandomPatternCreator.generatePattern(" #", "##");
            RandomPatternCreator.generatePattern("# ", "##");
            RandomPatternCreator.generatePattern("###", "###");
            RandomPatternCreator.generatePattern("##", "##", "##");
            RandomPatternCreator.generatePattern("####", "####");
            RandomPatternCreator.generatePattern("##", "##", "##", "##");
            RandomPatternCreator.generatePattern("# #", "   ", "# #");
            RandomPatternCreator.generatePattern("###", "   ", "###");
            RandomPatternCreator.generatePattern("# #", "# #", "# #");
            RandomPatternCreator.generatePattern("###", "#  ", "###");
            RandomPatternCreator.generatePattern("###", "# #", "# #");
            RandomPatternCreator.generatePattern("###", "  #", "###");
            RandomPatternCreator.generatePattern("# #", "# #", "###");
            RandomPatternCreator.generatePattern("###", "# #", "###");
            RandomPatternCreator.generatePattern("###", " # ", "###");
            RandomPatternCreator.generatePattern("# #", "###", "# #");
            RandomPatternCreator.generatePattern("#  ", " # ", "  #");
            RandomPatternCreator.generatePattern("  #", " # ", "#  ");
            RandomPatternCreator.generatePattern("###", "#  ", "#  ");
            RandomPatternCreator.generatePattern("###", "  #", "  #");
            RandomPatternCreator.generatePattern("#  ", "#  ", "###");
            RandomPatternCreator.generatePattern("  #", "  #", "###");
            RandomPatternCreator.generatePattern(" ##", "#  ", "#  ");
            RandomPatternCreator.generatePattern("## ", "  #", "  #");
            RandomPatternCreator.generatePattern("#  ", "#  ", " ##");
            RandomPatternCreator.generatePattern("  #", "  #", "## ");
            RandomPatternCreator.generatePattern("# #", " # ", "# #");
            RandomPatternCreator.generatePattern(" # ", "###", " # ");
            RandomPatternCreator.generatePattern("###", "###", "###");
            RandomPatternCreator.generatePattern("#  #", "    ", "    ", "#  #");
            RandomPatternCreator.generatePattern("####", "#   ", "#   ", "#   ");
            RandomPatternCreator.generatePattern("####", "   #", "   #", "   #");
            RandomPatternCreator.generatePattern("#   ", "#   ", "#   ", "####");
            RandomPatternCreator.generatePattern("   #", "   #", "   #", "####");
            RandomPatternCreator.generatePattern(" ###", "#   ", "#   ", "#   ");
            RandomPatternCreator.generatePattern("### ", "   #", "   #", "   #");
            RandomPatternCreator.generatePattern("#   ", "#   ", "#   ", " ###");
            RandomPatternCreator.generatePattern("   #", "   #", "   #", "### ");
            RandomPatternCreator.generatePattern("####", "#  #", "#  #", "####");
            RandomPatternCreator.generatePattern(" ## ", "#  #", "#  #", " ## ");
            RandomPatternCreator.generatePattern("#  #", " ## ", " ## ", "#  #");
            RandomPatternCreator.generatePattern("#   #", "     ", "     ", "     ", "#   #");
            RandomPatternCreator.generatePattern("#   #", " # # ", "  #  ", " # # ", "#   #");
            RandomPatternCreator.generatePattern("#   #", " ### ", " ### ", " ### ", "#   #");
            RandomPatternCreator.generatePattern("## ##", "#   #", "     ", "#   #", "## ##");
            RandomPatternCreator.generatePattern("#####", "#   #", "#   #", "#   #", "#####");
            RandomPatternCreator.generatePattern("#    #", "      ", "      ", "      ", "      ", "#    #");
            RandomPatternCreator.generatePattern("#    #", " #  # ", "  ##  ", "  ##  ", " #  # ", "#    #");
            RandomPatternCreator.generatePattern("##  ##", "#    #", "      ", "      ", "#    #", "##  ##");
            RandomPatternCreator.generatePattern("##  ##", "##  ##", "      ", "      ", "##  ##", "##  ##");
            RandomPatternCreator.generatePattern("######", "#    #", "#    #", "#    #", "#    #", "######");
            System.out.println("Generated patterns: " + PATTERNS.size());
        }
        return PATTERNS;
    }

    private static void generatePattern(String ... pattern) {
        for (int y = 0; y <= 6 - pattern.length; ++y) {
            for (int x = 0; x <= 6 - pattern[0].length(); ++x) {
                String[] ppp = new String[6];
                for (int py = 0; py < 6; ++py) {
                    StringBuilder pat = new StringBuilder();
                    if (py < y) {
                        pat = new StringBuilder("      ");
                    } else if (py >= y + pattern.length) {
                        pat = new StringBuilder("      ");
                    } else {
                        for (int px = 0; px < 6; ++px) {
                            if (px < x) {
                                pat.append(" ");
                                continue;
                            }
                            if (px >= x + pattern[0].length()) {
                                pat.append(" ");
                                continue;
                            }
                            pat.append(pattern[py - y].charAt(px - x));
                        }
                    }
                    ppp[py] = pat.toString();
                }
                PATTERNS.add(ppp);
            }
        }
    }

    private static SelectedPattern findUnusedPattern(Set<SelectedPattern> alreadyUsed, Supplier<SelectedPattern> generator) {
        SelectedPattern pattern = generator.get();
        while (alreadyUsed.contains(pattern)) {
            pattern = generator.get();
        }
        alreadyUsed.add(pattern);
        return pattern;
    }

    private static void applyPattern(PatternBuilder builder, String[] pattern, char c) {
        for (int y = 0; y < pattern.length; ++y) {
            for (int x = 0; x < pattern[y].length(); ++x) {
                char p = pattern[y].charAt(x);
                if (p != '#') continue;
                builder.set(x, y, c);
            }
        }
    }

    private static DimletPattern buildPattern(SelectedPattern selectedPattern) {
        int i4;
        int i3;
        PatternBuilder builder = new PatternBuilder();
        List<String[]> patterns = RandomPatternCreator.getPatterns();
        int i1 = selectedPattern.i1();
        RandomPatternCreator.applyPattern(builder, patterns.get(i1), '*');
        int i2 = selectedPattern.i2();
        if (i2 != -1) {
            RandomPatternCreator.applyPattern(builder, patterns.get(i2), '0');
        }
        if ((i3 = selectedPattern.i3()) != -1) {
            RandomPatternCreator.applyPattern(builder, patterns.get(i3), '1');
        }
        if ((i4 = selectedPattern.i4()) != -1) {
            RandomPatternCreator.applyPattern(builder, patterns.get(i4), '2');
        }
        return builder.build();
    }

    public static Map<KnowledgeKey, DimletPattern> createRandomPatterns(long seed) {
        HashSet<SelectedPattern> selectedPatterns = new HashSet<SelectedPattern>();
        HashMap<KnowledgeKey, SelectedPattern> patternMap = new HashMap<KnowledgeKey, SelectedPattern>();
        Random random = new Random(seed);
        random.nextInt();
        random.nextInt();
        for (KnowledgeSet set : KnowledgeSet.values()) {
            for (DimletType type : DimletType.values()) {
                SelectedPattern pattern0 = RandomPatternCreator.findUnusedPattern(selectedPatterns, () -> new SelectedPattern(RandomPatternCreator.r(random), -1, -1, -1));
                patternMap.put(new KnowledgeKey(type, DimletRarity.COMMON, set), pattern0);
                SelectedPattern pattern1 = RandomPatternCreator.findUnusedPattern(selectedPatterns, () -> new SelectedPattern(RandomPatternCreator.r(random), RandomPatternCreator.r(random), -1, -1));
                patternMap.put(new KnowledgeKey(type, DimletRarity.UNCOMMON, set), pattern1);
                SelectedPattern pattern2 = RandomPatternCreator.findUnusedPattern(selectedPatterns, () -> new SelectedPattern(RandomPatternCreator.r(random), RandomPatternCreator.r(random), RandomPatternCreator.r(random), -1));
                patternMap.put(new KnowledgeKey(type, DimletRarity.RARE, set), pattern2);
                SelectedPattern pattern3 = RandomPatternCreator.findUnusedPattern(selectedPatterns, () -> new SelectedPattern(RandomPatternCreator.r(random), RandomPatternCreator.r(random), RandomPatternCreator.r(random), RandomPatternCreator.r(random)));
                patternMap.put(new KnowledgeKey(type, DimletRarity.LEGENDARY, set), pattern3);
            }
        }
        HashMap<KnowledgeKey, DimletPattern> patterns = new HashMap<KnowledgeKey, DimletPattern>();
        for (Map.Entry entry : patternMap.entrySet()) {
            SelectedPattern selectedPattern = (SelectedPattern)entry.getValue();
            patterns.put((KnowledgeKey)entry.getKey(), RandomPatternCreator.buildPattern(selectedPattern));
        }
        return patterns;
    }

    private static int r(Random random) {
        return random.nextInt(RandomPatternCreator.getPatterns().size());
    }

    public static void main(String[] args) {
        int idx = 1;
        for (String[] pattern : RandomPatternCreator.getPatterns()) {
            System.out.println("Pattern " + idx);
            for (String s : pattern) {
                System.out.println("    " + s.replace(' ', '.'));
            }
            ++idx;
        }
    }

    private record SelectedPattern(int i1, int i2, int i3, int i4) {
    }
}

