/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimensionbuilder.blocks;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.Sync;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsdim.compat.RFToolsUtilityCompat;
import mcjty.rftoolsdim.dimension.data.DimensionCreator;
import mcjty.rftoolsdim.dimension.data.DimensionData;
import mcjty.rftoolsdim.dimension.data.PersistantDimensionManager;
import mcjty.rftoolsdim.dimension.descriptor.CompiledDescriptor;
import mcjty.rftoolsdim.dimension.descriptor.DimensionDescriptor;
import mcjty.rftoolsdim.dimension.power.PowerHandler;
import mcjty.rftoolsdim.modules.dimensionbuilder.DimensionBuilderConfig;
import mcjty.rftoolsdim.modules.dimensionbuilder.DimensionBuilderModule;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;

public class DimensionBuilderTileEntity
extends TickingTileEntity {
    @GuiValue
    private int errorMode = 0;
    public static final int SLOT_DIMENSION_TAB = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).slot(SlotDefinition.specific(DimensionBuilderTileEntity::isRealizedTab).in().out(), 0, 28, 24).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((slot, stack) -> DimensionBuilderTileEntity.isRealizedTab(stack)).build();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)DimensionBuilderConfig.BUILDER_MAXENERGY.get()).intValue(), (long)((Integer)DimensionBuilderConfig.BUILDER_RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.CONTAINER)
    private final Lazy<MenuProvider> screenHandler = Lazy.of(() -> new DefaultContainerProvider("Dimension Builder").containerSupplier(DefaultContainerProvider.container(DimensionBuilderModule.CONTAINER_DIMENSION_BUILDER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).integerListener(Sync.integer(this::getBuildPercentage, v -> {
        this.clientBuildPercentage = v;
    })).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.INFUSABLE)
    private final IInfusable infusableHandler = new DefaultInfusable((BlockEntity)this);
    private int clientBuildPercentage = 0;
    private int state = 0;
    public static final short OK = 0;
    public static final short ERROR_NOOWNER = -1;
    public static final short ERROR_TOOMANYDIMENSIONS = -2;
    public static final short ERROR_COLLISION = -3;
    private static final Random random = new Random();

    public DimensionBuilderTileEntity(BlockPos pos, BlockState state) {
        super(DimensionBuilderModule.TYPE_DIMENSION_BUILDER.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(DimensionBuilderTileEntity::new).infusable().manualEntry(ManualHelper.create((String)"rftoolsdim:dimensions/dimension_builder")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()})){

            public RotationType getRotationType() {
                return RotationType.ROTATION;
            }
        };
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbtTag = new CompoundTag();
        this.saveClientDataToNBT(nbtTag);
        nbtTag.m_128405_("errorMode", this.errorMode);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        updateTag.m_128405_("errorMode", this.errorMode);
        return updateTag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        int oldstate = this.state;
        int oldError = this.errorMode;
        super.onDataPacket(net, packet);
        this.errorMode = (short)packet.m_131708_().m_128451_("errorMode");
        if (oldstate != this.state || oldError != this.errorMode) {
            this.m_58904_().m_6550_(this.f_58858_, this.m_58900_(), this.m_58900_());
        }
    }

    public void tickServer() {
        CompoundTag tagCompound = this.hasTab();
        if (tagCompound == null) {
            this.setState(-1);
            return;
        }
        if (!this.isMachineEnabled()) {
            this.setState(-1);
            return;
        }
        int ticksLeft = tagCompound.m_128451_("ticksLeft");
        if (ticksLeft > 0) {
            ticksLeft = this.createDimensionTick(tagCompound, ticksLeft);
        } else {
            this.maintainDimensionTick(tagCompound);
        }
        this.setState(ticksLeft);
    }

    private void maintainDimensionTick(CompoundTag tagCompound) {
        if (tagCompound.m_128441_("dimension")) {
            String dimension = tagCompound.m_128461_("dimension");
            ResourceLocation id = new ResourceLocation(dimension);
            DimensionData data = PersistantDimensionManager.get(this.f_58857_).getData(id);
            if (data == null) {
                return;
            }
            long rf = this.energyStorage.getEnergy();
            long energy = data.getEnergy();
            long maxEnergy = PowerHandler.calculateMaxDimensionPower(id, this.f_58857_) - energy;
            if (rf > maxEnergy) {
                rf = maxEnergy;
            }
            this.energyStorage.consumeEnergy(rf);
            data.setEnergy(this.f_58857_, energy + rf);
            PersistantDimensionManager.get(this.f_58857_).save();
        }
    }

    private int createDimensionTick(CompoundTag tagCompound, int ticksLeft) {
        this.errorMode = 0;
        String name = tagCompound.m_128461_("name");
        DimensionCreator.get().markReservedName(this.f_58857_, this.f_58858_, name);
        int createCost = tagCompound.m_128451_("rfCreateCost");
        float inf = this.infusableHandler.getInfusedFactor();
        createCost = (int)((float)createCost * (2.0f - inf) / 2.0f);
        if (this.isCheaterDimension(tagCompound) || this.energyStorage.getEnergyStored() >= createCost) {
            if (!DimensionCreator.get().isNameAvailable(this.f_58857_, this.f_58858_, name)) {
                this.errorMode = -3;
                this.m_6596_();
                return ticksLeft;
            }
            if (this.isCheaterDimension(tagCompound)) {
                ticksLeft = 0;
            } else {
                this.energyStorage.consumeEnergy((long)createCost);
                --ticksLeft;
                if (random.nextFloat() < inf && --ticksLeft < 0) {
                    ticksLeft = 0;
                }
            }
            tagCompound.m_128405_("ticksLeft", ticksLeft);
            if (ticksLeft <= 0) {
                String descriptorString = tagCompound.m_128461_("descriptor");
                DimensionDescriptor descriptor = new DimensionDescriptor();
                descriptor.read(descriptorString);
                DimensionDescriptor randomizedDescriptor = descriptor.createRandomizedDescriptor(random);
                if (!DimensionCreator.get().isNameAvailable(this.f_58857_, this.f_58858_, name)) {
                    this.errorMode = -3;
                    this.m_6596_();
                    return 0;
                }
                if (!DimensionCreator.get().isDescriptorAvailable(this.f_58857_, descriptor)) {
                    this.errorMode = -3;
                    this.m_6596_();
                    return 0;
                }
                long seed = random.nextLong();
                ServerLevel newworld = DimensionCreator.get().createWorld(this.f_58857_, name, seed, descriptor, randomizedDescriptor, this.getOwnerUUID());
                ResourceLocation id = new ResourceLocation("rftoolsdim", name);
                tagCompound.m_128359_("dimension", id.toString());
                CompiledDescriptor compiledDescriptor = DimensionCreator.get().getCompiledDescriptor((Level)newworld);
                tagCompound.m_128405_("rfMaintainCost", compiledDescriptor.getActualPowerCost());
                this.m_6596_();
                this.placeMatterReceiver(newworld, name);
            }
        }
        return ticksLeft;
    }

    private void placeMatterReceiver(ServerLevel newworld, String name) {
        for (int y = newworld.m_151558_() - 10; y >= newworld.m_141937_() + 1; --y) {
            if (newworld.m_8055_(new BlockPos(8, y, 8)).m_60734_() != Blocks.f_50272_) continue;
            RFToolsUtilityCompat.createTeleporter((WorldGenLevel)newworld, new BlockPos(8, y, 8), name);
            return;
        }
        int platformHeight = DimensionCreator.get().getPlatformHeight(newworld.m_46472_().m_135782_());
        RFToolsUtilityCompat.createTeleporter((WorldGenLevel)newworld, new BlockPos(8, platformHeight, 8), name);
        newworld.m_46597_(new BlockPos(8, platformHeight + 1, 8), Blocks.f_50016_.m_49966_());
        newworld.m_46597_(new BlockPos(8, platformHeight + 2, 8), Blocks.f_50016_.m_49966_());
    }

    private boolean isCheaterDimension(CompoundTag tag) {
        return false;
    }

    public OperationType getState() {
        return OperationType.values()[this.state];
    }

    private void setState(int ticksLeft) {
        int oldstate = this.state;
        this.state = ticksLeft == 0 ? 0 : (ticksLeft == -1 ? 1 : ((ticksLeft >> 2 & 1) == 0 ? 2 : 3));
        if (oldstate != this.state) {
            this.m_6596_();
        }
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        this.loadItemHandlerCap(tagCompound);
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        this.saveItemHandlerCap(tagCompound);
    }

    public CompoundTag hasTab() {
        ItemStack itemStack = this.items.getStackInSlot(0);
        if (itemStack.m_41619_()) {
            return null;
        }
        return itemStack.m_41783_();
    }

    public int getBuildPercentage() {
        if (this.f_58857_.f_46443_) {
            return this.clientBuildPercentage;
        }
        CompoundTag tag = this.hasTab();
        if (tag != null) {
            int ticksLeft = tag.m_128451_("ticksLeft");
            int tickCost = tag.m_128451_("tickCost");
            if (tickCost == 0) {
                return 0;
            }
            return (tickCost - ticksLeft) * 100 / tickCost;
        }
        return 0;
    }

    public int getErrorMode() {
        return this.errorMode;
    }

    public static boolean isRealizedTab(ItemStack stack) {
        return stack.m_41720_() == DimensionBuilderModule.REALIZED_DIMENSION_TAB.get();
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public static enum OperationType implements StringRepresentable
    {
        CHARGING("charging"),
        EMPTY("empty"),
        BUILDING1("building1"),
        BUILDING2("building2");

        private final String name;

        private OperationType(String name) {
            this.name = name;
        }

        @Nonnull
        public String m_7912_() {
            return this.name;
        }
    }
}

