/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.tools;

import java.util.HashSet;
import java.util.Set;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.rftoolsdim.setup.RFToolsDimMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public record PacketSyncDimensionListChanges(Set<ResourceKey<Level>> newDimensions, Set<ResourceKey<Level>> removedDimensions) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("rftoolsdim", "syncdimensionlistchanges");

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.newDimensions.size());
        for (ResourceKey<Level> key : this.newDimensions) {
            buf.m_130085_(key.m_135782_());
        }
        buf.m_130130_(this.removedDimensions.size());
        for (ResourceKey<Level> key : this.removedDimensions) {
            buf.m_130085_(key.m_135782_());
        }
    }

    public ResourceLocation id() {
        return ID;
    }

    public static PacketSyncDimensionListChanges create(FriendlyByteBuf buf) {
        HashSet<ResourceKey<Level>> newDimensions = new HashSet<ResourceKey<Level>>();
        HashSet<ResourceKey<Level>> removedDimensions = new HashSet<ResourceKey<Level>>();
        int newDimensionCount = buf.m_130242_();
        for (int i = 0; i < newDimensionCount; ++i) {
            ResourceLocation worldID = buf.m_130281_();
            newDimensions.add(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)worldID));
        }
        int removedDimensionCount = buf.m_130242_();
        for (int i = 0; i < removedDimensionCount; ++i) {
            ResourceLocation worldID = buf.m_130281_();
            removedDimensions.add((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)worldID));
        }
        return new PacketSyncDimensionListChanges(newDimensions, removedDimensions);
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                Set commandSuggesterLevels = player.f_108617_.m_105151_();
                commandSuggesterLevels.addAll(this.newDimensions);
                for (ResourceKey<Level> key : this.removedDimensions) {
                    commandSuggesterLevels.remove(key);
                }
            }
        });
    }

    public static void updateClientDimensionLists(Set<ResourceKey<Level>> newDimensions, Set<ResourceKey<Level>> removedDimensions) {
        RFToolsDimMessages.sendToAll(new PacketSyncDimensionListChanges(newDimensions, removedDimensions));
    }
}

