/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension;

import java.util.HashMap;
import java.util.Map;
import mcjty.rftoolsdim.dimension.DimensionRegistry;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeSet;
import net.minecraft.resources.ResourceLocation;

public enum TimeType {
    NORMAL("normal", KnowledgeSet.SET1, DimensionRegistry.NORMAL_TIME_ID),
    DAY("day", KnowledgeSet.SET2, DimensionRegistry.FIXED_DAY_ID),
    NIGHT("night", KnowledgeSet.SET2, DimensionRegistry.FIXED_NIGHT_ID);

    private final String name;
    private final KnowledgeSet set;
    private final ResourceLocation dimensionType;
    private static final Map<String, TimeType> TYPE_BY_NAME;

    private TimeType(String name, KnowledgeSet set, ResourceLocation dimensionType) {
        this.name = name;
        this.set = set;
        this.dimensionType = dimensionType;
    }

    public String getName() {
        return this.name;
    }

    public KnowledgeSet getSet() {
        return this.set;
    }

    public ResourceLocation getDimensionType() {
        return this.dimensionType;
    }

    public static TimeType byName(String name) {
        return TYPE_BY_NAME.get(name.toLowerCase());
    }

    static {
        TYPE_BY_NAME = new HashMap<String, TimeType>();
        for (TimeType type : TimeType.values()) {
            TYPE_BY_NAME.put(type.getName(), type);
        }
    }
}

