/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.worlddata.AbstractWorldData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class SpaceChamberRepository
extends AbstractWorldData<SpaceChamberRepository> {
    private static final String SPACECHAMBER_CHANNELS_NAME = "RFToolsSpaceChambers";
    private int lastId = 0;
    private final Map<Integer, SpaceChamberChannel> channels = new HashMap<Integer, SpaceChamberChannel>();

    public SpaceChamberRepository() {
    }

    public SpaceChamberRepository(CompoundTag tag) {
        ListTag lst = tag.m_128437_("channels", 10);
        for (int i = 0; i < lst.size(); ++i) {
            CompoundTag tc = lst.m_128728_(i);
            int channel = tc.m_128451_("channel");
            SpaceChamberChannel value = new SpaceChamberChannel();
            value.setDimension((ResourceKey<Level>)LevelTools.getId((String)tc.m_128461_("dimension")));
            value.setMinCorner(BlockPosTools.read((CompoundTag)tc, (String)"minCorner"));
            value.setMaxCorner(BlockPosTools.read((CompoundTag)tc, (String)"maxCorner"));
            this.channels.put(channel, value);
        }
        this.lastId = tag.m_128451_("lastId");
    }

    public static SpaceChamberRepository get(Level world) {
        return (SpaceChamberRepository)SpaceChamberRepository.getData((Level)world, SpaceChamberRepository::new, SpaceChamberRepository::new, (String)SPACECHAMBER_CHANNELS_NAME);
    }

    public SpaceChamberChannel getOrCreateChannel(int id) {
        SpaceChamberChannel channel = this.channels.get(id);
        if (channel == null) {
            channel = new SpaceChamberChannel();
            this.channels.put(id, channel);
        }
        return channel;
    }

    public SpaceChamberChannel getChannel(int id) {
        return this.channels.get(id);
    }

    public void deleteChannel(int id) {
        this.channels.remove(id);
    }

    public int newChannel() {
        ++this.lastId;
        return this.lastId;
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag tagCompound) {
        ListTag lst = new ListTag();
        for (Map.Entry<Integer, SpaceChamberChannel> entry : this.channels.entrySet()) {
            CompoundTag tc = new CompoundTag();
            tc.m_128405_("channel", entry.getKey().intValue());
            tc.m_128359_("dimension", entry.getValue().getDimension().m_135782_().toString());
            BlockPosTools.write((CompoundTag)tc, (String)"minCorner", (BlockPos)entry.getValue().getMinCorner());
            BlockPosTools.write((CompoundTag)tc, (String)"maxCorner", (BlockPos)entry.getValue().getMaxCorner());
            lst.add((Object)tc);
        }
        tagCompound.m_128365_("channels", (Tag)lst);
        tagCompound.m_128405_("lastId", this.lastId);
        return tagCompound;
    }

    public static class SpaceChamberChannel {
        private ResourceKey<Level> dimension;
        private BlockPos minCorner = null;
        private BlockPos maxCorner = null;

        public ResourceKey<Level> getDimension() {
            return this.dimension;
        }

        public void setDimension(ResourceKey<Level> dimension) {
            this.dimension = dimension;
        }

        public BlockPos getMinCorner() {
            return this.minCorner;
        }

        public void setMinCorner(BlockPos minCorner) {
            this.minCorner = minCorner;
        }

        public BlockPos getMaxCorner() {
            return this.maxCorner;
        }

        public void setMaxCorner(BlockPos maxCorner) {
            this.maxCorner = maxCorner;
        }
    }
}

