/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.gl46.batching;

import net.minecraft.client.renderer.RenderType;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.quartz.internal.common.InternalMesh;
import net.roguelogix.quartz.internal.gl46.batching.GL46InstanceManager;
import net.roguelogix.quartz.internal.util.IndirectDrawInfo;
import net.roguelogix.quartz.internal.util.VertexFormatOutput;

@NonnullDefault
public class GL46DrawChunk {
    private final GL46InstanceManager manager;
    final RenderType renderType;
    private final VertexFormatOutput outputFormat;
    public final int baseVertex;
    public final int vertexCount;
    int drawIndex;

    GL46DrawChunk(GL46InstanceManager manager, RenderType renderType, InternalMesh.Manager.TrackedMesh.Component component) {
        this.manager = manager;
        this.renderType = renderType;
        this.outputFormat = VertexFormatOutput.of(renderType.m_110508_());
        this.baseVertex = component.vertexOffset();
        this.vertexCount = component.vertexCount();
    }

    public IndirectDrawInfo indirectDrawInfo(int frame) {
        return new IndirectDrawInfo(this.vertexCount, this.manager.instanceCount(), this.baseVertex, this.manager.baseInstance(frame));
    }

    public int totalVertices() {
        return this.manager.instanceCount() * this.vertexCount;
    }
}

