/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.gl46;

import java.nio.IntBuffer;
import net.roguelogix.quartz.internal.QuartzCore;
import net.roguelogix.quartz.internal.gl46.GL46Config;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.MemoryStack;

public class GL46Statics {
    public static final boolean AVAILABLE;
    public static final boolean ALLOW_SPARSE_TEXTURE;
    public static final boolean SPARSE_TEXTURE_ENABLED;
    public static final int FRAMES_IN_FLIGHT = 3;
    public static final Vector3ic LIGHT_SPARE_TEXTURE_SIZE;
    public static final int LIGHT_TEXTURE_BLOCK_DEPTH = 32;
    public static final int INSTANCE_DATA_BYTE_SIZE = 128;
    public static final int STATIC_MATRIX_OFFSET = 0;
    public static final int STATIC_NORMAL_MATRIX_OFFSET = 64;
    public static final int WORLD_POSITION_OFFSET = 112;
    public static final int DYNAMIC_MATRIX_ID_OFFSET = 124;
    public static final int POSITION_LOCATION = 0;
    public static final int COLOR_LOCATION = 1;
    public static final int TEX_COORD_LOCATION = 2;
    public static final int NORMAL_LOCATION = 3;
    public static final int WORLD_POSITION_LOCATION = 4;
    public static final int DYNAMIC_MATRIX_ID_LOCATION = 5;
    public static final int STATIC_MATRIX_LOCATION = 8;
    public static final int STATIC_NORMAL_MATRIX_LOCATION = 12;

    private static boolean checkRequirements() {
        GLCapabilities capabilities = GL.getCapabilities();
        if (!capabilities.OpenGL45) {
            QuartzCore.LOGGER.debug("Failure, OpenGL 4.5 not found");
            return false;
        }
        if (!SPARSE_TEXTURE_ENABLED) {
            QuartzCore.LOGGER.info("Sparse texture disabled");
        }
        return true;
    }

    private static boolean checkSparseTextureSupport() {
        GLCapabilities capabilities = GL.getCapabilities();
        if (!ALLOW_SPARSE_TEXTURE) {
            QuartzCore.LOGGER.debug("Sparse texture disabled");
            return false;
        }
        if (!capabilities.GL_ARB_sparse_texture) {
            QuartzCore.LOGGER.debug("Sparse texture extension unavailable");
            return false;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            int format = 33332;
            int pageSizeCount = GL45C.glGetInternalformati((int)35866, (int)33332, (int)37288);
            if (pageSizeCount == 0) {
                QuartzCore.LOGGER.debug("Sparse texture no page sizes for RG16UI");
                boolean bl = false;
                return bl;
            }
            IntBuffer sizesX = stack.mallocInt(pageSizeCount);
            IntBuffer sizesY = stack.mallocInt(pageSizeCount);
            IntBuffer sizesZ = stack.mallocInt(pageSizeCount);
            GL45C.glGetInternalformativ((int)35866, (int)33332, (int)37269, (IntBuffer)sizesX);
            GL45C.glGetInternalformativ((int)35866, (int)33332, (int)37270, (IntBuffer)sizesY);
            GL45C.glGetInternalformativ((int)35866, (int)33332, (int)37271, (IntBuffer)sizesZ);
            boolean foundSize = false;
            for (int i = 0; i < pageSizeCount; ++i) {
                int xSize = sizesX.get(i);
                int ySize = sizesY.get(i);
                int zSize = sizesZ.get(i);
                if (LIGHT_SPARE_TEXTURE_SIZE.x() % xSize != 0 || LIGHT_SPARE_TEXTURE_SIZE.y() % ySize != 0 || 1 % zSize != 0) continue;
                foundSize = true;
                break;
            }
            if (!foundSize) {
                QuartzCore.LOGGER.debug("Sparse texture no viable page size found for RG16UI");
            } else {
                QuartzCore.LOGGER.debug("Sparse texture available");
            }
            boolean bl = foundSize;
            return bl;
        }
    }

    static {
        ALLOW_SPARSE_TEXTURE = GL46Config.INSTANCE.ALLOW_SPARSE_TEXTURE;
        LIGHT_SPARE_TEXTURE_SIZE = new Vector3i(512, 640, 1024);
        QuartzCore.LOGGER.debug("Capability checking GL46Core");
        SPARSE_TEXTURE_ENABLED = GL46Statics.checkSparseTextureSupport();
        AVAILABLE = GL46Statics.checkRequirements();
        if (AVAILABLE) {
            QuartzCore.LOGGER.debug("GL46Core available");
            if (!SPARSE_TEXTURE_ENABLED) {
                QuartzCore.LOGGER.warn("Sparse texture disabled, this will massively increase minimum vram requirements for lighting");
            }
        }
    }
}

