/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.gl46;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.roguelogix.quartz.DrawBatch;
import net.roguelogix.quartz.internal.Buffer;
import net.roguelogix.quartz.internal.IrisDetection;
import net.roguelogix.quartz.internal.MultiBuffer;
import net.roguelogix.quartz.internal.QuartzCore;
import net.roguelogix.quartz.internal.common.B3DStateHelper;
import net.roguelogix.quartz.internal.gl46.GL46Buffer;
import net.roguelogix.quartz.internal.gl46.GL46ComputePrograms;
import net.roguelogix.quartz.internal.gl46.GL46Core;
import net.roguelogix.quartz.internal.gl46.GL46FeedbackPrograms;
import net.roguelogix.quartz.internal.gl46.GL46LightEngine;
import net.roguelogix.quartz.internal.gl46.batching.GL46DrawBatch;
import net.roguelogix.quartz.internal.util.PointerWrapper;
import net.roguelogix.quartz.internal.util.ShitMojangShouldHaveButDoesnt;
import net.roguelogix.quartz.internal.util.VertexFormatOutput;
import org.joml.Matrix4f;
import org.joml.Vector3fc;
import org.joml.Vector3ic;
import org.lwjgl.opengl.GL45C;

public class GL46FeedbackDrawing {
    private static final ReferenceArrayList<WeakReference<GL46DrawBatch>> drawBatches = new ReferenceArrayList();
    private static final Reference2IntMap<RenderType> renderTypeUsages = new Reference2IntArrayMap();
    private static final Reference2IntMap<RenderType> renderTypeDrawnVertices = new Reference2IntArrayMap();
    private static final ReferenceArrayList<RenderType> inUseRenderTypes = new ReferenceArrayList();
    private static int feedbackVAO;
    private static final Object2ObjectMap<RenderType, FeedbackBuffer> renderTypeFeedbackBuffers;
    private static Buffer.CallbackHandle rebuildCallbackHandle;
    private static int requiredVertices;
    private static long[] prevousFrameSyncs;
    private static MultiBuffer<GL46Buffer> UBOBuffers;
    private static MultiBuffer.Allocation UBOAllocation;
    private static Matrix4f projection;
    private static Matrix4f modelView;

    public static DrawBatch createDrawBatch() {
        GL46DrawBatch batcher = new GL46DrawBatch();
        WeakReference<GL46DrawBatch> ref = new WeakReference<GL46DrawBatch>(batcher);
        drawBatches.add(ref);
        QuartzCore.mainThreadClean(batcher, () -> drawBatches.remove((Object)ref));
        return batcher;
    }

    public static void startup() {
        if (rebuildCallbackHandle != null) {
            rebuildCallbackHandle.delete();
            rebuildCallbackHandle = null;
        }
        feedbackVAO = GL45C.glCreateVertexArrays();
        B3DStateHelper.bindVertexArray(feedbackVAO);
        rebuildCallbackHandle = QuartzCore.INSTANCE.meshManager.vertexBuffer.addReallocCallback(true, buffer -> GL45C.glVertexArrayVertexBuffer((int)feedbackVAO, (int)0, (int)buffer.as(GL46Buffer.class).handle(), (long)0L, (int)32));
        GL45C.glVertexAttribDivisor((int)1, (int)1);
        GL45C.glEnableVertexAttribArray((int)0);
        GL45C.glEnableVertexAttribArray((int)1);
        GL45C.glEnableVertexAttribArray((int)2);
        GL45C.glEnableVertexAttribArray((int)3);
        GL45C.glEnableVertexAttribArray((int)4);
        GL45C.glEnableVertexAttribArray((int)5);
        GL45C.glEnableVertexAttribArray((int)8);
        GL45C.glEnableVertexAttribArray((int)9);
        GL45C.glEnableVertexAttribArray((int)10);
        GL45C.glEnableVertexAttribArray((int)11);
        GL45C.glEnableVertexAttribArray((int)12);
        GL45C.glEnableVertexAttribArray((int)13);
        GL45C.glEnableVertexAttribArray((int)14);
        GL45C.glVertexAttribBinding((int)0, (int)0);
        GL45C.glVertexAttribBinding((int)1, (int)0);
        GL45C.glVertexAttribBinding((int)2, (int)0);
        GL45C.glVertexAttribBinding((int)3, (int)0);
        GL45C.glVertexAttribFormat((int)0, (int)3, (int)5126, (boolean)false, (int)0);
        GL45C.glVertexAttribIFormat((int)1, (int)1, (int)5124, (int)12);
        GL45C.glVertexAttribFormat((int)2, (int)2, (int)5126, (boolean)false, (int)16);
        GL45C.glVertexAttribFormat((int)3, (int)3, (int)5122, (boolean)true, (int)24);
        GL45C.glVertexAttribBinding((int)4, (int)1);
        GL45C.glVertexAttribBinding((int)5, (int)1);
        GL45C.glVertexAttribBinding((int)8, (int)1);
        GL45C.glVertexAttribBinding((int)9, (int)1);
        GL45C.glVertexAttribBinding((int)10, (int)1);
        GL45C.glVertexAttribBinding((int)11, (int)1);
        GL45C.glVertexAttribBinding((int)12, (int)1);
        GL45C.glVertexAttribBinding((int)13, (int)1);
        GL45C.glVertexAttribBinding((int)14, (int)1);
        GL45C.glVertexAttribIFormat((int)4, (int)3, (int)5124, (int)112);
        GL45C.glVertexAttribIFormat((int)5, (int)1, (int)5124, (int)124);
        GL45C.glVertexAttribFormat((int)8, (int)4, (int)5126, (boolean)false, (int)0);
        GL45C.glVertexAttribFormat((int)9, (int)4, (int)5126, (boolean)false, (int)16);
        GL45C.glVertexAttribFormat((int)10, (int)4, (int)5126, (boolean)false, (int)32);
        GL45C.glVertexAttribFormat((int)11, (int)4, (int)5126, (boolean)false, (int)48);
        GL45C.glVertexAttribFormat((int)12, (int)4, (int)5126, (boolean)false, (int)64);
        GL45C.glVertexAttribFormat((int)13, (int)4, (int)5126, (boolean)false, (int)80);
        GL45C.glVertexAttribFormat((int)14, (int)4, (int)5126, (boolean)false, (int)96);
        B3DStateHelper.bindVertexArray(0);
    }

    public static void shutdown() {
        GL45C.glDeleteVertexArrays((int)feedbackVAO);
        renderTypeFeedbackBuffers.values().forEach(FeedbackBuffer::delete);
        rebuildCallbackHandle.delete();
        rebuildCallbackHandle = null;
    }

    public static void addRenderTypeUse(RenderType renderType) {
        if (renderTypeUsages.put((Object)renderType, renderTypeUsages.getOrDefault((Object)renderType, 0) + 1) == 0) {
            inUseRenderTypes.add((Object)renderType);
        }
    }

    public static void removeRenderTypeUse(RenderType renderType) {
        int usages = renderTypeUsages.getInt((Object)renderType);
        if (usages == 1) {
            renderTypeUsages.removeInt((Object)renderType);
            inUseRenderTypes.remove((Object)renderType);
            FeedbackBuffer feedbackBuffer = (FeedbackBuffer)renderTypeFeedbackBuffers.remove((Object)renderType);
            if (feedbackBuffer != null) {
                feedbackBuffer.delete();
            }
            return;
        }
        renderTypeUsages.put((Object)renderType, usages - 1);
    }

    public static List<RenderType> getActiveRenderTypes() {
        return inUseRenderTypes;
    }

    public static boolean hasBatch() {
        return !drawBatches.isEmpty();
    }

    public static void aboutToBeginFrame() {
        int frameInFlight = GL46Core.INSTANCE.frameInFlight();
        if (prevousFrameSyncs[frameInFlight] != 0L) {
            GL45C.glClientWaitSync((long)prevousFrameSyncs[frameInFlight], (int)1, (long)-1L);
            GL45C.glDeleteSync((long)prevousFrameSyncs[frameInFlight]);
            GL46FeedbackDrawing.prevousFrameSyncs[frameInFlight] = 0L;
        }
    }

    public static void beginFrame() {
        for (int i = 0; i < 2; ++i) {
            RenderSystem.activeTexture((int)(33984 + i));
            RenderSystem.bindTexture((int)0);
        }
        RenderSystem.activeTexture((int)33984);
        B3DStateHelper.bindVertexArray(0);
        B3DStateHelper.bindElementBuffer(0);
        GL45C.glUseProgram((int)GL46ComputePrograms.dynamicMatrixProgram());
        for (WeakReference batchRef : drawBatches) {
            GL46DrawBatch batch = (GL46DrawBatch)batchRef.get();
            if (batch == null) {
                return;
            }
            batch.updateAndCull(GL46Core.INSTANCE.drawInfo);
        }
        GL45C.glBindBufferBase((int)37074, (int)0, (int)0);
        GL45C.glBindBufferBase((int)37074, (int)1, (int)0);
        GL45C.glBindBufferBase((int)37074, (int)2, (int)0);
        GL45C.glUseProgram((int)0);
        GL45C.glMemoryBarrier((int)1);
    }

    public static void collectAllFeedback(boolean shadowsEnabled) {
        int frameInFlight = GL46Core.INSTANCE.frameInFlight();
        UBOBuffers.setActiveFrame(frameInFlight);
        PointerWrapper UBOPointer = UBOAllocation.activeAllocation().address();
        UBOPointer.putVector3i(0L, (Vector3ic)GL46Core.INSTANCE.drawInfo.playerPosition);
        UBOPointer.putVector3f(16L, (Vector3fc)GL46Core.INSTANCE.drawInfo.playerSubBlock);
        UBOPointer.putVector3i(32L, GL46LightEngine.lookupOffset());
        UBOPointer.putInt(44L, IrisDetection.areShadersActive() ? 1 : 0);
        GL45C.glBindBufferBase((int)35345, (int)0, (int)UBOBuffers.activeBuffer().handle());
        GL46LightEngine.bind();
        B3DStateHelper.bindVertexArray(feedbackVAO);
        for (RenderType renderType : inUseRenderTypes) {
            WeakReference batchRef2;
            VertexFormatOutput outputFormat = VertexFormatOutput.of(renderType.m_110508_());
            requiredVertices = 0;
            for (WeakReference batchRef2 : drawBatches) {
                GL46DrawBatch drawBatch = (GL46DrawBatch)batchRef2.get();
                if (drawBatch == null) {
                    return;
                }
                requiredVertices += drawBatch.verticesForRenderType(renderType, shadowsEnabled);
            }
            renderTypeDrawnVertices.put((Object)renderType, requiredVertices);
            FeedbackBuffer buffer = (FeedbackBuffer)renderTypeFeedbackBuffers.computeIfAbsent((Object)renderType, e -> new FeedbackBuffer(requiredVertices));
            if (buffer.size < (requiredVertices *= outputFormat.vertexSize())) {
                buffer.delete();
                buffer = new FeedbackBuffer(requiredVertices);
                renderTypeFeedbackBuffers.put((Object)renderType, (Object)buffer);
            }
            GL45C.glUseProgram((int)GL46FeedbackPrograms.getProgramForOutputFormat(outputFormat));
            GL45C.glBindBufferBase((int)35982, (int)0, (int)buffer.buffer);
            GL45C.glBeginTransformFeedback((int)0);
            batchRef2 = drawBatches.iterator();
            while (batchRef2.hasNext()) {
                WeakReference batchRef3 = (WeakReference)batchRef2.next();
                GL46DrawBatch drawBatch = (GL46DrawBatch)batchRef3.get();
                if (drawBatch == null) {
                    return;
                }
                drawBatch.drawFeedback(renderType, shadowsEnabled);
            }
            GL45C.glEndTransformFeedback();
        }
        B3DStateHelper.bindVertexArray(0);
        GL45C.glBindBuffer((int)36671, (int)0);
        GL46LightEngine.unbind();
        GL45C.glBindBufferBase((int)35345, (int)0, (int)0);
        GL45C.glBindBufferBase((int)37074, (int)0, (int)0);
        GL45C.glBindBufferBase((int)35982, (int)0, (int)0);
        long frameSync = GL45C.glFenceSync((int)37143, (int)0);
        for (WeakReference batchRef : drawBatches) {
            GL46DrawBatch drawBatch = (GL46DrawBatch)batchRef.get();
            if (drawBatch == null) {
                return;
            }
            drawBatch.setFrameSync(frameSync);
        }
        GL46FeedbackDrawing.prevousFrameSyncs[frameInFlight] = frameSync;
    }

    public static void setMatrices(Matrix4f projection, Matrix4f modelView) {
        GL46FeedbackDrawing.projection = projection;
        GL46FeedbackDrawing.modelView = modelView;
    }

    public static void drawRenderType(RenderType renderType) {
        FeedbackBuffer feedbackBuffer = (FeedbackBuffer)renderTypeFeedbackBuffers.get((Object)renderType);
        if (feedbackBuffer == null) {
            return;
        }
        int drawnVertices = renderTypeDrawnVertices.getInt((Object)renderType);
        if (drawnVertices == 0) {
            return;
        }
        B3DStateHelper.bindArrayBuffer(feedbackBuffer.buffer);
        ShitMojangShouldHaveButDoesnt.drawRenderTypePreboundVertexBuffer(modelView, projection, renderType, drawnVertices);
    }

    static {
        renderTypeFeedbackBuffers = new Object2ObjectArrayMap();
        requiredVertices = 0;
        prevousFrameSyncs = new long[3];
        UBOBuffers = new MultiBuffer(3, false);
        UBOAllocation = UBOBuffers.alloc(64);
    }

    private record FeedbackBuffer(int buffer, int size) {
        private FeedbackBuffer(int size) {
            this(GL45C.glCreateBuffers(), FeedbackBuffer.roundUpPo2(size));
            GL45C.glNamedBufferStorage((int)this.buffer, (long)this.size, (int)0);
        }

        void delete() {
            GL45C.glDeleteBuffers((int)this.buffer);
        }

        private static int roundUpPo2(int minSize) {
            int size = Integer.highestOneBit(minSize);
            if (size < minSize) {
                size <<= 1;
            }
            return size;
        }
    }
}

