/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.gl46;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.quartz.DrawBatch;
import net.roguelogix.quartz.internal.Buffer;
import net.roguelogix.quartz.internal.IrisDetection;
import net.roguelogix.quartz.internal.QuartzCore;
import net.roguelogix.quartz.internal.common.DrawInfo;
import net.roguelogix.quartz.internal.gl46.GL46Buffer;
import net.roguelogix.quartz.internal.gl46.GL46ComputePrograms;
import net.roguelogix.quartz.internal.gl46.GL46FeedbackDrawing;
import net.roguelogix.quartz.internal.gl46.GL46FeedbackPrograms;
import net.roguelogix.quartz.internal.gl46.GL46LightEngine;
import net.roguelogix.quartz.internal.gl46.GL46Statics;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3fc;
import org.joml.Vector3ic;
import org.lwjgl.opengl.GL46C;
import org.lwjgl.opengl.KHRDebug;

@NonnullDefault
public class GL46Core
extends QuartzCore {
    public static final GL46Core INSTANCE;
    private int frameInFlight;
    private long lastTimeNano = 0L;
    public final DrawInfo drawInfo = new DrawInfo();

    @Override
    protected void startupInternal() {
        GL46ComputePrograms.startup();
        GL46FeedbackPrograms.startup();
        GL46LightEngine.startup();
        GL46FeedbackDrawing.startup();
    }

    @Override
    protected void shutdownInternal() {
        GL46FeedbackDrawing.shutdown();
        GL46LightEngine.shutdown();
        GL46FeedbackPrograms.shutdown();
        GL46ComputePrograms.shutdown();
    }

    @Override
    protected void resourcesReloadedInternal() {
        GL46FeedbackPrograms.reload();
        GL46ComputePrograms.reload();
    }

    @Override
    public DrawBatch createDrawBatch() {
        return GL46FeedbackDrawing.createDrawBatch();
    }

    @Override
    public Buffer allocBuffer(boolean GPUOnly) {
        return new GL46Buffer(GPUOnly);
    }

    @Override
    public void frameStart(PoseStack pMatrixStack, float pPartialTicks, long pFinishTimeNano, boolean pDrawBlockOutline, Camera pActiveRenderInfo, GameRenderer pGameRenderer, LightTexture pLightmap, Matrix4f pProjection) {
        deletionQueue.runAll();
        ++this.frameInFlight;
        this.frameInFlight %= 3;
        GL46FeedbackDrawing.aboutToBeginFrame();
        long timeNanos = System.nanoTime();
        long deltaNano = timeNanos - this.lastTimeNano;
        this.lastTimeNano = timeNanos;
        if (this.lastTimeNano == 0L) {
            deltaNano = 0L;
        }
        Vec3 playerPosition = pActiveRenderInfo.m_90583_();
        this.drawInfo.playerPosition.set((int)playerPosition.f_82479_, (int)playerPosition.f_82480_, (int)playerPosition.f_82481_);
        this.drawInfo.playerPositionNegative.set((Vector3ic)this.drawInfo.playerPosition).negate();
        this.drawInfo.playerSubBlock.set(playerPosition.f_82479_ - (double)((int)playerPosition.f_82479_), playerPosition.f_82480_ - (double)((int)playerPosition.f_82480_), playerPosition.f_82481_ - (double)((int)playerPosition.f_82481_));
        this.drawInfo.playerSubBlockNegative.set((Vector3fc)this.drawInfo.playerSubBlockNegative).negate();
        this.drawInfo.projectionMatrix.set((Matrix4fc)pProjection);
        this.drawInfo.projectionMatrix.mul((Matrix4fc)pMatrixStack.m_85850_().m_252922_());
        this.drawInfo.projectionMatrix.get(this.drawInfo.projectionMatrixFloatBuffer);
        this.drawInfo.mojPose = pMatrixStack.m_85850_();
        this.drawInfo.deltaNano = deltaNano;
        this.drawInfo.partialTicks = pPartialTicks;
        GL46FeedbackDrawing.beginFrame();
    }

    @Override
    public void lightUpdated() {
        GL46LightEngine.update((BlockAndTintGetter)Minecraft.m_91087_().f_91073_);
        if (!GL46FeedbackDrawing.hasBatch()) {
            return;
        }
        GL46FeedbackDrawing.collectAllFeedback(IrisDetection.areShadersActive());
    }

    @Override
    public void preTerrainSetup() {
    }

    @Override
    public void shadowPass(PoseStack modelView, Matrix4f projectionMatrix) {
        if (!GL46FeedbackDrawing.hasBatch()) {
            return;
        }
        GL46FeedbackDrawing.setMatrices(projectionMatrix, modelView.m_85850_().m_252922_());
        GL46FeedbackDrawing.getActiveRenderTypes().forEach(GL46FeedbackDrawing::drawRenderType);
    }

    @Override
    public void preOpaque() {
        if (!GL46FeedbackDrawing.hasBatch()) {
            return;
        }
        BufferUploader.m_231208_();
        IrisDetection.bindIrisFramebuffer();
        GL46FeedbackDrawing.setMatrices(RenderSystem.getProjectionMatrix(), this.drawInfo.mojPose.m_252922_());
        for (RenderType renderType : GL46FeedbackDrawing.getActiveRenderTypes()) {
            if (!(renderType instanceof RenderType.CompositeRenderType)) continue;
            RenderType.CompositeRenderType compositeRenderType = (RenderType.CompositeRenderType)renderType;
            if (compositeRenderType.m_173265_().f_110577_ != RenderStateShard.f_110134_) continue;
            GL46FeedbackDrawing.drawRenderType(renderType);
        }
    }

    @Override
    public void endOpaque() {
        if (!GL46FeedbackDrawing.hasBatch()) {
            return;
        }
        BufferUploader.m_231208_();
        for (RenderType renderType : GL46FeedbackDrawing.getActiveRenderTypes()) {
            if (!(renderType instanceof RenderType.CompositeRenderType)) continue;
            RenderType.CompositeRenderType compositeRenderType = (RenderType.CompositeRenderType)renderType;
            if (compositeRenderType.m_173265_().f_110577_ == RenderStateShard.f_110134_) continue;
            RenderSystem.depthMask((boolean)false);
            GL46FeedbackDrawing.drawRenderType(renderType);
        }
        RenderSystem.depthMask((boolean)true);
    }

    @Override
    public void endTranslucent() {
    }

    @Override
    public void waitIdle() {
        GL46C.glFinish();
    }

    @Override
    public int frameInFlight() {
        return this.frameInFlight;
    }

    @Override
    public void sectionDirty(int x, int y, int z) {
        GL46LightEngine.sectionDirty(x, y, z);
    }

    @Override
    public void addDebugText(List<String> list) {
        list.add("Quartz backend: OpenGL 4.6");
        list.add("Spare texture: " + (GL46Statics.SPARSE_TEXTURE_ENABLED ? "enabled" : "disabled"));
    }

    static {
        if (GL46Statics.AVAILABLE) {
            try {
                LOGGER.info("Quartz initializing GL46Core");
                KHRDebug.glPushDebugGroup((int)33353, (int)0, (CharSequence)"Quartz GL46 Renderer Setup");
                INSTANCE = new GL46Core();
                LOGGER.info("Quartz GL46Core initialized");
            }
            finally {
                KHRDebug.glPopDebugGroup();
            }
        } else {
            INSTANCE = null;
            LOGGER.info("GL46 not available");
        }
    }
}

