/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.gl33;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.roguelogix.quartz.DrawBatch;
import net.roguelogix.quartz.internal.Buffer;
import net.roguelogix.quartz.internal.IrisDetection;
import net.roguelogix.quartz.internal.QuartzCore;
import net.roguelogix.quartz.internal.common.B3DStateHelper;
import net.roguelogix.quartz.internal.gl33.GL33Buffer;
import net.roguelogix.quartz.internal.gl33.GL33ComputePrograms;
import net.roguelogix.quartz.internal.gl33.GL33Core;
import net.roguelogix.quartz.internal.gl33.GL33FeedbackPrograms;
import net.roguelogix.quartz.internal.gl33.GL33LightEngine;
import net.roguelogix.quartz.internal.gl33.batching.GL33DrawBatch;
import net.roguelogix.quartz.internal.util.PointerWrapper;
import net.roguelogix.quartz.internal.util.ShitMojangShouldHaveButDoesnt;
import net.roguelogix.quartz.internal.util.VertexFormatOutput;
import org.joml.Matrix4f;
import org.joml.Vector3fc;
import org.joml.Vector3ic;
import org.lwjgl.opengl.GL33C;

public class GL33FeedbackDrawing {
    private static final ReferenceArrayList<WeakReference<GL33DrawBatch>> drawBatches = new ReferenceArrayList();
    private static final Reference2IntMap<RenderType> renderTypeUsages = new Reference2IntArrayMap();
    private static final Reference2IntMap<RenderType> renderTypeDrawnVertices = new Reference2IntArrayMap();
    private static final ReferenceArrayList<RenderType> inUseRenderTypes = new ReferenceArrayList();
    private static final Object2ObjectMap<RenderType, FeedbackBuffer> renderTypeFeedbackBuffers = new Object2ObjectArrayMap();
    private static final Object2IntMap<RenderType> renderTypeDrawBuffer = new Object2IntArrayMap();
    private static Buffer.CallbackHandle rebuildCallbackHandle;
    private static final GL33Buffer UBOBuffer;
    private static final Buffer.Allocation UBOAllocation;
    private static Matrix4f projection;
    private static Matrix4f modelView;

    public static DrawBatch createDrawBatch() {
        GL33DrawBatch batcher = new GL33DrawBatch();
        WeakReference<GL33DrawBatch> ref = new WeakReference<GL33DrawBatch>(batcher);
        drawBatches.add(ref);
        QuartzCore.mainThreadClean(batcher, () -> drawBatches.remove((Object)ref));
        return batcher;
    }

    public static void setupVAO(int instanceDataBuffer, int instanceDataOffset) {
        B3DStateHelper.bindArrayBuffer(QuartzCore.INSTANCE.meshManager.vertexBuffer.as(GL33Buffer.class).handle());
        GL33C.glEnableVertexAttribArray((int)0);
        GL33C.glEnableVertexAttribArray((int)1);
        GL33C.glEnableVertexAttribArray((int)2);
        GL33C.glEnableVertexAttribArray((int)3);
        GL33C.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)32, (long)0L);
        GL33C.glVertexAttribIPointer((int)1, (int)1, (int)5124, (int)32, (long)12L);
        GL33C.glVertexAttribPointer((int)2, (int)2, (int)5126, (boolean)false, (int)32, (long)16L);
        GL33C.glVertexAttribPointer((int)3, (int)3, (int)5122, (boolean)true, (int)32, (long)24L);
        B3DStateHelper.bindArrayBuffer(instanceDataBuffer);
        GL33C.glEnableVertexAttribArray((int)4);
        GL33C.glEnableVertexAttribArray((int)5);
        GL33C.glEnableVertexAttribArray((int)8);
        GL33C.glEnableVertexAttribArray((int)9);
        GL33C.glEnableVertexAttribArray((int)10);
        GL33C.glEnableVertexAttribArray((int)11);
        GL33C.glEnableVertexAttribArray((int)12);
        GL33C.glEnableVertexAttribArray((int)13);
        GL33C.glEnableVertexAttribArray((int)14);
        GL33C.glVertexAttribDivisor((int)4, (int)1);
        GL33C.glVertexAttribDivisor((int)5, (int)1);
        GL33C.glVertexAttribDivisor((int)8, (int)1);
        GL33C.glVertexAttribDivisor((int)9, (int)1);
        GL33C.glVertexAttribDivisor((int)10, (int)1);
        GL33C.glVertexAttribDivisor((int)11, (int)1);
        GL33C.glVertexAttribDivisor((int)12, (int)1);
        GL33C.glVertexAttribDivisor((int)13, (int)1);
        GL33C.glVertexAttribDivisor((int)14, (int)1);
        GL33C.glVertexAttribIPointer((int)4, (int)3, (int)5124, (int)128, (long)(112 + instanceDataOffset));
        GL33C.glVertexAttribIPointer((int)5, (int)1, (int)5124, (int)128, (long)(124 + instanceDataOffset));
        GL33C.glVertexAttribPointer((int)8, (int)4, (int)5126, (boolean)false, (int)128, (long)(0 + instanceDataOffset));
        GL33C.glVertexAttribPointer((int)9, (int)4, (int)5126, (boolean)false, (int)128, (long)(16 + instanceDataOffset));
        GL33C.glVertexAttribPointer((int)10, (int)4, (int)5126, (boolean)false, (int)128, (long)(32 + instanceDataOffset));
        GL33C.glVertexAttribPointer((int)11, (int)4, (int)5126, (boolean)false, (int)128, (long)(48 + instanceDataOffset));
        GL33C.glVertexAttribPointer((int)12, (int)4, (int)5126, (boolean)false, (int)128, (long)(64 + instanceDataOffset));
        GL33C.glVertexAttribPointer((int)13, (int)4, (int)5126, (boolean)false, (int)128, (long)(80 + instanceDataOffset));
        GL33C.glVertexAttribPointer((int)14, (int)4, (int)5126, (boolean)false, (int)128, (long)(96 + instanceDataOffset));
    }

    public static void startup() {
        QuartzCore.INSTANCE.meshManager.vertexBuffer.addReallocCallback(false, buffer -> GL33FeedbackDrawing.rebuildAllVAOs());
    }

    public static void shutdown() {
        renderTypeFeedbackBuffers.values().forEach(FeedbackBuffer::delete);
    }

    public static void rebuildAllVAOs() {
        drawBatches.forEach(batchRef -> {
            GL33DrawBatch batch = (GL33DrawBatch)batchRef.get();
            if (batch != null) {
                batch.rebuildVAOs();
            }
        });
    }

    public static void addRenderTypeUse(RenderType renderType) {
        if (renderTypeUsages.put((Object)renderType, renderTypeUsages.getOrDefault((Object)renderType, 0) + 1) == 0) {
            inUseRenderTypes.add((Object)renderType);
        }
    }

    public static void removeRenderTypeUse(RenderType renderType) {
        int usages = renderTypeUsages.getInt((Object)renderType);
        if (usages == 1) {
            renderTypeUsages.removeInt((Object)renderType);
            inUseRenderTypes.remove((Object)renderType);
            FeedbackBuffer feedbackBuffer = (FeedbackBuffer)renderTypeFeedbackBuffers.remove((Object)renderType);
            if (feedbackBuffer != null) {
                feedbackBuffer.delete();
            }
            return;
        }
        renderTypeUsages.put((Object)renderType, usages - 1);
    }

    public static List<RenderType> getActiveRenderTypes() {
        return inUseRenderTypes;
    }

    public static boolean hasBatch() {
        return !drawBatches.isEmpty();
    }

    public static void beginFrame() {
        GL33C.glUseProgram((int)GL33ComputePrograms.dynamicMatrixProgram());
        for (WeakReference batchRef : drawBatches) {
            GL33DrawBatch batch = (GL33DrawBatch)batchRef.get();
            if (batch == null) {
                return;
            }
            batch.updateAndCull(GL33Core.INSTANCE.drawInfo);
        }
        GL33C.glBindTexture((int)35882, (int)0);
        GL33C.glBindBufferBase((int)35982, (int)0, (int)0);
        GL33C.glUseProgram((int)0);
    }

    public static void collectAllFeedback(boolean shadowsEnabled) {
        PointerWrapper UBOPointer = UBOAllocation.address();
        UBOPointer.putVector3i(0L, (Vector3ic)GL33Core.INSTANCE.drawInfo.playerPosition);
        UBOPointer.putVector3f(16L, (Vector3fc)GL33Core.INSTANCE.drawInfo.playerSubBlock);
        UBOPointer.putVector3i(32L, GL33LightEngine.lookupOffset());
        UBOPointer.putInt(44L, IrisDetection.areShadersActive() ? 1 : 0);
        UBOAllocation.dirty();
        UBOBuffer.flush();
        GL33C.glBindBufferBase((int)35345, (int)0, (int)UBOBuffer.handle());
        GL33LightEngine.bindIndex();
        renderTypeDrawBuffer.clear();
        for (RenderType renderType : inUseRenderTypes) {
            VertexFormatOutput outputFormat = VertexFormatOutput.of(renderType.m_110508_());
            int requiredVertices = 0;
            for (WeakReference batchRef : drawBatches) {
                GL33DrawBatch drawBatch = (GL33DrawBatch)batchRef.get();
                if (drawBatch == null) {
                    return;
                }
                requiredVertices += drawBatch.verticesForRenderType(renderType, shadowsEnabled);
            }
            renderTypeDrawnVertices.put((Object)renderType, requiredVertices);
            int requiredFeedbackBufferSize = requiredVertices * outputFormat.vertexSize();
            FeedbackBuffer buffer = (FeedbackBuffer)renderTypeFeedbackBuffers.get((Object)renderType);
            if (buffer == null || buffer.size < requiredFeedbackBufferSize) {
                if (buffer != null) {
                    buffer.delete();
                }
                buffer = new FeedbackBuffer(requiredFeedbackBufferSize);
                buffer.setupVAO(outputFormat);
                renderTypeFeedbackBuffers.put((Object)renderType, (Object)buffer);
            }
            GL33C.glUseProgram((int)GL33FeedbackPrograms.getProgramForOutputFormat(outputFormat));
            GL33C.glBindBufferBase((int)35982, (int)0, (int)buffer.buffer1);
            GL33C.glBeginTransformFeedback((int)0);
            for (WeakReference batchRef : drawBatches) {
                GL33DrawBatch drawBatch = (GL33DrawBatch)batchRef.get();
                if (drawBatch == null) {
                    return;
                }
                drawBatch.drawFeedback(renderType, shadowsEnabled);
            }
            GL33C.glEndTransformFeedback();
            IntIntPair program = GL33FeedbackPrograms.getPostProgramForOutputFormat(outputFormat);
            GL33C.glUseProgram((int)program.firstInt());
            int bufferToDraw = GL33LightEngine.drawForEachLayer(requiredVertices, program.secondInt(), buffer.buffer1, buffer.buffer2, buffer.VAO1, buffer.VAO2);
            renderTypeDrawBuffer.put((Object)renderType, bufferToDraw);
        }
        for (int j = 0; j < 8; ++j) {
            RenderSystem.activeTexture((int)(33984 + j));
            RenderSystem.bindTexture((int)0);
        }
        B3DStateHelper.bindVertexArray(0);
    }

    public static void setMatrices(Matrix4f projection, Matrix4f modelView) {
        GL33FeedbackDrawing.projection = projection;
        GL33FeedbackDrawing.modelView = modelView;
    }

    public static void drawRenderType(RenderType renderType) {
        int feedbackBuffer = renderTypeDrawBuffer.getInt((Object)renderType);
        if (feedbackBuffer == 0) {
            return;
        }
        int drawnVertices = renderTypeDrawnVertices.getInt((Object)renderType);
        if (drawnVertices == 0) {
            return;
        }
        B3DStateHelper.bindArrayBuffer(renderTypeDrawBuffer.getInt((Object)renderType));
        ShitMojangShouldHaveButDoesnt.drawRenderTypePreboundVertexBuffer(modelView, projection, renderType, drawnVertices);
    }

    static {
        UBOBuffer = new GL33Buffer(false);
        UBOAllocation = UBOBuffer.alloc(64);
    }

    private record FeedbackBuffer(int buffer1, int buffer2, int size, int VAO1, int VAO2) {
        private FeedbackBuffer(int size) {
            this(GL33C.glGenBuffers(), GL33C.glGenBuffers(), FeedbackBuffer.roundUpPo2(size), GL33C.glGenVertexArrays(), GL33C.glGenVertexArrays());
            GL33C.glBindBuffer((int)35982, (int)this.buffer1);
            GL33C.glBufferData((int)35982, (long)this.size, (int)35044);
            GL33C.glBindBuffer((int)35982, (int)this.buffer2);
            GL33C.glBufferData((int)35982, (long)this.size, (int)35044);
            GL33C.glBindBuffer((int)35982, (int)0);
        }

        void delete() {
            GL33C.glDeleteBuffers((int)this.buffer1);
            GL33C.glDeleteBuffers((int)this.buffer2);
            GL33C.glDeleteVertexArrays((int)this.VAO1);
            GL33C.glDeleteVertexArrays((int)this.VAO2);
        }

        void setupVAO(VertexFormatOutput formatOutput) {
            B3DStateHelper.bindVertexArray(this.VAO1);
            B3DStateHelper.bindArrayBuffer(this.buffer1);
            GL33FeedbackPrograms.setupVAOForPostProgramOutputFormat(formatOutput);
            B3DStateHelper.bindVertexArray(this.VAO2);
            B3DStateHelper.bindArrayBuffer(this.buffer2);
            GL33FeedbackPrograms.setupVAOForPostProgramOutputFormat(formatOutput);
            B3DStateHelper.bindArrayBuffer(0);
            B3DStateHelper.bindVertexArray(0);
        }

        private static int roundUpPo2(int minSize) {
            int size = Integer.highestOneBit(minSize);
            if (size < minSize) {
                size <<= 1;
            }
            return size;
        }
    }
}

