/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.gl33;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.quartz.QuartzConfig;
import net.roguelogix.quartz.internal.Buffer;
import net.roguelogix.quartz.internal.QuartzCore;
import net.roguelogix.quartz.internal.util.CallbackDeleter;
import net.roguelogix.quartz.internal.util.PointerWrapper;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.system.MathUtil;

@NonnullDefault
public class GL33Buffer
implements Buffer {
    private final boolean GPUOnly;
    private final int glBuffer;
    private int size;
    private PointerWrapper cpuBuffer = PointerWrapper.NULLPTR;
    private final PointerWrapper[] cpuBufferArray;
    private final ObjectArrayList<Allocation.Info> liveAllocations = new ObjectArrayList();
    private final ObjectArrayList<Allocation.Info> freeAllocations = new ObjectArrayList<Allocation.Info>(){

        public boolean add(@Nullable Allocation.Info allocation) {
            if (allocation == null) {
                return false;
            }
            int index = Collections.binarySearch(this, allocation);
            if (index < 0) {
                super.add(index ^= 0xFFFFFFFF, (Object)allocation);
            } else {
                super.set(index, (Object)allocation);
            }
            return true;
        }
    };
    private final ObjectArrayList<Consumer<Buffer>> reallocCallbacks = new ObjectArrayList();

    public GL33Buffer(boolean GPUOnly) {
        this(32768, GPUOnly);
    }

    public GL33Buffer(int initialSize, boolean GPUOnly) {
        this(initialSize, true, GPUOnly);
    }

    public GL33Buffer(int initialSize, boolean roundUpPo2, boolean GPUOnly) {
        this.GPUOnly = GPUOnly;
        if (roundUpPo2) {
            initialSize = MathUtil.mathRoundPoT((int)initialSize);
        }
        this.size = initialSize;
        int buffer = GL33C.glGenBuffers();
        PointerWrapper[] cpuBufArray = new PointerWrapper[1];
        GL33C.glBindBuffer((int)36663, (int)buffer);
        GL33C.glBufferData((int)36663, (long)initialSize, (int)35044);
        GL33C.glBindBuffer((int)36663, (int)0);
        cpuBufArray[0] = this.cpuBuffer = PointerWrapper.alloc(initialSize);
        this.freeAllocations.add((Object)new Allocation.Info(0, this.size));
        QuartzCore.mainThreadClean(this, () -> {
            if (cpuBufArray[0] != null) {
                cpuBufArray[0].free();
                GL33C.glDeleteBuffers((int)buffer);
            }
        });
        this.glBuffer = buffer;
        this.cpuBufferArray = cpuBufArray;
    }

    @Override
    public void delete() {
        GL33C.glDeleteBuffers((int)this.glBuffer);
        this.cpuBuffer.free();
        this.cpuBufferArray[0] = null;
    }

    public int handle() {
        return this.glBuffer;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Allocation alloc(int size, int alignment) {
        return new Allocation(this.allocSpace(size, alignment));
    }

    private Allocation.Info allocSpace(int size, int alignment) {
        for (int i = 0; i < this.freeAllocations.size(); ++i) {
            Allocation.Info attemptedAlloc = this.attemptAllocInSpace((Allocation.Info)this.freeAllocations.get(i), size, alignment);
            if (attemptedAlloc == null) continue;
            this.freeAllocations.remove(i);
            return attemptedAlloc;
        }
        int endOffset = this.size;
        int minSize = this.size + size;
        if (!this.freeAllocations.isEmpty()) {
            Allocation.Info endAlloc = (Allocation.Info)this.freeAllocations.get(this.freeAllocations.size() - 1);
            if (endAlloc.offset + endAlloc.size == this.size) {
                minSize -= endAlloc.size;
                endOffset = endAlloc.offset;
            }
        }
        int nextValidAlignment = endOffset + (alignment - 1) & -alignment;
        int alignmentWaste = nextValidAlignment - endOffset;
        this.expand(minSize += alignmentWaste);
        Allocation.Info attemptedAlloc = this.attemptAllocInSpace((Allocation.Info)this.freeAllocations.pop(), size, alignment);
        if (attemptedAlloc == null) {
            throw new IllegalStateException("Alloc failed even after expanding buffer");
        }
        return attemptedAlloc;
    }

    @Nullable
    private Allocation.Info attemptAllocInSpace(Allocation.Info freeAlloc, int size, int alignment) {
        int index;
        Pair<Allocation.Info, Allocation.Info> newAllocs;
        int nextValidAlignment = freeAlloc.offset + (alignment - 1) & -alignment;
        int alignmentWaste = nextValidAlignment - freeAlloc.offset;
        if (freeAlloc.size - alignmentWaste < size) {
            return null;
        }
        boolean collapse = false;
        if (alignmentWaste > 0) {
            newAllocs = freeAlloc.split(alignmentWaste);
            this.freeAllocations.add((Object)((Allocation.Info)newAllocs.getFirst()));
            freeAlloc = (Allocation.Info)newAllocs.getSecond();
            index = this.freeAllocations.indexOf(newAllocs.getFirst());
            this.collapseFreeAllocationWithNext(index - 1);
            this.collapseFreeAllocationWithNext(index);
        }
        if (freeAlloc.size > size) {
            newAllocs = freeAlloc.split(size);
            freeAlloc = (Allocation.Info)newAllocs.getFirst();
            this.freeAllocations.add((Object)((Allocation.Info)newAllocs.getSecond()));
            index = this.freeAllocations.indexOf(newAllocs.getSecond());
            this.collapseFreeAllocationWithNext(index - 1);
            this.collapseFreeAllocationWithNext(index);
        }
        this.liveAllocations.add((Object)freeAlloc);
        return freeAlloc;
    }

    @Override
    public Allocation realloc(@Nullable Buffer.Allocation bufAlloc, int newSize, int alignment, boolean copyData) {
        if (!(bufAlloc instanceof Allocation)) {
            throw new IllegalArgumentException("Cannot realloc allocation from another buffer");
        }
        Allocation alloc = (Allocation)bufAlloc;
        return this.realloc(alloc, newSize, alignment, copyData);
    }

    public Allocation realloc(@Nullable Allocation allocation, int newSize, int alignment, boolean copyData) {
        if (allocation == null) {
            return this.alloc(newSize, alignment);
        }
        if (allocation.allocator() != this) {
            throw new IllegalArgumentException("Cannot realloc allocation from another buffer");
        }
        int liveIndex = this.liveAllocations.indexOf((Object)allocation.info);
        if (liveIndex == -1) {
            throw new IllegalArgumentException("Cannot realloc non-live allocation");
        }
        if (newSize <= allocation.info.size && (allocation.info.offset & alignment - 1) == 0) {
            if (newSize == allocation.info.size) {
                return allocation;
            }
            Allocation.Info removed = (Allocation.Info)this.liveAllocations.pop();
            if (liveIndex != this.liveAllocations.size()) {
                this.liveAllocations.set(liveIndex, (Object)removed);
            }
            Pair<Allocation.Info, Allocation.Info> newAllocInfos = allocation.info.split(newSize);
            Allocation.Info newAllocInfo = (Allocation.Info)newAllocInfos.getFirst();
            Allocation.Info freeAllocInfo = (Allocation.Info)newAllocInfos.getSecond();
            this.freeAllocations.add((Object)freeAllocInfo);
            int index = this.freeAllocations.indexOf((Object)freeAllocInfo);
            this.collapseFreeAllocationWithNext(index - 1);
            this.collapseFreeAllocationWithNext(index);
            this.liveAllocations.add((Object)newAllocInfo);
            return new Allocation(allocation, newAllocInfo, copyData);
        }
        Allocation.Info precedingAlloc = null;
        Allocation.Info followingAlloc = null;
        for (int i = 0; i < this.freeAllocations.size(); ++i) {
            Allocation.Info freeAllocation = (Allocation.Info)this.freeAllocations.get(i);
            if (freeAllocation.offset + freeAllocation.size == allocation.info.offset) {
                precedingAlloc = freeAllocation;
                continue;
            }
            if (freeAllocation.offset == allocation.info.offset + allocation.info.size) {
                followingAlloc = freeAllocation;
                break;
            }
            if (freeAllocation.offset > allocation.info.offset) break;
        }
        int fullBlockOffset = precedingAlloc == null ? allocation.info.offset : precedingAlloc.offset;
        int nextValidAlignment = fullBlockOffset + (alignment - 1) & -alignment;
        int alignmentWaste = nextValidAlignment - fullBlockOffset;
        int fullBlockSize = allocation.info.size;
        if (precedingAlloc != null) {
            fullBlockSize += precedingAlloc.size;
        }
        if (followingAlloc != null) {
            fullBlockSize += followingAlloc.size;
        } else if (allocation.info.offset + allocation.info.size == this.size) {
            this.freeAllocations.remove((Object)precedingAlloc);
            int minSize = fullBlockOffset + alignmentWaste + newSize;
            this.expand(minSize);
            followingAlloc = (Allocation.Info)this.freeAllocations.get(this.freeAllocations.size() - 1);
            fullBlockSize += followingAlloc.size;
        }
        if (fullBlockSize - alignmentWaste >= newSize) {
            Allocation.Info newAllocInfo;
            this.freeAllocations.remove((Object)precedingAlloc);
            this.freeAllocations.remove((Object)followingAlloc);
            Allocation.Info removed = (Allocation.Info)this.liveAllocations.pop();
            if (liveIndex != this.liveAllocations.size()) {
                this.liveAllocations.set(liveIndex, (Object)removed);
            }
            if ((newAllocInfo = this.attemptAllocInSpace(new Allocation.Info(fullBlockOffset, fullBlockSize), newSize, alignment)) == null) {
                throw new IllegalStateException("Realloc failed in guaranteed space");
            }
            return new Allocation(allocation, newAllocInfo, copyData);
        }
        this.free(allocation);
        return new Allocation(allocation, this.allocSpace(newSize, alignment), copyData);
    }

    @Override
    public void free(Buffer.Allocation allocation) {
        if (allocation instanceof Allocation) {
            Allocation alloc = (Allocation)allocation;
            this.free(alloc);
        }
    }

    public void free(Allocation allocation) {
        allocation.bufferRealloc.delete();
        if (!allocation.freed[0]) {
            allocation.freed[0] = true;
            this.free(allocation.info);
        }
    }

    private void free(Allocation.Info allocation) {
        int index = this.liveAllocations.indexOf((Object)allocation);
        if (index == -1) {
            return;
        }
        Allocation.Info removed = (Allocation.Info)this.liveAllocations.pop();
        if (index != this.liveAllocations.size()) {
            this.liveAllocations.set(index, (Object)removed);
        }
        this.freeAllocations.add((Object)allocation);
        index = this.freeAllocations.indexOf((Object)allocation);
        this.collapseFreeAllocationWithNext(index - 1);
        this.collapseFreeAllocationWithNext(index);
    }

    @Override
    public void dirtyAll() {
    }

    public void flush() {
        GL33C.glBindBuffer((int)36663, (int)this.glBuffer);
        GL33C.nglBufferSubData((int)36663, (long)0L, (long)this.cpuBuffer.size(), (long)this.cpuBuffer.pointer());
        GL33C.glBindBuffer((int)36663, (int)0);
    }

    @Override
    public Buffer.CallbackHandle addReallocCallback(boolean callImmediately, Consumer<Buffer> consumer) {
        if (callImmediately) {
            consumer.accept(this);
        }
        ObjectArrayList<Consumer<Buffer>> callbacks = this.reallocCallbacks;
        callbacks.add(consumer);
        return new CallbackDeleter(() -> callbacks.remove((Object)consumer));
    }

    public void expand(int minSize) {
        if (this.size >= minSize) {
            return;
        }
        int oldSize = this.size;
        int newSize = Integer.highestOneBit(minSize);
        if (newSize < minSize) {
            newSize <<= 1;
        }
        this.cpuBufferArray[0] = this.cpuBuffer = this.cpuBuffer.realloc(newSize);
        GL33C.glBindBuffer((int)36663, (int)this.glBuffer);
        GL33C.nglBufferData((int)36663, (long)this.cpuBuffer.size(), (long)this.cpuBuffer.pointer(), (int)35044);
        GL33C.glBindBuffer((int)36663, (int)0);
        this.size = newSize;
        this.freeAllocations.add((Object)new Allocation.Info(oldSize, newSize - oldSize));
        this.collapseFreeAllocationWithNext(this.freeAllocations.size() - 2);
        this.reallocCallbacks.forEach(c -> c.accept(this));
    }

    private boolean collapseFreeAllocationWithNext(int freeAllocationIndex) {
        if (freeAllocationIndex < 0 || freeAllocationIndex >= this.freeAllocations.size() - 1) {
            return false;
        }
        Allocation.Info allocA = (Allocation.Info)this.freeAllocations.get(freeAllocationIndex);
        Allocation.Info allocB = (Allocation.Info)this.freeAllocations.get(freeAllocationIndex + 1);
        if (allocA.offset + allocA.size == allocB.offset) {
            this.freeAllocations.remove(freeAllocationIndex + 1);
            this.freeAllocations.remove(freeAllocationIndex);
            this.freeAllocations.add((Object)new Allocation.Info(allocA.offset, allocA.size + allocB.size));
            return true;
        }
        return false;
    }

    public class Allocation
    implements Buffer.Allocation {
        private final Info info;
        @Nullable
        private PointerWrapper cpuAddress;
        private final boolean[] freed;
        private final Buffer.CallbackHandle bufferRealloc;
        private final ReferenceArrayList<Consumer<Buffer.Allocation>> reallocCallbacks;

        private Allocation(Info info) {
            this((ReferenceArrayList<Consumer<Buffer.Allocation>>)new ReferenceArrayList(), info);
        }

        private Allocation(Allocation allocation, Info info, boolean copyData) {
            this(allocation.reallocCallbacks, info);
            allocation.bufferRealloc.delete();
            allocation.freed[0] = true;
            if (copyData && allocation.info.offset != info.offset) {
                allocation.copy(0, this, 0, Math.min(allocation.info.size, info.size));
            }
            for (int i = 0; i < this.reallocCallbacks.size(); ++i) {
                ((Consumer)this.reallocCallbacks.get(i)).accept(this);
            }
        }

        private Allocation(ReferenceArrayList<Consumer<Buffer.Allocation>> reallocCallbacks, Info info) {
            GL33Buffer allocator = GL33Buffer.this;
            WeakReference<Allocation> weakRef = new WeakReference<Allocation>(this);
            Buffer.CallbackHandle bufferRealloc = GL33Buffer.this.addReallocCallback(false, e -> {
                Allocation ref = (Allocation)weakRef.get();
                if (ref == null) {
                    return;
                }
                ref.cpuAddress = null;
                for (int i = 0; i < reallocCallbacks.size(); ++i) {
                    Consumer callback = (Consumer)reallocCallbacks.get(i);
                    callback.accept(ref);
                }
            });
            boolean[] freed = new boolean[]{false};
            Exception allocationPoint = QuartzConfig.INSTANCE.debug ? new Exception() : null;
            QuartzCore.mainThreadClean(this, () -> {
                bufferRealloc.delete();
                if (!freed[0]) {
                    freed[0] = true;
                    if (allocationPoint != null) {
                        allocationPoint.printStackTrace();
                    }
                    allocator.free(info);
                }
            });
            this.info = info;
            this.freed = freed;
            this.bufferRealloc = bufferRealloc;
            this.reallocCallbacks = reallocCallbacks;
        }

        @Override
        public PointerWrapper address() {
            if (this.cpuAddress == null) {
                this.cpuAddress = GL33Buffer.this.GPUOnly ? PointerWrapper.NULLPTR : GL33Buffer.this.cpuBuffer.slice(this.info.offset(), this.info.size());
            }
            return this.cpuAddress;
        }

        @Override
        public int offset() {
            return this.info.offset();
        }

        @Override
        public int size() {
            return this.info.size();
        }

        @Override
        public void dirtyRange(int offset, int size) {
        }

        @Override
        public GL33Buffer allocator() {
            return GL33Buffer.this;
        }

        @Override
        public void copy(int srcOffset, int dstOffset, int size) {
            this.copy(srcOffset, this, dstOffset, size);
        }

        public void copy(Allocation dstAlloc) {
            this.copy(0, dstAlloc, 0, Math.min(this.size(), dstAlloc.size()));
        }

        public void copy(int srcOffset, Allocation dstAlloc, int dstOffset, int size) {
            GL33Buffer dstAllocator = dstAlloc.allocator();
            if (GL33Buffer.this.GPUOnly && !dstAllocator.GPUOnly) {
                throw new IllegalStateException("Cannot copy from GPU buffer to CPU buffer");
            }
            if (dstAllocator.GPUOnly) {
                if (!GL33Buffer.this.GPUOnly) {
                    GL33Buffer.this.flush();
                }
                Allocation.glCopy(GL33Buffer.this.handle(), srcOffset += this.offset(), dstAllocator.handle(), dstOffset += dstAlloc.offset(), size);
            } else {
                this.address().copyTo(srcOffset, dstAlloc.address(), dstOffset, size);
            }
        }

        public static void glCopy(int srcBuffer, int srcOffset, int dstBuffer, int dstOffset, int size) {
            boolean overlaps = srcOffset == dstOffset;
            overlaps |= srcOffset < dstOffset && dstOffset < srcOffset + size;
            overlaps |= dstOffset < srcOffset && srcOffset < dstOffset + size;
            boolean bl = srcBuffer == dstBuffer;
            GL33C.glBindBuffer((int)36662, (int)srcBuffer);
            GL33C.glBindBuffer((int)36663, (int)dstBuffer);
            if (!(overlaps &= bl)) {
                GL33C.glCopyBufferSubData((int)36662, (int)36663, (long)srcOffset, (long)dstOffset, (long)size);
            } else {
                boolean forward;
                if (dstOffset == srcOffset) {
                    throw new IllegalArgumentException();
                }
                boolean bl2 = forward = dstOffset < srcOffset;
                if (forward) {
                    int toCopy;
                    int nonOverlappingRegionSize = srcOffset - dstOffset;
                    int currentCopyOffset = 0;
                    for (int leftToCopy = size; leftToCopy > 0; leftToCopy -= toCopy) {
                        toCopy = Math.min(nonOverlappingRegionSize, leftToCopy);
                        GL33C.glCopyBufferSubData((int)36662, (int)36663, (long)(srcOffset + currentCopyOffset), (long)(dstOffset + currentCopyOffset), (long)toCopy);
                        currentCopyOffset += toCopy;
                    }
                } else {
                    int toCopy;
                    int nonOverlappingRegionSize = dstOffset - srcOffset;
                    int currentCopyOffset = 0;
                    for (int leftToCopy = size; leftToCopy > 0; leftToCopy -= toCopy) {
                        toCopy = Math.min(nonOverlappingRegionSize, leftToCopy);
                        GL33C.glCopyBufferSubData((int)36662, (int)36663, (long)(srcOffset + (currentCopyOffset -= toCopy)), (long)(dstOffset + currentCopyOffset), (long)toCopy);
                    }
                }
            }
            GL33C.glBindBuffer((int)36662, (int)0);
            GL33C.glBindBuffer((int)36663, (int)0);
        }

        @Override
        public Buffer.CallbackHandle addReallocCallback(Consumer<Buffer.Allocation> consumer) {
            ReferenceArrayList<Consumer<Buffer.Allocation>> callbacks = this.reallocCallbacks;
            callbacks.add(consumer);
            return new CallbackDeleter(() -> callbacks.remove((Object)consumer));
        }

        private record Info(int offset, int size) implements Comparable<Info>
        {
            public Info(Info a, Info b) {
                this(a.offset, a.size + b.size);
                if (a.offset + a.size != b.offset) {
                    throw new IllegalStateException("Cannot combine non-consecutive alloc infos");
                }
            }

            @Override
            public int compareTo(Info info) {
                return Integer.compare(this.offset, info.offset);
            }

            private Pair<Info, Info> split(int size) {
                if (size > this.size) {
                    throw new IllegalArgumentException("Cannot split allocation to larger size");
                }
                if (size == this.size) {
                    return new Pair((Object)new Info(this.offset, size), null);
                }
                return new Pair((Object)new Info(this.offset, size), (Object)new Info(this.offset + size, this.size - size));
            }
        }
    }
}

