/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.variables;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableProvider;
import me.desht.pneumaticcraft.common.variables.GlobalVariableManager;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;

public class GlobalVariableHelper {
    public static BlockPos getPos(@Nullable UUID id, String varName, BlockPos def) {
        GlobalVariableManager gvm = GlobalVariableManager.getInstance();
        if (varName.startsWith("%")) {
            return gvm.hasPos(varName.substring(1)) ? gvm.getPos(varName.substring(1)) : def;
        }
        if (id == null) {
            Log.warning("querying player-global var %s with no player context?", varName);
            return def;
        }
        if (varName.startsWith("#")) {
            varName = varName.substring(1);
        }
        return gvm.hasPos(id, varName) ? gvm.getPos(id, varName) : def;
    }

    public static BlockPos getPos(@Nullable UUID id, String varName) {
        return GlobalVariableHelper.getPos(id, varName, null);
    }

    public static ItemStack getStack(@Nullable UUID id, String varName, ItemStack def) {
        GlobalVariableManager gvm = GlobalVariableManager.getInstance();
        if (varName.startsWith("%")) {
            return gvm.hasStack(varName.substring(1)) ? gvm.getStack(varName.substring(1)) : def;
        }
        if (id == null) {
            Log.warning("querying player-global var %s with no player context?", varName);
            return def;
        }
        if (varName.startsWith("#")) {
            varName = varName.substring(1);
        }
        return gvm.hasStack(id, varName) ? gvm.getStack(id, varName) : def;
    }

    public static ItemStack getStack(@Nullable UUID id, String varName) {
        return GlobalVariableHelper.getStack(id, varName, ItemStack.f_41583_);
    }

    public static void setPos(UUID id, String varName, BlockPos pos) {
        GlobalVariableManager gvm = GlobalVariableManager.getInstance();
        if (varName.startsWith("#") && id != null) {
            gvm.setPos(id, varName.substring(1), pos);
        } else if (varName.startsWith("%")) {
            gvm.setPos(varName.substring(1), pos);
        } else if (id != null) {
            gvm.setPos(id, varName, pos);
        }
    }

    public static void setStack(UUID id, String varName, ItemStack stack) {
        GlobalVariableManager gvm = GlobalVariableManager.getInstance();
        if (varName.startsWith("#") && id != null) {
            gvm.setStack(id, varName.substring(1), stack);
        } else if (varName.startsWith("%")) {
            gvm.setStack(varName.substring(1), stack);
        } else if (id != null) {
            gvm.setStack(id, varName, stack);
        }
    }

    public static boolean getBool(UUID id, String varName) {
        return GlobalVariableHelper.getInt(id, varName) != 0;
    }

    public static int getInt(UUID id, String varName) {
        return GlobalVariableHelper.getPos(id, varName, BlockPos.f_121853_).m_123341_();
    }

    public static String getPrefixedVar(String varName, boolean playerGlobal) {
        return varName.isEmpty() ? "" : GlobalVariableHelper.getVarPrefix(playerGlobal) + varName;
    }

    public static String getVarPrefix(boolean playerGlobal) {
        return playerGlobal ? "#" : "%";
    }

    public static String stripVarPrefix(String varName) {
        return GlobalVariableHelper.hasPrefix(varName) ? varName.substring(1) : varName;
    }

    public static boolean hasPrefix(String varName) {
        return varName.length() > 1 && (varName.startsWith("#") || varName.startsWith("%"));
    }

    public static List<String> extractVarnames(String[] varnames, boolean playerGlobal) {
        return Arrays.stream(varnames).filter(v -> playerGlobal && v.startsWith("#") || !playerGlobal && v.startsWith("%")).map(v -> v.substring(1)).collect(Collectors.toList());
    }

    public static IVariableProvider getVariableProvider() {
        return VariableProviderWrapper.INSTANCE;
    }

    private static enum VariableProviderWrapper implements IVariableProvider
    {
        INSTANCE;


        @Override
        public Optional<BlockPos> getCoordinate(UUID id, String varName) {
            return Optional.ofNullable(GlobalVariableHelper.getPos(id, varName));
        }

        @Override
        @Nonnull
        public ItemStack getStack(UUID id, String varName) {
            return GlobalVariableHelper.getStack(id, varName);
        }
    }
}

